/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.cdf2_4;

import JSci.maths.ArrayMath;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.Multiresolution;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.cdf2_4.DualScaling2_4;
import JSci.maths.wavelet.cdf2_4.DualWavelet2_4;
import JSci.maths.wavelet.cdf2_4.MultiSpline2_4;

public final class CDF2_4
extends Multiresolution
implements Filter {
    protected static final int filtretype = 1;
    protected static final int minlength = 5;
    static final double[] vg = new double[]{0.046875, -0.09375, -0.25, 0.59375, 1.40625, 0.59375, -0.25, -0.09375, 0.046875};
    static final double[] v3 = new double[]{-0.01953125, 0.0390625, 0.015625, -0.0703125, -0.26171875, 0.59375, 1.40625, 0.59375, -0.25, -0.09375, 0.046875};
    static final double[] v2 = new double[]{0.10677083333333333, -0.21354166666666666, -0.13541666666666666, 0.484375, 1.4609375, 0.59375, -0.25, -0.09375, 0.046875};
    static final double[] v1 = new double[]{-0.3138020833333333, 0.6276041666666666, 1.2760416666666667, 0.8203125, -0.36328125, -0.09375, 0.046875};
    static final double[] v0 = new double[]{1.453125, 1.09375, -0.3125, -0.46875, 0.234375};
    static final double[] vd0 = ArrayMath.invert((double[])v0);
    static final double[] vd1 = ArrayMath.invert((double[])v1);
    static final double[] vd2 = ArrayMath.invert((double[])v2);
    static final double[] vd3 = ArrayMath.invert((double[])v3);
    static final double[] phvg = new double[]{-0.5, 1.0, -0.5};
    static final double[] phv0 = new double[]{1.0, -0.5};

    public int getFilterType() {
        return 1;
    }

    public MultiscaleFunction primaryScaling(int n, int n2) {
        return MultiSpline2_4.hat(n, n2);
    }

    public MultiscaleFunction dualScaling(int n, int n2) {
        return new DualScaling2_4(n, n2);
    }

    public MultiscaleFunction primaryWavelet(int n, int n2) {
        return MultiSpline2_4.wavelet(n, n2);
    }

    public MultiscaleFunction dualWavelet(int n, int n2) {
        return new DualWavelet2_4(n, n2);
    }

    public int previousDimension(int n) {
        int n2 = (int)Math.round((double)(n + 1) / 2.0);
        if (2 * n2 - 1 == n) {
            return n2;
        }
        throw new IllegalScalingException("Even number of values into an odd Filter! Change the number of iterations/values.");
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        int n;
        if (dArray.length < 8) {
            throw new IllegalScalingException("The array is not long enough : " + dArray.length + " < 8");
        }
        double[] dArray2 = new double[2 * dArray.length - 1];
        int n2 = dArray.length - 1;
        int n3 = 4;
        while (n3 <= n2 - 4) {
            n = -4;
            while (n <= 4) {
                int n4 = 2 * n3 + n;
                dArray2[n4] = dArray2[n4] + vg[n + 4] * dArray[n3];
                ++n;
            }
            ++n3;
        }
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[0], (double[])v0, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[1], (double[])v1, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[2], (double[])v2, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[3], (double[])v3, (int)0);
        n = dArray2.length - vd0.length;
        int n5 = dArray2.length - vd1.length;
        int n6 = dArray2.length - vd2.length;
        int n7 = dArray2.length - vd3.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2], (double[])vd0, (int)n);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 1], (double[])vd1, (int)n5);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 2], (double[])vd2, (int)n6);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 3], (double[])vd3, (int)n7);
        return dArray2;
    }

    public double[] highpass(double[] dArray) {
        if (dArray.length < 2) {
            throw new IllegalScalingException("The array is not long enough : " + dArray.length + " < 2");
        }
        double[] dArray2 = Cascades.supersample(dArray);
        int n = dArray2.length - 1;
        double[] dArray3 = new double[dArray2.length];
        int n2 = 1;
        while (n2 <= n - 1) {
            dArray3[n2] = ArrayMath.scalarProduct((double[])ArrayMath.extract((int)(n2 - 1), (int)(n2 + 1), (double[])dArray2), (double[])phvg);
            ++n2;
        }
        dArray3[0] = ArrayMath.scalarProduct((double[])ArrayMath.extract((int)0, (int)1, (double[])dArray2), (double[])phv0);
        dArray3[n] = ArrayMath.scalarProduct((double[])ArrayMath.extract((int)n, (int)(n - 1), (double[])dArray2), (double[])phv0);
        return dArray3;
    }

    public double[] evalScaling(int n, int n2, int n3) {
        return Cascades.evalScaling(this, n, n3, n2);
    }

    public double[] evalWavelet(int n, int n2, int n3) {
        return Cascades.evalWavelet(this, n, n3, n2);
    }
}

