/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.cdf2_4;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.cdf2_4.CDF2_4;

public final class DualScaling2_4
extends MultiscaleFunction
implements Cloneable {
    int n0;
    int k;
    static CDF2_4 cdf = new CDF2_4();

    public boolean equals(Object object) {
        if (object != null && object instanceof DualScaling2_4) {
            DualScaling2_4 dualScaling2_4 = (DualScaling2_4)object;
            return Cascades.dimension(this.n0, 0) == Cascades.dimension(dualScaling2_4.n0, 0) && this.k == dualScaling2_4.k;
        }
        return false;
    }

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public int getFilterType() {
        return 1;
    }

    public DualScaling2_4(int n, int n2) {
        this.setParameters(n, n2);
    }

    public Object clone() {
        DualScaling2_4 dualScaling2_4 = (DualScaling2_4)super.clone();
        dualScaling2_4.n0 = this.n0;
        dualScaling2_4.k = this.k;
        return dualScaling2_4;
    }

    public DualScaling2_4() {
    }

    public void setParameters(int n, int n2) {
        if (n < 5) {
            throw new IllegalScalingException(n, 5);
        }
        this.n0 = n;
        this.k = n2;
    }

    public double[] evaluate(int n) {
        CDF2_4 cDF2_4 = cdf;
        int n2 = this.n0;
        int n3 = this.k;
        return Cascades.evalScaling(cDF2_4, n2, n, n3);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n);
    }

    public int dimension() {
        return this.n0;
    }

    public int position() {
        return this.k;
    }
}

