/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.cdf2_4;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.cdf2_4.CDF2_4;

public final class DualWavelet2_4
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static CDF2_4 cdf = new CDF2_4();

    public boolean equals(Object object) {
        if (object != null && object instanceof DualWavelet2_4) {
            DualWavelet2_4 dualWavelet2_4 = (DualWavelet2_4)object;
            return Cascades.dimension(this.n0, 1) == Cascades.dimension(dualWavelet2_4.n0, 1) && this.k == dualWavelet2_4.k;
        }
        return false;
    }

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public int getFilterType() {
        return 1;
    }

    public DualWavelet2_4(int n, int n2) {
        this.setParameters(n, n2);
    }

    public DualWavelet2_4() {
    }

    public void setParameters(int n, int n2) {
        if (n < 5) {
            throw new IllegalScalingException(n, 5);
        }
        this.n0 = n;
        this.k = n2;
    }

    public Object clone() {
        DualWavelet2_4 dualWavelet2_4 = (DualWavelet2_4)super.clone();
        dualWavelet2_4.n0 = this.n0;
        dualWavelet2_4.k = this.k;
        return dualWavelet2_4;
    }

    public double[] evaluate(int n) {
        CDF2_4 cDF2_4 = cdf;
        int n2 = this.n0;
        int n3 = this.k;
        return Cascades.evalWavelet(cDF2_4, n2, n, n3);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n + 1);
    }

    public int dimension() {
        return Cascades.dimension(this.n0, 1);
    }

    public int position() {
        return this.k;
    }
}

