/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.cdf3_5;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.cdf3_5.CDF3_5;

public final class DualWavelet3_5
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static CDF3_5 cdf = new CDF3_5();

    public DualWavelet3_5(int n, int n2) {
        this.setParameters(n, n2);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DualWavelet3_5) {
            DualWavelet3_5 dualWavelet3_5 = (DualWavelet3_5)object;
            return Cascades.dimension(this.n0, 1, 2) == Cascades.dimension(dualWavelet3_5.n0, 1, 2) && this.k == dualWavelet3_5.k;
        }
        return false;
    }

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public int getFilterType() {
        return 2;
    }

    public DualWavelet3_5() {
    }

    public void setParameters(int n, int n2) {
        if (n < 12) {
            throw new IllegalScalingException(n, 12);
        }
        this.n0 = n;
        this.k = n2;
    }

    public Object clone() {
        DualWavelet3_5 dualWavelet3_5 = (DualWavelet3_5)super.clone();
        dualWavelet3_5.n0 = this.n0;
        dualWavelet3_5.k = this.k;
        return dualWavelet3_5;
    }

    public double[] evaluate(int n) {
        CDF3_5 cDF3_5 = cdf;
        int n2 = this.n0;
        int n3 = this.k;
        return Cascades.evalWaveletQuadratic(cDF3_5, n2, n, n3);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n + 1, 2);
    }

    public int dimension() {
        return Cascades.dimension(this.n0, 1, 2);
    }

    public int position() {
        return this.k;
    }
}

