/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.cdf3_5;

import JSci.maths.ArrayMath;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.splines.QuadraticSpline;

public final class MultiSpline3_5
implements Filter {
    static final double[] vg = new double[]{0.25, 0.75, 0.75, 0.25};
    static final double[] v0 = new double[]{0.75, 0.25};
    static final double[] og = new double[]{0.0048828125, 0.0146484375, -0.0185546875, -0.0947265625, 0.025390625, 0.341796875, -0.341796875, -0.025390625, 0.0947265625, 0.0185546875, -0.0146484375, -0.0048828125};
    static final double[] o0 = new double[]{-0.77314453125, 0.28095703125, -0.1298486328125, -0.0055615234375, 0.038583984375, 0.002587890625, -0.0110107421875, -0.0022119140625, 0.001640625, 5.46875E-4};
    static final double[] o1 = new double[]{0.60908203125, -0.11689453125, -0.1900732421875, 0.3895458984375, -0.223740234375, -0.029931640625, 0.0481201171875, 0.0104150390625, -0.006328125, -0.002109375};
    static final double[] o2 = new double[]{-0.68603515625, 0.10009765625, 0.23994954427083334, -0.2664794921875, -0.198486328125, 0.4439290364583333, -0.1702880859375, -0.0411376953125, 0.017578125, 0.005859375};
    static final double[] on0_1 = ArrayMath.scalarMultiply((double)-1.0, (double[])ArrayMath.invert((double[])o0));
    static final double[] on0_2 = ArrayMath.scalarMultiply((double)-1.0, (double[])ArrayMath.invert((double[])o1));
    static final double[] on0_3 = ArrayMath.scalarMultiply((double)-1.0, (double[])ArrayMath.invert((double[])o2));

    public int previousDimension(int n) {
        int n2 = (int)Math.round((double)(n - 2) / 2.0 + 2.0);
        if (2 * (n2 - 2) + 2 == n) {
            return n2;
        }
        throw new IllegalScalingException("Odd number of values into an even Filter. Please change the number of values/iterations: " + n);
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        if (dArray.length < 3) {
            throw new IllegalScalingException("The array is not long enough : " + dArray.length + " < 3");
        }
        double[] dArray2 = new double[2 * dArray.length - 2];
        int n = 1;
        while (n < dArray.length - 1) {
            int n2 = 2 * n - 2;
            dArray2[n2] = dArray2[n2] + dArray[n] * vg[0];
            int n3 = 2 * n - 1;
            dArray2[n3] = dArray2[n3] + dArray[n] * vg[1];
            int n4 = 2 * n;
            dArray2[n4] = dArray2[n4] + dArray[n] * vg[2];
            int n5 = 2 * n + 1;
            dArray2[n5] = dArray2[n5] + dArray[n] * vg[3];
            ++n;
        }
        dArray2[0] = dArray2[0] + v0[0] * dArray[0];
        dArray2[1] = dArray2[1] + v0[1] * dArray[0];
        int n6 = dArray2.length - 1;
        dArray2[n6] = dArray2[n6] + v0[0] * dArray[dArray.length - 1];
        int n7 = dArray2.length - 2;
        dArray2[n7] = dArray2[n7] + v0[1] * dArray[dArray.length - 1];
        return dArray2;
    }

    public double[] highpass(double[] dArray) {
        int n = dArray.length + 2;
        double[] dArray2 = ArrayMath.scalarMultiplyFast((double)dArray[0], (double[])MultiSpline3_5.wavelet(n, 0).interpolate(0));
        int n2 = 1;
        while (n2 < dArray.length) {
            dArray2 = ArrayMath.add((double[])dArray2, (double[])ArrayMath.scalarMultiply((double)dArray[n2], (double[])MultiSpline3_5.wavelet(n, n2).interpolate(0)));
            ++n2;
        }
        return dArray2;
    }

    public static QuadraticSpline scaling(int n, int n2) {
        if (n2 < 0 || n < 0 || n2 >= n) {
            throw new IllegalArgumentException("Incorrect parameters : " + n + ", " + n2 + " !");
        }
        if (n < 12) {
            throw new IllegalScalingException(n, 12);
        }
        double[] dArray = new double[n];
        dArray[n2] = 1.0;
        return new QuadraticSpline(dArray);
    }

    public static QuadraticSpline wavelet(int n, int n2) {
        if (n2 < 0 || n < 0 || n2 >= n - 2) {
            throw new IllegalArgumentException("Incorrect parameters : " + n + ", " + n2);
        }
        if (n < 12) {
            throw new IllegalScalingException(n, 12);
        }
        double[] dArray = new double[2 * n - 2];
        if (n2 > 2 && n2 < n - 5) {
            dArray = ArrayMath.padding((int)dArray.length, (int)(2 * n2 - 4), (double[])og);
        } else if (n2 == 0) {
            dArray = ArrayMath.padding((int)dArray.length, (int)0, (double[])o0);
        } else if (n2 == 1) {
            dArray = ArrayMath.padding((int)dArray.length, (int)0, (double[])o1);
        } else if (n2 == 2) {
            dArray = ArrayMath.padding((int)dArray.length, (int)0, (double[])o2);
        } else if (n2 == n - 3) {
            dArray = ArrayMath.padding((int)dArray.length, (int)(dArray.length - on0_1.length), (double[])on0_1);
        } else if (n2 == n - 4) {
            dArray = ArrayMath.padding((int)dArray.length, (int)(dArray.length - on0_2.length), (double[])on0_2);
        } else if (n2 == n - 5) {
            dArray = ArrayMath.padding((int)dArray.length, (int)(dArray.length - on0_3.length), (double[])on0_3);
        } else {
            throw new IllegalArgumentException("Oups!");
        }
        return new QuadraticSpline(dArray);
    }
}

