/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies4;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies4.Daubechies4;

public final class Scaling4
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies4 cdf = new Daubechies4();

    public Scaling4(int n, int n2) {
        this.setParameters(n, n2);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Scaling4) {
            Scaling4 scaling4 = (Scaling4)object;
            return Cascades.dimension(this.n0, 0, 6) == Cascades.dimension(scaling4.n0, 0, 6) && this.k == scaling4.k;
        }
        return false;
    }

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public Scaling4() {
    }

    public int getFilterType() {
        return 6;
    }

    public void setParameters(int n, int n2) {
        if (n < 12) {
            throw new IllegalScalingException(n, 12);
        }
        this.n0 = n;
        this.k = n2;
    }

    public Object clone() {
        Scaling4 scaling4 = (Scaling4)super.clone();
        scaling4.n0 = this.n0;
        scaling4.k = this.k;
        return scaling4;
    }

    public double[] evaluate(int n) {
        Daubechies4 daubechies4 = cdf;
        int n2 = this.n0;
        int n3 = this.k;
        return Cascades.evalScaling(daubechies4, n2, n, n3);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n, 6);
    }

    public int dimension() {
        return Cascades.dimension(this.n0, 0, 6);
    }

    public int position() {
        return this.k;
    }
}

