/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies4;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies4.Daubechies4;

public final class Wavelet4
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies4 cdf = new Daubechies4();

    public Wavelet4(int n, int n2) {
        this.setParameters(n, n2);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Wavelet4) {
            Wavelet4 wavelet4 = (Wavelet4)object;
            return Cascades.dimension(this.n0, 1, 6) == Cascades.dimension(wavelet4.n0, 1, 6) && this.k == wavelet4.k;
        }
        return false;
    }

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public Wavelet4() {
    }

    public int getFilterType() {
        return 6;
    }

    public void setParameters(int n, int n2) {
        if (n < 12) {
            throw new IllegalScalingException(n, 12);
        }
        this.n0 = n;
        this.k = n2;
    }

    public Object clone() {
        Wavelet4 wavelet4 = (Wavelet4)super.clone();
        wavelet4.n0 = this.n0;
        wavelet4.k = this.k;
        return wavelet4;
    }

    public double[] evaluate(int n) {
        Daubechies4 daubechies4 = cdf;
        int n2 = this.n0;
        int n3 = this.k;
        return Cascades.evalWavelet(daubechies4, 6, n2, n, n3);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n + 1, 6);
    }

    public int dimension() {
        return Cascades.dimension(this.n0, 1, 6);
    }

    public int position() {
        return this.k;
    }
}

