/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies5;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies5.Daubechies5;

public final class Scaling5
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies5 cdf = new Daubechies5();

    public Scaling5(int n, int n2) {
        this.setParameters(n, n2);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Scaling5) {
            Scaling5 scaling5 = (Scaling5)object;
            return Cascades.dimension(this.n0, 0, 8) == Cascades.dimension(scaling5.n0, 0, 8) && this.k == scaling5.k;
        }
        return false;
    }

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public Scaling5() {
    }

    public int getFilterType() {
        return 8;
    }

    public void setParameters(int n, int n2) {
        if (n < 16) {
            throw new IllegalScalingException(n, 16);
        }
        this.n0 = n;
        this.k = n2;
    }

    public Object clone() {
        Scaling5 scaling5 = (Scaling5)super.clone();
        scaling5.n0 = this.n0;
        scaling5.k = this.k;
        return scaling5;
    }

    public double[] evaluate(int n) {
        Daubechies5 daubechies5 = cdf;
        int n2 = this.n0;
        int n3 = this.k;
        return Cascades.evalScaling(daubechies5, n2, n, n3);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n, 8);
    }

    public int dimension() {
        return Cascades.dimension(this.n0, 0, 8);
    }

    public int position() {
        return this.k;
    }
}

