/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies8;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies8.Daubechies8;

public final class Wavelet8
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies8 cdf = new Daubechies8();

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Wavelet8) {
            Wavelet8 wavelet8 = (Wavelet8)object;
            return Cascades.dimension(this.n0, 1, 14) == Cascades.dimension(wavelet8.n0, 1, 14) && this.k == wavelet8.k;
        }
        return false;
    }

    public Wavelet8(int n, int n2) {
        this.setParameters(n, n2);
    }

    public Wavelet8() {
    }

    public int getFilterType() {
        return 14;
    }

    public void setParameters(int n, int n2) {
        if (n < 28) {
            throw new IllegalScalingException(n, 28);
        }
        this.n0 = n;
        this.k = n2;
    }

    public Object clone() {
        Wavelet8 wavelet8 = (Wavelet8)super.clone();
        wavelet8.n0 = this.n0;
        wavelet8.k = this.k;
        return wavelet8;
    }

    public double[] evaluate(int n) {
        Daubechies8 daubechies8 = cdf;
        int n2 = this.n0;
        int n3 = this.k;
        return Cascades.evalWavelet(daubechies8, 14, n2, n, n3);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n + 1, 14);
    }

    public int dimension() {
        return Cascades.dimension(this.n0, 1, 14);
    }

    public int position() {
        return this.k;
    }
}

