/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.Complex;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.ComplexTridiagonalMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DimensionException;
import JSci.maths.DoubleDiagonalMatrix;
import JSci.maths.DoubleMatrix;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public final class ComplexDiagonalMatrix
extends ComplexTridiagonalMatrix {
    protected static final int DIAGONAL = 4;
    protected static final int storageFormat = 4;

    protected ComplexDiagonalMatrix() {
    }

    public ComplexDiagonalMatrix(int n) {
        this();
        this.matrix = new Complex[1][n];
    }

    public ComplexDiagonalMatrix(Complex[][] complexArray) {
        this(complexArray.length);
        if (complexArray.length == complexArray[0].length) {
            int n = 0;
            while (n < this.matrix[0].length) {
                this.matrix[0][n] = complexArray[n][n];
                ++n;
            }
            return;
        }
        this.matrix = null;
        throw new MatrixDimensionException("Array must be square.");
    }

    public ComplexDiagonalMatrix(Complex[] complexArray) {
        this();
        this.matrix = new Complex[1][];
        this.matrix[0] = complexArray;
    }

    public static ComplexDiagonalMatrix identity(int n) {
        Complex[] complexArray = new Complex[n];
        int n2 = 0;
        while (n2 < n) {
            complexArray[n2] = Complex.ONE;
            ++n2;
        }
        return new ComplexDiagonalMatrix(complexArray);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ComplexDiagonalMatrix) {
            ComplexDiagonalMatrix complexDiagonalMatrix = (ComplexDiagonalMatrix)object;
            if (this.matrix[0].length == complexDiagonalMatrix.matrix[0].length) {
                complexDiagonalMatrix = (ComplexDiagonalMatrix)object;
                int n = 0;
                while (n < this.matrix[0].length) {
                    if (!this.matrix[0][n].equals(complexDiagonalMatrix.getElement(n, n))) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    public DoubleMatrix real() {
        double[] dArray = new double[this.matrix[0].length];
        int n = 0;
        while (n < this.matrix[0].length) {
            dArray[n] = this.matrix[0][n].real();
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public DoubleMatrix imag() {
        double[] dArray = new double[this.matrix[0].length];
        int n = 0;
        while (n < this.matrix[0].length) {
            dArray[n] = this.matrix[0][n].imag();
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public Complex getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix[0].length && n2 >= 0 && n2 < this.matrix[0].length) {
            if (n == n2) {
                return this.matrix[0][n];
            }
            return Complex.ZERO;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public void setElement(int n, int n2, Complex complex) {
        if (n >= 0 && n < this.matrix[0].length && n2 >= 0 && n2 < this.matrix[0].length && n == n2) {
            this.matrix[0][n] = complex;
            return;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public boolean isHermitian() {
        return this.equals(this.conjugate());
    }

    public boolean isUnitary() {
        return this.multiply(this.conjugate()).equals(ComplexDiagonalMatrix.identity(this.matrix[0].length));
    }

    public Complex det() {
        Complex complex = this.matrix[0][0];
        int n = 1;
        while (n < this.matrix[0].length) {
            complex = complex.multiply(this.matrix[0][n]);
            ++n;
        }
        return complex;
    }

    public Complex trace() {
        double d = this.matrix[0][0].real();
        double d2 = this.matrix[0][0].imag();
        int n = 1;
        while (n < this.matrix[0].length) {
            d += this.matrix[0][n].real();
            d2 += this.matrix[0][n].imag();
            ++n;
        }
        return new Complex(d, d2);
    }

    public double infNorm() {
        double d = this.matrix[0][0].mod();
        int n = 1;
        while (n < this.matrix[0].length) {
            double d2 = this.matrix[0][n].mod();
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = this.matrix[0][0].mod() * this.matrix[0][0].mod();
        int n = 1;
        while (n < this.matrix[0].length) {
            d += this.matrix[0][n].mod() * this.matrix[0][n].mod();
            ++n;
        }
        return Math.sqrt(d);
    }

    public int rows() {
        return this.matrix[0].length;
    }

    public int columns() {
        return this.matrix[0].length;
    }

    public ComplexMatrix add(ComplexMatrix complexMatrix) {
        switch (1) {
            case 1: {
                return this.rawAdd(complexMatrix);
            }
            case 3: {
                return this.rawAdd((ComplexTridiagonalMatrix)complexMatrix);
            }
            case 4: {
                return this.rawAdd((ComplexDiagonalMatrix)complexMatrix);
            }
        }
        if (this.matrix[0].length == complexMatrix.rows() && this.matrix[0].length == complexMatrix.columns()) {
            Complex[][] complexArray = new Complex[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = complexMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = complexMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < complexArray.length) {
                complexArray[n3][n3] = complexArray[n3][n3].add(this.matrix[0][n3]);
                ++n3;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawAdd(ComplexMatrix complexMatrix) {
        if (this.matrix[0].length == complexMatrix.matrix.length && this.matrix[0].length == complexMatrix.matrix[0].length) {
            Complex[][] complexArray = new Complex[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < complexArray.length) {
                System.arraycopy(complexMatrix.matrix[n], 0, complexArray[n], 0, complexArray.length);
                ++n;
            }
            int n2 = 0;
            while (n2 < complexArray.length) {
                complexArray[n2][n2] = complexArray[n2][n2].add(this.matrix[0][n2]);
                ++n2;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix complexSquareMatrix) {
        switch (1) {
            case 1: {
                return this.rawAdd(complexSquareMatrix);
            }
            case 3: {
                return this.rawAdd((ComplexTridiagonalMatrix)complexSquareMatrix);
            }
            case 4: {
                return this.rawAdd((ComplexDiagonalMatrix)complexSquareMatrix);
            }
        }
        if (this.matrix[0].length == complexSquareMatrix.rows()) {
            Complex[][] complexArray = new Complex[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = complexSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = complexSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < complexArray.length) {
                complexArray[n3][n3] = complexArray[n3][n3].add(this.matrix[0][n3]);
                ++n3;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix add(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        switch (3) {
            case 3: {
                return this.rawAdd(complexTridiagonalMatrix);
            }
            case 4: {
                return this.rawAdd((ComplexDiagonalMatrix)complexTridiagonalMatrix);
            }
        }
        int n = this.matrix[0].length;
        if (n == complexTridiagonalMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.matrix[1][0] = this.matrix[0][0].add(complexTridiagonalMatrix.getElement(0, 0));
            complexTridiagonalMatrix2.matrix[2][0] = complexTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                complexTridiagonalMatrix2.matrix[0][n2] = complexTridiagonalMatrix.getElement(n2, n2 - 1);
                complexTridiagonalMatrix2.matrix[1][n2] = this.matrix[0][n2].add(complexTridiagonalMatrix.getElement(n2, n2));
                complexTridiagonalMatrix2.matrix[2][n2] = complexTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            complexTridiagonalMatrix2.matrix[0][n] = complexTridiagonalMatrix.getElement(n, n - 1);
            complexTridiagonalMatrix2.matrix[1][n] = this.matrix[0][n].add(complexTridiagonalMatrix.getElement(n, n));
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexTridiagonalMatrix rawAdd(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        if (this.matrix[0].length == complexTridiagonalMatrix.matrix[1].length) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(this.matrix[0].length);
            System.arraycopy(complexTridiagonalMatrix.matrix[0], 0, complexTridiagonalMatrix2.matrix[0], 0, this.matrix[0].length);
            System.arraycopy(complexTridiagonalMatrix.matrix[2], 0, complexTridiagonalMatrix2.matrix[2], 0, this.matrix[2].length);
            complexTridiagonalMatrix2.matrix[1][0] = this.matrix[0][0].add(complexTridiagonalMatrix.matrix[1][0]);
            int n = 1;
            while (n < this.matrix[0].length) {
                complexTridiagonalMatrix2.matrix[1][n] = this.matrix[0][n].add(complexTridiagonalMatrix.matrix[1][n]);
                ++n;
            }
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexDiagonalMatrix add(ComplexDiagonalMatrix complexDiagonalMatrix) {
        if (this.matrix[0].length == complexDiagonalMatrix.matrix[0].length) {
            Complex[] complexArray = new Complex[this.matrix[0].length];
            complexArray[0] = this.matrix[0][0].add(complexDiagonalMatrix.getElement(0, 0));
            int n = 1;
            while (n < complexArray.length) {
                complexArray[n] = this.matrix[0][n].add(complexDiagonalMatrix.matrix[0][n]);
                ++n;
            }
            return new ComplexDiagonalMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Matrix subtract(Matrix matrix) {
        if (matrix instanceof ComplexDiagonalMatrix) {
            return this.subtract((ComplexDiagonalMatrix)matrix);
        }
        if (matrix instanceof ComplexTridiagonalMatrix) {
            return this.rawSubtract((ComplexTridiagonalMatrix)matrix);
        }
        if (matrix instanceof ComplexSquareMatrix) {
            return this.rawSubtract((ComplexSquareMatrix)matrix);
        }
        if (matrix instanceof ComplexMatrix) {
            return this.rawSubtract((ComplexMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public ComplexMatrix subtract(ComplexMatrix complexMatrix) {
        if (complexMatrix instanceof ComplexDiagonalMatrix) {
            return this.subtract((ComplexDiagonalMatrix)complexMatrix);
        }
        if (complexMatrix instanceof ComplexTridiagonalMatrix) {
            return this.rawSubtract((ComplexTridiagonalMatrix)complexMatrix);
        }
        if (complexMatrix instanceof ComplexSquareMatrix) {
            return this.rawSubtract((ComplexSquareMatrix)complexMatrix);
        }
        return this.rawSubtract(complexMatrix);
    }

    private ComplexMatrix rawSubtract(ComplexMatrix complexMatrix) {
        if (this.matrix[0].length == complexMatrix.rows() && this.matrix[0].length == complexMatrix.columns()) {
            Complex[][] complexArray = new Complex[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = (Complex)complexMatrix.matrix[n][0].negate();
                int n2 = 1;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = (Complex)complexMatrix.matrix[n][n2].negate();
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < complexArray.length) {
                complexArray[n3][n3] = complexArray[n3][n3].add(this.matrix[0][n3]);
                ++n3;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix complexSquareMatrix) {
        if (complexSquareMatrix instanceof ComplexDiagonalMatrix) {
            return this.subtract((ComplexDiagonalMatrix)complexSquareMatrix);
        }
        if (complexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.rawSubtract((ComplexTridiagonalMatrix)complexSquareMatrix);
        }
        return this.rawSubtract(complexSquareMatrix);
    }

    private ComplexSquareMatrix rawSubtract(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrix[0].length == complexSquareMatrix.rows()) {
            Complex[][] complexArray = new Complex[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = (Complex)complexSquareMatrix.matrix[n][0].negate();
                int n2 = 1;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = (Complex)complexSquareMatrix.matrix[n][n2].negate();
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < complexArray.length) {
                complexArray[n3][n3] = complexArray[n3][n3].add(this.matrix[0][n3]);
                ++n3;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix subtract(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        if (complexTridiagonalMatrix instanceof ComplexDiagonalMatrix) {
            return this.subtract((ComplexDiagonalMatrix)complexTridiagonalMatrix);
        }
        return this.rawSubtract(complexTridiagonalMatrix);
    }

    private ComplexTridiagonalMatrix rawSubtract(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        if (this.matrix[0].length == complexTridiagonalMatrix.rows()) {
            int n = this.matrix[0].length;
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.setElement(0, 0, this.matrix[0][0].subtract(complexTridiagonalMatrix.getElement(0, 0)));
            complexTridiagonalMatrix2.setElement(1, 0, (Complex)complexTridiagonalMatrix.getElement(1, 0).negate());
            --n;
            int n2 = 1;
            while (n2 < n) {
                complexTridiagonalMatrix2.setElement(n2 - 1, n2, (Complex)complexTridiagonalMatrix.getElement(n2 - 1, n2).negate());
                complexTridiagonalMatrix2.setElement(n2, n2, this.matrix[0][n2].subtract(complexTridiagonalMatrix.getElement(n2, n2)));
                complexTridiagonalMatrix2.setElement(n2 + 1, n2, (Complex)complexTridiagonalMatrix.getElement(n2 + 1, n2).negate());
                ++n2;
            }
            complexTridiagonalMatrix2.setElement(n - 1, n, (Complex)complexTridiagonalMatrix.getElement(n - 1, n).negate());
            complexTridiagonalMatrix2.setElement(n, n, this.matrix[0][n].subtract(complexTridiagonalMatrix.getElement(n, n)));
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexDiagonalMatrix subtract(ComplexDiagonalMatrix complexDiagonalMatrix) {
        if (this.matrix[0].length == complexDiagonalMatrix.matrix[0].length) {
            Complex[] complexArray = new Complex[this.matrix[0].length];
            complexArray[0] = this.matrix[0][0].subtract(complexDiagonalMatrix.matrix[0][0]);
            int n = 1;
            while (n < complexArray.length) {
                complexArray[n] = this.matrix[0][n].subtract(complexDiagonalMatrix.matrix[0][n]);
                ++n;
            }
            return new ComplexDiagonalMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix scalarMultiply(Complex complex) {
        Complex[] complexArray = new Complex[this.matrix[0].length];
        complexArray[0] = complex.multiply(this.matrix[0][0]);
        int n = 1;
        while (n < complexArray.length) {
            complexArray[n] = complex.multiply(this.matrix[0][n]);
            ++n;
        }
        return new ComplexDiagonalMatrix(complexArray);
    }

    public ComplexMatrix scalarMultiply(double d) {
        Complex[] complexArray = new Complex[this.matrix[0].length];
        complexArray[0] = this.matrix[0][0].multiply(d);
        int n = 1;
        while (n < complexArray.length) {
            complexArray[n] = this.matrix[0][n].multiply(d);
            ++n;
        }
        return new ComplexDiagonalMatrix(complexArray);
    }

    public ComplexVector multiply(ComplexVector complexVector) {
        if (this.matrix[0].length == complexVector.dimension()) {
            Complex[] complexArray = new Complex[this.matrix[0].length];
            complexArray[0] = this.matrix[0][0].multiply(complexVector.getComponent(0));
            int n = 1;
            while (n < complexArray.length) {
                complexArray[n] = this.matrix[0][n].multiply(complexVector.getComponent(n));
                ++n;
            }
            return new ComplexVector(complexArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public Matrix multiply(Matrix matrix) {
        if (matrix instanceof ComplexDiagonalMatrix) {
            return this.multiply((ComplexDiagonalMatrix)matrix);
        }
        if (matrix instanceof ComplexTridiagonalMatrix) {
            return this.rawMultiply((ComplexTridiagonalMatrix)matrix);
        }
        if (matrix instanceof ComplexSquareMatrix) {
            return this.rawMultiply((ComplexSquareMatrix)matrix);
        }
        if (matrix instanceof ComplexMatrix) {
            return this.rawMultiply((ComplexMatrix)matrix);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public ComplexMatrix multiply(ComplexMatrix complexMatrix) {
        if (complexMatrix instanceof ComplexDiagonalMatrix) {
            return this.multiply((ComplexDiagonalMatrix)complexMatrix);
        }
        if (complexMatrix instanceof ComplexTridiagonalMatrix) {
            return this.rawMultiply((ComplexTridiagonalMatrix)complexMatrix);
        }
        if (complexMatrix instanceof ComplexSquareMatrix) {
            return this.rawMultiply((ComplexSquareMatrix)complexMatrix);
        }
        return this.rawMultiply(complexMatrix);
    }

    private ComplexMatrix rawMultiply(ComplexMatrix complexMatrix) {
        if (this.matrix[0].length == complexMatrix.rows()) {
            Complex[][] complexArray = new Complex[this.matrix[0].length][complexMatrix.columns()];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = this.matrix[0][n].multiply(complexMatrix.getElement(n, 0));
                int n2 = 1;
                while (n2 < complexArray[0].length) {
                    complexArray[n][n2] = this.matrix[0][n].multiply(complexMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix complexSquareMatrix) {
        if (complexSquareMatrix instanceof ComplexDiagonalMatrix) {
            return this.multiply((ComplexDiagonalMatrix)complexSquareMatrix);
        }
        if (complexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.rawMultiply((ComplexTridiagonalMatrix)complexSquareMatrix);
        }
        return this.rawMultiply(complexSquareMatrix);
    }

    private ComplexSquareMatrix rawMultiply(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrix[0].length == complexSquareMatrix.rows()) {
            Complex[][] complexArray = new Complex[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = this.matrix[0][n].multiply(complexSquareMatrix.getElement(n, 0));
                int n2 = 1;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = this.matrix[0][n].multiply(complexSquareMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix multiply(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        if (complexTridiagonalMatrix instanceof ComplexDiagonalMatrix) {
            return this.multiply((ComplexDiagonalMatrix)complexTridiagonalMatrix);
        }
        return this.rawMultiply(complexTridiagonalMatrix);
    }

    private ComplexSquareMatrix rawMultiply(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.matrix[0].length;
        if (n == complexTridiagonalMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.setElement(0, 0, this.matrix[0][0].multiply(complexTridiagonalMatrix.getElement(0, 0)));
            complexTridiagonalMatrix2.setElement(0, 1, this.matrix[0][0].multiply(complexTridiagonalMatrix.getElement(0, 1)));
            --n;
            int n2 = 1;
            while (n2 < n) {
                complexTridiagonalMatrix2.setElement(n2, n2 - 1, this.matrix[0][n2].multiply(complexTridiagonalMatrix.getElement(n2, n2 - 1)));
                complexTridiagonalMatrix2.setElement(n2, n2, this.matrix[0][n2].multiply(complexTridiagonalMatrix.getElement(n2, n2)));
                complexTridiagonalMatrix2.setElement(n2, n2 + 1, this.matrix[0][n2].multiply(complexTridiagonalMatrix.getElement(n2, n2 + 1)));
                ++n2;
            }
            complexTridiagonalMatrix2.setElement(n, n - 1, this.matrix[0][n].multiply(complexTridiagonalMatrix.getElement(n, n - 1)));
            complexTridiagonalMatrix2.setElement(n, n, this.matrix[0][n].multiply(complexTridiagonalMatrix.getElement(n, n)));
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexDiagonalMatrix multiply(ComplexDiagonalMatrix complexDiagonalMatrix) {
        if (this.matrix[0].length == complexDiagonalMatrix.matrix[0].length) {
            Complex[] complexArray = new Complex[this.matrix[0].length];
            complexArray[0] = this.matrix[0][0].multiply(complexDiagonalMatrix.getElement(0, 0));
            int n = 1;
            while (n < complexArray.length) {
                complexArray[n] = this.matrix[0][n].multiply(complexDiagonalMatrix.getElement(n, n));
                ++n;
            }
            return new ComplexDiagonalMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix inverse() {
        Complex[] complexArray = new Complex[this.matrix[0].length];
        complexArray[0] = Complex.ONE.divide(this.matrix[0][0]);
        int n = 1;
        while (n < complexArray.length) {
            complexArray[n] = Complex.ONE.divide(this.matrix[0][n]);
            ++n;
        }
        return new ComplexDiagonalMatrix(complexArray);
    }

    public ComplexMatrix conjugate() {
        Complex[] complexArray = new Complex[this.matrix[0].length];
        complexArray[0] = this.matrix[0][0].conjugate();
        int n = 1;
        while (n < complexArray.length) {
            complexArray[n] = this.matrix[0][n].conjugate();
            ++n;
        }
        return new ComplexDiagonalMatrix(complexArray);
    }

    public Matrix transpose() {
        return this;
    }

    public ComplexSquareMatrix[] luDecompose() {
        ComplexSquareMatrix[] complexSquareMatrixArray = new ComplexDiagonalMatrix[]{ComplexDiagonalMatrix.identity(this.matrix[0].length), this};
        return complexSquareMatrixArray;
    }

    public ComplexMatrix mapElements(Mapping mapping) {
        Complex[] complexArray = new Complex[this.matrix[0].length];
        complexArray[0] = mapping.map(this.matrix[0][0]);
        int n = 1;
        while (n < complexArray.length) {
            complexArray[n] = mapping.map(this.matrix[0][n]);
            ++n;
        }
        return new ComplexDiagonalMatrix(complexArray);
    }
}

