/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.DoubleVector;
import JSci.maths.Mapping;
import JSci.maths.VectorDimensionException;

public final class DoubleSparseVector
extends DoubleVector {
    protected static final int SPARSE = 2;
    protected static final int storageFormat = 2;
    private int[] pos;
    private int N;

    public DoubleSparseVector(int n) {
        super(0);
        this.pos = new int[0];
        this.N = n;
    }

    public DoubleSparseVector(double[] dArray) {
        super(0);
        this.N = dArray.length;
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            if (dArray[n2] != 0.0) {
                ++n;
            }
            ++n2;
        }
        this.vector = new double[n];
        this.pos = new int[n];
        n = 0;
        int n3 = 0;
        while (n3 < dArray.length) {
            if (dArray[n3] != 0.0) {
                this.pos[n] = n3;
                this.vector[n] = dArray[n3];
                ++n;
            }
            ++n3;
        }
    }

    protected void finalize() throws Throwable {
        this.pos = null;
        super.finalize();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DoubleSparseVector && this.N == ((DoubleSparseVector)object).N) {
            DoubleSparseVector doubleSparseVector = (DoubleSparseVector)object;
            if (this.pos.length != doubleSparseVector.pos.length) {
                return false;
            }
            if (Math.abs(this.getComponent(0) - doubleSparseVector.getComponent(0)) > GlobalSettings.ZERO_TOL) {
                return false;
            }
            int n = 1;
            while (n < this.N) {
                if (Math.abs(this.getComponent(n) - doubleSparseVector.getComponent(n)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.N);
        int n = 0;
        while (n < this.N - 1) {
            stringBuffer.append(this.getComponent(n));
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.append(this.getComponent(n));
        return stringBuffer.toString();
    }

    public double getComponent(int n) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException("Invalid component.");
        }
        int n2 = 0;
        while (n2 < this.pos.length) {
            if (this.pos[n2] == n) {
                return this.vector[n2];
            }
            ++n2;
        }
        return 0.0;
    }

    public void setComponent(int n, double d) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException("Invalid component.");
        }
        if (Math.abs(d) <= GlobalSettings.ZERO_TOL) {
            return;
        }
        int n2 = 0;
        while (n2 < this.pos.length) {
            if (n == this.pos[n2]) {
                this.vector[n2] = d;
                return;
            }
            ++n2;
        }
        int[] nArray = new int[this.pos.length + 1];
        double[] dArray = new double[this.vector.length + 1];
        System.arraycopy(this.pos, 0, nArray, 0, this.pos.length);
        System.arraycopy(this.vector, 0, dArray, 0, this.pos.length);
        nArray[this.pos.length] = n;
        dArray[this.vector.length] = d;
        this.pos = nArray;
        this.vector = dArray;
    }

    public int dimension() {
        return this.N;
    }

    public void normalize() {
        double d = Math.sqrt(this.sumSquares());
        int n = 0;
        while (n < this.pos.length) {
            int n2 = n++;
            this.vector[n2] = this.vector[n2] / d;
        }
    }

    public double norm() {
        return Math.sqrt(this.sumSquares());
    }

    public double sumSquares() {
        double d = 0.0;
        int n = 0;
        while (n < this.pos.length) {
            d += this.vector[n] * this.vector[n];
            ++n;
        }
        return d;
    }

    public double mass() {
        double d = 0.0;
        int n = 0;
        while (n < this.pos.length) {
            d += this.vector[n];
            ++n;
        }
        return d;
    }

    public DoubleVector add(DoubleVector doubleVector) {
        switch (1) {
            case 2: {
                return this.add((DoubleSparseVector)doubleVector);
            }
            case 1: {
                return this.rawAdd(doubleVector);
            }
        }
        if (this.N != doubleVector.dimension()) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        dArray[0] = doubleVector.getComponent(0);
        int n = 1;
        while (n < this.N) {
            dArray[n] = doubleVector.getComponent(n);
            ++n;
        }
        n = 0;
        while (n < this.pos.length) {
            int n2 = this.pos[n];
            dArray[n2] = dArray[n2] + this.vector[n];
            ++n;
        }
        return new DoubleVector(dArray);
    }

    private DoubleVector rawAdd(DoubleVector doubleVector) {
        if (this.N != doubleVector.dimension()) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        System.arraycopy(doubleVector.vector, 0, dArray, 0, this.N);
        int n = 0;
        while (n < this.pos.length) {
            int n2 = this.pos[n];
            dArray[n2] = dArray[n2] + this.vector[n];
            ++n;
        }
        return new DoubleVector(dArray);
    }

    public DoubleSparseVector add(DoubleSparseVector doubleSparseVector) {
        if (this.N != doubleSparseVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        int n = 0;
        while (n < this.pos.length) {
            dArray[this.pos[n]] = this.vector[n] + doubleSparseVector.getComponent(this.pos[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < doubleSparseVector.pos.length) {
            int n3 = doubleSparseVector.pos[n2];
            dArray[n3] = this.getComponent(n3) + doubleSparseVector.vector[n2];
            ++n2;
        }
        return new DoubleSparseVector(dArray);
    }

    public DoubleVector subtract(DoubleVector doubleVector) {
        switch (1) {
            case 2: {
                return this.subtract((DoubleSparseVector)doubleVector);
            }
            case 1: {
                return this.rawSubtract(doubleVector);
            }
        }
        if (this.N != doubleVector.dimension()) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        dArray[0] = -doubleVector.getComponent(0);
        int n = 1;
        while (n < this.N) {
            dArray[n] = -doubleVector.getComponent(n);
            ++n;
        }
        n = 0;
        while (n < this.pos.length) {
            int n2 = this.pos[n];
            dArray[n2] = dArray[n2] + this.vector[n];
            ++n;
        }
        return new DoubleVector(dArray);
    }

    private DoubleVector rawSubtract(DoubleVector doubleVector) {
        if (this.N != doubleVector.dimension()) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        dArray[0] = -doubleVector.vector[0];
        int n = 1;
        while (n < this.N) {
            dArray[n] = -doubleVector.vector[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < this.pos.length) {
            int n3 = this.pos[n2];
            dArray[n3] = dArray[n3] + this.vector[n2];
            ++n2;
        }
        return new DoubleVector(dArray);
    }

    public DoubleSparseVector subtract(DoubleSparseVector doubleSparseVector) {
        if (this.N != doubleSparseVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double[] dArray = new double[this.N];
        int n = 0;
        while (n < this.pos.length) {
            dArray[this.pos[n]] = this.vector[n] - doubleSparseVector.getComponent(this.pos[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < doubleSparseVector.pos.length) {
            int n3 = doubleSparseVector.pos[n2];
            dArray[n3] = this.getComponent(n3) - doubleSparseVector.vector[n2];
            ++n2;
        }
        return new DoubleSparseVector(dArray);
    }

    public DoubleVector scalarMultiply(double d) {
        DoubleSparseVector doubleSparseVector = new DoubleSparseVector(this.N);
        doubleSparseVector.vector = new double[this.vector.length];
        doubleSparseVector.pos = new int[this.pos.length];
        System.arraycopy(this.pos, 0, doubleSparseVector.pos, 0, this.pos.length);
        int n = 0;
        while (n < this.pos.length) {
            doubleSparseVector.vector[n] = d * this.vector[n];
            ++n;
        }
        return doubleSparseVector;
    }

    public DoubleVector scalarDivide(double d) {
        DoubleSparseVector doubleSparseVector = new DoubleSparseVector(this.N);
        doubleSparseVector.vector = new double[this.vector.length];
        doubleSparseVector.pos = new int[this.pos.length];
        System.arraycopy(this.pos, 0, doubleSparseVector.pos, 0, this.pos.length);
        int n = 0;
        while (n < this.pos.length) {
            doubleSparseVector.vector[n] = this.vector[n] / d;
            ++n;
        }
        return doubleSparseVector;
    }

    public double scalarProduct(DoubleVector doubleVector) {
        switch (1) {
            case 2: {
                return this.scalarProduct((DoubleSparseVector)doubleVector);
            }
            case 1: {
                return this.rawScalarProduct(doubleVector);
            }
        }
        if (this.N != doubleVector.dimension()) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double d = 0.0;
        int n = 0;
        while (n < this.pos.length) {
            d += this.vector[n] * doubleVector.getComponent(this.pos[n]);
            ++n;
        }
        return d;
    }

    private double rawScalarProduct(DoubleVector doubleVector) {
        if (this.N != doubleVector.dimension()) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double d = 0.0;
        int n = 0;
        while (n < this.pos.length) {
            d += this.vector[n] * doubleVector.vector[this.pos[n]];
            ++n;
        }
        return d;
    }

    public double scalarProduct(DoubleSparseVector doubleSparseVector) {
        if (this.N != doubleSparseVector.N) {
            throw new VectorDimensionException("Vectors are different sizes.");
        }
        double d = 0.0;
        if (this.pos.length <= doubleSparseVector.pos.length) {
            int n = 0;
            while (n < this.pos.length) {
                d += this.vector[n] * doubleSparseVector.getComponent(this.pos[n]);
                ++n;
            }
        } else {
            int n = 0;
            while (n < doubleSparseVector.pos.length) {
                d += this.getComponent(doubleSparseVector.pos[n]) * doubleSparseVector.vector[n];
                ++n;
            }
        }
        return d;
    }

    public DoubleVector mapComponents(Mapping mapping) {
        DoubleSparseVector doubleSparseVector = new DoubleSparseVector(this.N);
        doubleSparseVector.vector = new double[this.vector.length];
        doubleSparseVector.pos = new int[this.pos.length];
        System.arraycopy(this.pos, 0, doubleSparseVector.pos, 0, this.pos.length);
        int n = 0;
        while (n < this.pos.length) {
            doubleSparseVector.vector[n] = mapping.map(this.vector[n]);
            ++n;
        }
        return doubleSparseVector;
    }
}

