/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.Complex;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexTridiagonalMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.IntegerMatrix;
import JSci.maths.IntegerTridiagonalMatrix;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public class DoubleTridiagonalMatrix
extends DoubleSquareMatrix {
    protected static final int TRIDIAGONAL = 3;
    protected static final int storageFormat = 3;

    protected DoubleTridiagonalMatrix() {
    }

    public DoubleTridiagonalMatrix(int n) {
        this();
        this.matrix = new double[3][n];
    }

    public DoubleTridiagonalMatrix(double[][] dArray) {
        this(dArray.length);
        if (dArray.length == dArray[0].length) {
            this.matrix[1][0] = dArray[0][0];
            this.matrix[2][0] = dArray[0][1];
            int n = 1;
            while (n < dArray.length - 1) {
                this.matrix[0][n] = dArray[n][n - 1];
                this.matrix[1][n] = dArray[n][n];
                this.matrix[2][n] = dArray[n][n + 1];
                ++n;
            }
            this.matrix[0][n] = dArray[n][n - 1];
            this.matrix[1][n] = dArray[n][n];
            return;
        }
        this.matrix = null;
        throw new MatrixDimensionException("The array is not square.");
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DoubleTridiagonalMatrix && this.matrix[1].length == ((DoubleTridiagonalMatrix)object).rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix = (DoubleTridiagonalMatrix)object;
            if (Math.abs(this.matrix[1][0] - doubleTridiagonalMatrix.getElement(0, 0)) > GlobalSettings.ZERO_TOL) {
                return false;
            }
            if (Math.abs(this.matrix[2][0] - doubleTridiagonalMatrix.getElement(0, 1)) > GlobalSettings.ZERO_TOL) {
                return false;
            }
            int n = 1;
            while (n < this.matrix[1].length - 1) {
                if (Math.abs(this.matrix[0][n] - doubleTridiagonalMatrix.getElement(n, n - 1)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                if (Math.abs(this.matrix[1][n] - doubleTridiagonalMatrix.getElement(n, n)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                if (Math.abs(this.matrix[2][n] - doubleTridiagonalMatrix.getElement(n, n + 1)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                ++n;
            }
            if (Math.abs(this.matrix[0][n] - doubleTridiagonalMatrix.getElement(n, n - 1)) > GlobalSettings.ZERO_TOL) {
                return false;
            }
            return !(Math.abs(this.matrix[1][n] - doubleTridiagonalMatrix.getElement(n, n)) > GlobalSettings.ZERO_TOL);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.matrix.length * this.matrix[1].length);
        int n = 0;
        while (n < this.rows()) {
            int n2 = 0;
            while (n2 < this.columns()) {
                stringBuffer.append(this.getElement(n, n2));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public IntegerMatrix toIntegerMatrix() {
        IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(this.matrix[1].length);
        integerTridiagonalMatrix.matrix[1][0] = Math.round((float)this.matrix[1][0]);
        integerTridiagonalMatrix.matrix[2][0] = Math.round((float)this.matrix[2][0]);
        int n = 1;
        while (n < this.matrix[1].length - 1) {
            integerTridiagonalMatrix.matrix[0][n] = Math.round((float)this.matrix[0][n]);
            integerTridiagonalMatrix.matrix[1][n] = Math.round((float)this.matrix[1][n]);
            integerTridiagonalMatrix.matrix[2][n] = Math.round((float)this.matrix[2][n]);
            ++n;
        }
        integerTridiagonalMatrix.matrix[0][n] = Math.round((float)this.matrix[0][n]);
        integerTridiagonalMatrix.matrix[1][n] = Math.round((float)this.matrix[1][n]);
        return integerTridiagonalMatrix;
    }

    public ComplexMatrix toComplexMatrix() {
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(this.matrix[1].length);
        complexTridiagonalMatrix.matrix[1][0] = new Complex(this.matrix[1][0], 0.0);
        complexTridiagonalMatrix.matrix[2][0] = new Complex(this.matrix[2][0], 0.0);
        int n = 1;
        while (n < this.matrix[1].length - 1) {
            complexTridiagonalMatrix.matrix[0][n] = new Complex(this.matrix[0][n], 0.0);
            complexTridiagonalMatrix.matrix[1][n] = new Complex(this.matrix[1][n], 0.0);
            complexTridiagonalMatrix.matrix[2][n] = new Complex(this.matrix[2][n], 0.0);
            ++n;
        }
        complexTridiagonalMatrix.matrix[0][n] = new Complex(this.matrix[0][n], 0.0);
        complexTridiagonalMatrix.matrix[1][n] = new Complex(this.matrix[1][n], 0.0);
        return complexTridiagonalMatrix;
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix[1].length && n2 >= 0 && n2 < this.matrix[1].length) {
            if (n2 == n - 1) {
                return this.matrix[0][n];
            }
            if (n2 == n) {
                return this.matrix[1][n];
            }
            if (n2 == n + 1) {
                return this.matrix[2][n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public void setElement(int n, int n2, double d) {
        if (n >= 0 && n < this.matrix[1].length && n2 >= 0 && n2 < this.matrix[1].length) {
            if (n2 == n - 1) {
                this.matrix[0][n] = d;
                return;
            }
            if (n2 == n) {
                this.matrix[1][n] = d;
                return;
            }
            if (n2 == n + 1) {
                this.matrix[2][n] = d;
                return;
            }
            throw new MatrixDimensionException("Invalid element.");
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public boolean isSymmetric() {
        if (this.matrix[0][1] != this.matrix[2][0]) {
            return false;
        }
        int n = 1;
        while (n < this.matrix[1].length - 1) {
            if (this.matrix[0][n + 1] != this.matrix[2][n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public double trace() {
        double d = this.matrix[1][0];
        int n = 1;
        while (n < this.matrix[1].length) {
            d += this.matrix[1][n];
            ++n;
        }
        return d;
    }

    public double infNorm() {
        double d;
        double d2 = Math.abs(this.matrix[1][0]) + Math.abs(this.matrix[2][0]);
        int n = 1;
        while (n < this.matrix[1].length - 1) {
            d = Math.abs(this.matrix[0][n]) + Math.abs(this.matrix[1][n]) + Math.abs(this.matrix[2][n]);
            if (d > d2) {
                d2 = d;
            }
            ++n;
        }
        d = Math.abs(this.matrix[0][n]) + Math.abs(this.matrix[1][n]);
        if (d > d2) {
            d2 = d;
        }
        return d2;
    }

    public double frobeniusNorm() {
        double d = this.matrix[1][0] * this.matrix[1][0] + this.matrix[2][0] * this.matrix[2][0];
        int n = 1;
        while (n < this.matrix[1].length - 1) {
            d += this.matrix[0][n] * this.matrix[0][n] + this.matrix[1][n] * this.matrix[1][n] + this.matrix[2][n] * this.matrix[2][n];
            ++n;
        }
        return Math.sqrt(d += this.matrix[0][n] * this.matrix[0][n] + this.matrix[1][n] * this.matrix[1][n]);
    }

    public int rows() {
        return this.matrix[1].length;
    }

    public int columns() {
        return this.matrix[1].length;
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        switch (1) {
            case 1: {
                return this.rawAdd(doubleMatrix);
            }
            case 3: {
                return this.rawAdd((DoubleTridiagonalMatrix)doubleMatrix);
            }
        }
        if (this.matrix[1].length == doubleMatrix.rows() && this.matrix[1].length == doubleMatrix.columns()) {
            double[][] dArray = new double[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.getElement(n, 0) + doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.getElement(n, n2) + doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawAdd(DoubleMatrix doubleMatrix) {
        if (this.matrix[1].length == doubleMatrix.matrix.length && this.matrix[1].length == doubleMatrix.matrix[0].length) {
            double[][] dArray = new double[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < dArray.length) {
                System.arraycopy(doubleMatrix.matrix[n], 0, dArray[n], 0, dArray.length);
                ++n;
            }
            double[] dArray2 = dArray[0];
            dArray2[0] = dArray2[0] + this.matrix[1][0];
            double[] dArray3 = dArray[0];
            dArray3[1] = dArray3[1] + this.matrix[2][0];
            int n2 = dArray.length - 1;
            int n3 = 1;
            while (n3 < n2) {
                double[] dArray4 = dArray[n3];
                int n4 = n3 - 1;
                dArray4[n4] = dArray4[n4] + this.matrix[0][n3];
                double[] dArray5 = dArray[n3];
                int n5 = n3;
                dArray5[n5] = dArray5[n5] + this.matrix[1][n3];
                double[] dArray6 = dArray[n3];
                int n6 = n3 + 1;
                dArray6[n6] = dArray6[n6] + this.matrix[2][n3];
                ++n3;
            }
            double[] dArray7 = dArray[n2];
            int n7 = n2 - 1;
            dArray7[n7] = dArray7[n7] + this.matrix[0][n2];
            double[] dArray8 = dArray[n2];
            int n8 = n2;
            dArray8[n8] = dArray8[n8] + this.matrix[1][n2];
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        switch (1) {
            case 1: {
                return this.rawAdd(doubleSquareMatrix);
            }
            case 3: {
                return this.rawAdd((DoubleTridiagonalMatrix)doubleSquareMatrix);
            }
        }
        if (this.matrix[1].length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.getElement(n, 0) + doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.getElement(n, n2) + doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix add(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (3) {
            case 3: {
                return this.rawAdd(doubleTridiagonalMatrix);
            }
        }
        int n = this.matrix[1].length;
        if (n == doubleTridiagonalMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.matrix[1][0] = this.matrix[1][0] + doubleTridiagonalMatrix.getElement(0, 0);
            doubleTridiagonalMatrix2.matrix[2][0] = this.matrix[2][0] + doubleTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.matrix[0][n2] = this.matrix[0][n2] + doubleTridiagonalMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix2.matrix[1][n2] = this.matrix[1][n2] + doubleTridiagonalMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix2.matrix[2][n2] = this.matrix[2][n2] + doubleTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix2.matrix[0][n] = this.matrix[0][n] + doubleTridiagonalMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix2.matrix[1][n] = this.matrix[1][n] + doubleTridiagonalMatrix.getElement(n, n);
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix rawAdd(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = this.matrix[1].length;
        if (n == doubleTridiagonalMatrix.matrix[1].length) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.matrix[1][0] = this.matrix[1][0] + doubleTridiagonalMatrix.matrix[1][0];
            doubleTridiagonalMatrix2.matrix[2][0] = this.matrix[2][0] + doubleTridiagonalMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.matrix[0][n2] = this.matrix[0][n2] + doubleTridiagonalMatrix.matrix[0][n2];
                doubleTridiagonalMatrix2.matrix[1][n2] = this.matrix[1][n2] + doubleTridiagonalMatrix.matrix[1][n2];
                doubleTridiagonalMatrix2.matrix[2][n2] = this.matrix[2][n2] + doubleTridiagonalMatrix.matrix[2][n2];
                ++n2;
            }
            doubleTridiagonalMatrix2.matrix[0][n] = this.matrix[0][n] + doubleTridiagonalMatrix.matrix[0][n];
            doubleTridiagonalMatrix2.matrix[1][n] = this.matrix[1][n] + doubleTridiagonalMatrix.matrix[1][n];
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        switch (1) {
            case 1: {
                return this.rawSubtract(doubleMatrix);
            }
            case 3: {
                return this.rawSubtract((DoubleTridiagonalMatrix)doubleMatrix);
            }
        }
        if (this.matrix[1].length == doubleMatrix.rows() && this.matrix[1].length == doubleMatrix.columns()) {
            double[][] dArray = new double[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.getElement(n, 0) - doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.getElement(n, n2) - doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawSubtract(DoubleMatrix doubleMatrix) {
        if (this.matrix[1].length == doubleMatrix.matrix.length && this.matrix[1].length == doubleMatrix.matrix[0].length) {
            double[][] dArray = new double[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.getElement(n, 0) - doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.getElement(n, n2) - doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        switch (1) {
            case 1: {
                return this.rawSubtract(doubleSquareMatrix);
            }
            case 3: {
                return this.rawSubtract((DoubleTridiagonalMatrix)doubleSquareMatrix);
            }
        }
        if (this.matrix[1].length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.getElement(n, 0) - doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.getElement(n, n2) - doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix subtract(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (3) {
            case 3: {
                return this.rawSubtract(doubleTridiagonalMatrix);
            }
        }
        int n = this.matrix[1].length;
        if (n == doubleTridiagonalMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.matrix[1][0] = this.matrix[1][0] - doubleTridiagonalMatrix.getElement(0, 0);
            doubleTridiagonalMatrix2.matrix[2][0] = this.matrix[2][0] - doubleTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.matrix[0][n2] = this.matrix[0][n2] - doubleTridiagonalMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix2.matrix[1][n2] = this.matrix[1][n2] - doubleTridiagonalMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix2.matrix[2][n2] = this.matrix[2][n2] - doubleTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix2.matrix[0][n] = this.matrix[0][n] - doubleTridiagonalMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix2.matrix[1][n] = this.matrix[1][n] - doubleTridiagonalMatrix.getElement(n, n);
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix rawSubtract(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = this.matrix[1].length;
        if (n == doubleTridiagonalMatrix.matrix[1].length) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.matrix[1][0] = this.matrix[1][0] - doubleTridiagonalMatrix.matrix[1][0];
            doubleTridiagonalMatrix2.matrix[2][0] = this.matrix[2][0] - doubleTridiagonalMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.matrix[0][n2] = this.matrix[0][n2] - doubleTridiagonalMatrix.matrix[0][n2];
                doubleTridiagonalMatrix2.matrix[1][n2] = this.matrix[1][n2] - doubleTridiagonalMatrix.matrix[1][n2];
                doubleTridiagonalMatrix2.matrix[2][n2] = this.matrix[2][n2] - doubleTridiagonalMatrix.matrix[2][n2];
                ++n2;
            }
            doubleTridiagonalMatrix2.matrix[0][n] = this.matrix[0][n] - doubleTridiagonalMatrix.matrix[0][n];
            doubleTridiagonalMatrix2.matrix[1][n] = this.matrix[1][n] - doubleTridiagonalMatrix.matrix[1][n];
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix scalarMultiply(double d) {
        int n = this.matrix[1].length;
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
        doubleTridiagonalMatrix.matrix[1][0] = d * this.matrix[1][0];
        doubleTridiagonalMatrix.matrix[2][0] = d * this.matrix[2][0];
        --n;
        int n2 = 1;
        while (n2 < n) {
            doubleTridiagonalMatrix.matrix[0][n2] = d * this.matrix[0][n2];
            doubleTridiagonalMatrix.matrix[1][n2] = d * this.matrix[1][n2];
            doubleTridiagonalMatrix.matrix[2][n2] = d * this.matrix[2][n2];
            ++n2;
        }
        doubleTridiagonalMatrix.matrix[0][n] = d * this.matrix[0][n];
        doubleTridiagonalMatrix.matrix[1][n] = d * this.matrix[1][n];
        return doubleTridiagonalMatrix;
    }

    public DoubleVector multiply(DoubleVector doubleVector) {
        int n = this.matrix[1].length;
        if (n == doubleVector.dimension()) {
            double[] dArray = new double[n];
            dArray[0] = this.matrix[1][0] * doubleVector.getComponent(0) + this.matrix[2][0] * doubleVector.getComponent(1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                dArray[n2] = this.matrix[0][n2] * doubleVector.getComponent(n2 - 1) + this.matrix[1][n2] * doubleVector.getComponent(n2) + this.matrix[2][n2] * doubleVector.getComponent(n2 + 1);
                ++n2;
            }
            dArray[n] = this.matrix[0][n] * doubleVector.getComponent(n - 1) + this.matrix[1][n] * doubleVector.getComponent(n);
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public DoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        switch (1) {
            case 1: {
                return this.rawMultiply(doubleMatrix);
            }
            case 3: {
                return this.rawMultiply((DoubleTridiagonalMatrix)doubleMatrix);
            }
        }
        if (this.matrix[1].length == doubleMatrix.rows()) {
            double[][] dArray = new double[this.matrix[1].length][doubleMatrix.columns()];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.getElement(n, 0) * doubleMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < this.matrix[1].length) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.getElement(n, n3) * doubleMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleMatrix rawMultiply(DoubleMatrix doubleMatrix) {
        if (this.matrix[1].length == doubleMatrix.matrix.length) {
            double[][] dArray = new double[this.matrix[1].length][doubleMatrix.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.getElement(n, 0) * doubleMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < this.matrix[1].length) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.getElement(n, n3) * doubleMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        switch (1) {
            case 1: {
                return this.rawMultiply(doubleSquareMatrix);
            }
            case 3: {
                return this.rawMultiply((DoubleTridiagonalMatrix)doubleSquareMatrix);
            }
        }
        if (this.matrix[1].length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.getElement(n, 0) * doubleSquareMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < dArray.length) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.getElement(n, n3) * doubleSquareMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleSquareMatrix rawMultiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.matrix[1].length == doubleSquareMatrix.matrix.length) {
            double[][] dArray = new double[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.getElement(n, 0) * doubleSquareMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < dArray.length) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.getElement(n, n3) * doubleSquareMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSquareMatrix multiply(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (3) {
            case 3: {
                return this.rawMultiply(doubleTridiagonalMatrix);
            }
        }
        int n = this.matrix[1].length;
        if (n == doubleTridiagonalMatrix.rows()) {
            double[][] dArray = new double[n][n];
            dArray[0][0] = this.matrix[1][0] * doubleTridiagonalMatrix.getElement(0, 0) + this.matrix[2][0] * doubleTridiagonalMatrix.getElement(1, 0);
            dArray[0][1] = this.matrix[1][0] * doubleTridiagonalMatrix.getElement(0, 1) + this.matrix[2][0] * doubleTridiagonalMatrix.getElement(1, 1);
            dArray[0][2] = this.matrix[2][0] * doubleTridiagonalMatrix.getElement(1, 2);
            if (n > 3) {
                dArray[1][0] = this.matrix[0][1] * doubleTridiagonalMatrix.getElement(0, 0) + this.matrix[1][1] * doubleTridiagonalMatrix.getElement(1, 0);
                dArray[1][1] = this.matrix[0][1] * doubleTridiagonalMatrix.getElement(0, 1) + this.matrix[1][1] * doubleTridiagonalMatrix.getElement(1, 1) + this.matrix[2][1] * doubleTridiagonalMatrix.getElement(2, 1);
                dArray[1][2] = this.matrix[1][1] * doubleTridiagonalMatrix.getElement(1, 2) + this.matrix[2][1] * doubleTridiagonalMatrix.getElement(2, 2);
                dArray[1][3] = this.matrix[2][1] * doubleTridiagonalMatrix.getElement(2, 3);
            }
            if (n == 3) {
                dArray[1][0] = this.matrix[0][1] * doubleTridiagonalMatrix.getElement(0, 0) + this.matrix[1][1] * doubleTridiagonalMatrix.getElement(1, 0);
                dArray[1][1] = this.matrix[0][1] * doubleTridiagonalMatrix.getElement(0, 1) + this.matrix[1][1] * doubleTridiagonalMatrix.getElement(1, 1) + this.matrix[2][1] * doubleTridiagonalMatrix.getElement(2, 1);
                dArray[1][2] = this.matrix[1][1] * doubleTridiagonalMatrix.getElement(1, 2) + this.matrix[2][1] * doubleTridiagonalMatrix.getElement(2, 2);
            } else if (n > 4) {
                int n2 = 2;
                while (n2 < n - 2) {
                    dArray[n2][n2 - 2] = this.matrix[0][n2] * doubleTridiagonalMatrix.getElement(n2 - 1, n2 - 2);
                    dArray[n2][n2 - 1] = this.matrix[0][n2] * doubleTridiagonalMatrix.getElement(n2 - 1, n2 - 1) + this.matrix[1][n2] * doubleTridiagonalMatrix.getElement(n2, n2 - 1);
                    dArray[n2][n2] = this.matrix[0][n2] * doubleTridiagonalMatrix.getElement(n2 - 1, n2) + this.matrix[1][n2] * doubleTridiagonalMatrix.getElement(n2, n2) + this.matrix[2][n2] * doubleTridiagonalMatrix.getElement(n2 + 1, n2);
                    dArray[n2][n2 + 1] = this.matrix[1][n2] * doubleTridiagonalMatrix.getElement(n2, n2 + 1) + this.matrix[2][n2] * doubleTridiagonalMatrix.getElement(n2 + 1, n2 + 1);
                    dArray[n2][n2 + 2] = this.matrix[2][n2] * doubleTridiagonalMatrix.getElement(n2 + 1, n2 + 2);
                    ++n2;
                }
            }
            if (n > 3) {
                dArray[n - 2][n - 4] = this.matrix[0][n - 2] * doubleTridiagonalMatrix.getElement(n - 3, n - 4);
                dArray[n - 2][n - 3] = this.matrix[0][n - 2] * doubleTridiagonalMatrix.getElement(n - 3, n - 3) + this.matrix[1][n - 2] * doubleTridiagonalMatrix.getElement(n - 2, n - 3);
                dArray[n - 2][n - 2] = this.matrix[0][n - 2] * doubleTridiagonalMatrix.getElement(n - 3, n - 2) + this.matrix[1][n - 2] * doubleTridiagonalMatrix.getElement(n - 2, n - 2) + this.matrix[2][n - 2] * doubleTridiagonalMatrix.getElement(n - 1, n - 2);
                dArray[n - 2][n - 1] = this.matrix[1][n - 2] * doubleTridiagonalMatrix.getElement(n - 2, n - 1) + this.matrix[2][n - 2] * doubleTridiagonalMatrix.getElement(n - 1, n - 1);
            }
            dArray[n][--n - 2] = this.matrix[0][n] * doubleTridiagonalMatrix.getElement(n - 1, n - 2);
            dArray[n][n - 1] = this.matrix[0][n] * doubleTridiagonalMatrix.getElement(n - 1, n - 1) + this.matrix[1][n] * doubleTridiagonalMatrix.getElement(n, n - 1);
            dArray[n][n] = this.matrix[0][n] * doubleTridiagonalMatrix.getElement(n - 1, n) + this.matrix[1][n] * doubleTridiagonalMatrix.getElement(n, n);
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleSquareMatrix rawMultiply(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = this.matrix[1].length;
        if (n == doubleTridiagonalMatrix.matrix[1].length) {
            double[][] dArray = new double[n][n];
            dArray[0][0] = this.matrix[1][0] * doubleTridiagonalMatrix.matrix[1][0] + this.matrix[2][0] * doubleTridiagonalMatrix.matrix[0][1];
            dArray[0][1] = this.matrix[1][0] * doubleTridiagonalMatrix.matrix[2][0] + this.matrix[2][0] * doubleTridiagonalMatrix.matrix[1][1];
            dArray[0][2] = this.matrix[2][0] * doubleTridiagonalMatrix.matrix[2][1];
            if (n > 3) {
                dArray[1][0] = this.matrix[0][1] * doubleTridiagonalMatrix.matrix[1][0] + this.matrix[1][1] * doubleTridiagonalMatrix.matrix[0][1];
                dArray[1][1] = this.matrix[0][1] * doubleTridiagonalMatrix.matrix[2][0] + this.matrix[1][1] * doubleTridiagonalMatrix.matrix[1][1] + this.matrix[2][1] * doubleTridiagonalMatrix.matrix[0][2];
                dArray[1][2] = this.matrix[1][1] * doubleTridiagonalMatrix.matrix[2][1] + this.matrix[2][1] * doubleTridiagonalMatrix.matrix[1][2];
                dArray[1][3] = this.matrix[2][1] * doubleTridiagonalMatrix.matrix[2][2];
            }
            if (n == 3) {
                dArray[1][0] = this.matrix[0][1] * doubleTridiagonalMatrix.matrix[1][0] + this.matrix[1][1] * doubleTridiagonalMatrix.matrix[0][1];
                dArray[1][1] = this.matrix[0][1] * doubleTridiagonalMatrix.matrix[2][0] + this.matrix[1][1] * doubleTridiagonalMatrix.matrix[1][1] + this.matrix[2][1] * doubleTridiagonalMatrix.matrix[0][2];
                dArray[1][2] = this.matrix[1][1] * doubleTridiagonalMatrix.matrix[2][1] + this.matrix[2][1] * doubleTridiagonalMatrix.matrix[1][2];
            } else if (n > 4) {
                int n2 = 2;
                while (n2 < n - 2) {
                    dArray[n2][n2 - 2] = this.matrix[0][n2] * doubleTridiagonalMatrix.matrix[0][n2 - 1];
                    dArray[n2][n2 - 1] = this.matrix[0][n2] * doubleTridiagonalMatrix.matrix[1][n2 - 1] + this.matrix[1][n2] * doubleTridiagonalMatrix.matrix[0][n2];
                    dArray[n2][n2] = this.matrix[0][n2] * doubleTridiagonalMatrix.matrix[2][n2 - 1] + this.matrix[1][n2] * doubleTridiagonalMatrix.matrix[1][n2] + this.matrix[2][n2] * doubleTridiagonalMatrix.matrix[0][n2 + 1];
                    dArray[n2][n2 + 1] = this.matrix[1][n2] * doubleTridiagonalMatrix.matrix[2][n2] + this.matrix[2][n2] * doubleTridiagonalMatrix.matrix[1][n2 + 1];
                    dArray[n2][n2 + 2] = this.matrix[2][n2] * doubleTridiagonalMatrix.matrix[2][n2 + 1];
                    ++n2;
                }
            }
            if (n > 3) {
                dArray[n - 2][n - 4] = this.matrix[0][n - 2] * doubleTridiagonalMatrix.matrix[0][n - 3];
                dArray[n - 2][n - 3] = this.matrix[0][n - 2] * doubleTridiagonalMatrix.matrix[1][n - 3] + this.matrix[1][n - 2] * doubleTridiagonalMatrix.matrix[0][n - 2];
                dArray[n - 2][n - 2] = this.matrix[0][n - 2] * doubleTridiagonalMatrix.matrix[2][n - 3] + this.matrix[1][n - 2] * doubleTridiagonalMatrix.matrix[1][n - 2] + this.matrix[2][n - 2] * doubleTridiagonalMatrix.matrix[0][n - 1];
                dArray[n - 2][n - 1] = this.matrix[1][n - 2] * doubleTridiagonalMatrix.matrix[2][n - 2] + this.matrix[2][n - 2] * doubleTridiagonalMatrix.matrix[1][n - 1];
            }
            dArray[n][--n - 2] = this.matrix[0][n] * doubleTridiagonalMatrix.matrix[0][n - 1];
            dArray[n][n - 1] = this.matrix[0][n] * doubleTridiagonalMatrix.matrix[1][n - 1] + this.matrix[1][n] * doubleTridiagonalMatrix.matrix[0][n];
            dArray[n][n] = this.matrix[0][n] * doubleTridiagonalMatrix.matrix[2][n - 1] + this.matrix[1][n] * doubleTridiagonalMatrix.matrix[1][n];
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.matrix[1].length);
        System.arraycopy(this.matrix[0], 1, doubleTridiagonalMatrix.matrix[2], 0, this.matrix[0].length - 1);
        System.arraycopy(this.matrix[1], 0, doubleTridiagonalMatrix.matrix[1], 0, this.matrix[1].length);
        System.arraycopy(this.matrix[2], 0, doubleTridiagonalMatrix.matrix[0], 1, this.matrix[2].length - 1);
        return doubleTridiagonalMatrix;
    }

    public DoubleSquareMatrix[] luDecompose() {
        double[][][] dArray = new double[2][this.matrix[1].length][this.matrix[1].length];
        dArray[0][0][0] = 1.0;
        int n = 1;
        while (n < this.matrix[1].length) {
            dArray[0][n][n] = 1.0;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.matrix[1].length) {
            int n3;
            double d;
            n = 0;
            while (n <= n2) {
                d = this.getElement(n, n2);
                n3 = 0;
                while (n3 < n) {
                    d -= dArray[0][n][n3] * dArray[1][n3][n2];
                    ++n3;
                }
                dArray[1][n][n2] = d;
                ++n;
            }
            n = n2 + 1;
            while (n < this.matrix[1].length) {
                d = this.getElement(n, n2);
                n3 = 0;
                while (n3 < n2) {
                    d -= dArray[0][n][n3] * dArray[1][n3][n2];
                    ++n3;
                }
                dArray[0][n][n2] = d / dArray[1][n2][n2];
                ++n;
            }
            ++n2;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray[0]), new DoubleSquareMatrix(dArray[1])};
        return doubleSquareMatrixArray;
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        double[][][] dArray = new double[2][this.matrix[1].length][this.matrix[1].length];
        double d = Math.sqrt(this.getElement(0, 0));
        dArray[1][0][0] = d;
        dArray[0][0][0] = d;
        int n = 1;
        while (n < this.matrix[1].length) {
            double d2 = this.getElement(n, 0) / dArray[0][0][0];
            dArray[1][0][n] = d2;
            dArray[0][n][0] = d2;
            ++n;
        }
        int n2 = 1;
        while (n2 < this.matrix[1].length) {
            double d3 = this.getElement(n2, n2);
            n = 0;
            while (n < n2) {
                d3 -= dArray[0][n2][n] * dArray[0][n2][n];
                ++n;
            }
            double d4 = Math.sqrt(d3);
            dArray[1][n2][n2] = d4;
            dArray[0][n2][n2] = d4;
            n = n2 + 1;
            while (n < this.matrix[1].length) {
                d3 = this.getElement(n, n2);
                int n3 = 0;
                while (n3 < n) {
                    d3 -= dArray[0][n2][n3] * dArray[1][n3][n];
                    ++n3;
                }
                double d5 = d3 / dArray[1][n2][n2];
                dArray[1][n2][n] = d5;
                dArray[0][n][n2] = d5;
                ++n;
            }
            ++n2;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray[0]), new DoubleSquareMatrix(dArray[1])};
        return doubleSquareMatrixArray;
    }

    public DoubleMatrix mapElements(Mapping mapping) {
        int n = this.matrix[1].length;
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(n);
        doubleTridiagonalMatrix.matrix[1][0] = mapping.map(this.matrix[1][0]);
        doubleTridiagonalMatrix.matrix[2][0] = mapping.map(this.matrix[2][0]);
        --n;
        int n2 = 1;
        while (n2 < n) {
            doubleTridiagonalMatrix.matrix[0][n2] = mapping.map(this.matrix[0][n2]);
            doubleTridiagonalMatrix.matrix[1][n2] = mapping.map(this.matrix[1][n2]);
            doubleTridiagonalMatrix.matrix[2][n2] = mapping.map(this.matrix[2][n2]);
            ++n2;
        }
        doubleTridiagonalMatrix.matrix[0][n] = mapping.map(this.matrix[0][n]);
        doubleTridiagonalMatrix.matrix[1][n] = mapping.map(this.matrix[1][n]);
        return doubleTridiagonalMatrix;
    }
}

