/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.MathInteger;
import JSci.maths.RingMember;
import JSci.maths.fields.FieldMember;
import JSci.maths.groups.AbelianGroupMember;
import java.io.Serializable;

public final class MathDouble
implements FieldMember,
Serializable {
    private double x;

    public MathDouble(double d) {
        this.x = d;
    }

    public MathDouble(String string) throws NumberFormatException {
        this.x = Double.valueOf(string);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MathDouble) {
            MathDouble mathDouble = (MathDouble)object;
            return Math.abs(this.x - mathDouble.x) <= GlobalSettings.ZERO_TOL;
        }
        return false;
    }

    public String toString() {
        return Double.toString(this.x);
    }

    public double value() {
        return this.x;
    }

    public boolean isNaN() {
        return this.x == Double.NaN;
    }

    public boolean isInfinite() {
        return this.x == Double.POSITIVE_INFINITY || this.x == Double.NEGATIVE_INFINITY;
    }

    public AbelianGroupMember negate() {
        return new MathDouble(-this.x);
    }

    public FieldMember inverse() {
        return new MathDouble(1.0 / this.x);
    }

    public AbelianGroupMember add(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof MathDouble) {
            MathDouble mathDouble = (MathDouble)abelianGroupMember;
            return new MathDouble(this.x + mathDouble.x);
        }
        if (abelianGroupMember instanceof MathInteger) {
            MathDouble mathDouble = new MathDouble(((MathInteger)abelianGroupMember).value());
            return new MathDouble(this.x + mathDouble.x);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public MathDouble add(MathDouble mathDouble) {
        return new MathDouble(this.x + mathDouble.x);
    }

    public AbelianGroupMember subtract(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof MathDouble) {
            MathDouble mathDouble = (MathDouble)abelianGroupMember;
            return new MathDouble(this.x - mathDouble.x);
        }
        if (abelianGroupMember instanceof MathInteger) {
            MathDouble mathDouble = new MathDouble(((MathInteger)abelianGroupMember).value());
            return new MathDouble(this.x - mathDouble.x);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public MathDouble subtract(MathDouble mathDouble) {
        return new MathDouble(this.x - mathDouble.x);
    }

    public RingMember multiply(RingMember ringMember) {
        if (ringMember instanceof MathDouble) {
            MathDouble mathDouble = (MathDouble)ringMember;
            return new MathDouble(this.x * mathDouble.x);
        }
        if (ringMember instanceof MathInteger) {
            MathDouble mathDouble = new MathDouble(((MathInteger)ringMember).value());
            return new MathDouble(this.x * mathDouble.x);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public MathDouble multiply(MathDouble mathDouble) {
        return new MathDouble(this.x * mathDouble.x);
    }

    public FieldMember divide(FieldMember fieldMember) {
        if (fieldMember instanceof MathDouble) {
            MathDouble mathDouble = (MathDouble)fieldMember;
            return new MathDouble(this.x / mathDouble.x);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public MathDouble divide(MathDouble mathDouble) {
        return new MathDouble(this.x / mathDouble.x);
    }
}

