/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.Double3Vector;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.RingMember;
import JSci.maths.fields.FieldMember;
import JSci.maths.groups.AbelianGroupMember;
import java.io.Serializable;

public final class Quaternion
implements FieldMember,
Serializable {
    private double re;
    private Double3Vector im;

    public Quaternion(double d, Double3Vector double3Vector) {
        this.re = d;
        this.im = double3Vector;
    }

    public Quaternion(double d, double d2, double d3, double d4) {
        this.re = d;
        this.im = new Double3Vector(d2, d3, d4);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Quaternion) {
            Quaternion quaternion = (Quaternion)object;
            return Math.abs(this.re - quaternion.re) <= GlobalSettings.ZERO_TOL && this.im.equals(quaternion.im);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.re);
        if (this.im.vector[0] >= 0.0) {
            stringBuffer.append("+");
        }
        stringBuffer.append(this.im.vector[0]);
        stringBuffer.append("i");
        if (this.im.vector[1] >= 0.0) {
            stringBuffer.append("+");
        }
        stringBuffer.append(this.im.vector[1]);
        stringBuffer.append("j");
        if (this.im.vector[2] >= 0.0) {
            stringBuffer.append("+");
        }
        stringBuffer.append(this.im.vector[2]);
        stringBuffer.append("k");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.mod());
    }

    public boolean isNaN() {
        return this.re == Double.NaN || this.im.vector[0] == Double.NaN || this.im.vector[1] == Double.NaN || this.im.vector[2] == Double.NaN;
    }

    public boolean isInfinite() {
        return this.re == Double.POSITIVE_INFINITY || this.re == Double.NEGATIVE_INFINITY || this.im.vector[0] == Double.POSITIVE_INFINITY || this.im.vector[0] == Double.NEGATIVE_INFINITY || this.im.vector[1] == Double.POSITIVE_INFINITY || this.im.vector[1] == Double.NEGATIVE_INFINITY || this.im.vector[2] == Double.POSITIVE_INFINITY || this.im.vector[2] == Double.NEGATIVE_INFINITY;
    }

    public double real() {
        return this.re;
    }

    public Double3Vector imag() {
        return this.im;
    }

    public double mod() {
        double d;
        double d2 = this.im.norm();
        if (this.re == 0.0 && d2 == 0.0) {
            return 0.0;
        }
        double d3 = Math.abs(this.re);
        if (d3 < (d = Math.abs(d2))) {
            return d * Math.sqrt(1.0 + this.re / d2 * (this.re / d2));
        }
        return d3 * Math.sqrt(1.0 + d2 / this.re * (d2 / this.re));
    }

    public AbelianGroupMember negate() {
        return new Quaternion(-this.re, -this.im.vector[0], -this.im.vector[1], -this.im.vector[2]);
    }

    public FieldMember inverse() {
        double d = this.mod();
        Quaternion quaternion = this.conjugate();
        double d2 = d * d;
        return new Quaternion(quaternion.re / d2, (Double3Vector)quaternion.im.scalarDivide(d2));
    }

    public Quaternion conjugate() {
        return new Quaternion(this.re, -this.im.vector[0], -this.im.vector[1], -this.im.vector[2]);
    }

    public AbelianGroupMember add(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof Quaternion) {
            Quaternion quaternion = (Quaternion)abelianGroupMember;
            return new Quaternion(this.re + quaternion.re, this.im.add(quaternion.im));
        }
        if (abelianGroupMember instanceof MathDouble) {
            double d = ((MathDouble)abelianGroupMember).value();
            return new Quaternion(this.re + d, this.im);
        }
        if (abelianGroupMember instanceof MathInteger) {
            double d = ((MathInteger)abelianGroupMember).value();
            return new Quaternion(this.re + d, this.im);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion add(Quaternion quaternion) {
        return new Quaternion(this.re + quaternion.re, this.im.add(quaternion.im));
    }

    public Quaternion addReal(double d) {
        return new Quaternion(this.re + d, this.im);
    }

    public Quaternion addImag(Double3Vector double3Vector) {
        return new Quaternion(this.re, this.im.add(double3Vector));
    }

    public AbelianGroupMember subtract(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof Quaternion) {
            Quaternion quaternion = (Quaternion)abelianGroupMember;
            return new Quaternion(this.re - quaternion.re, this.im.subtract(quaternion.im));
        }
        if (abelianGroupMember instanceof MathDouble) {
            double d = ((MathDouble)abelianGroupMember).value();
            return new Quaternion(this.re - d, this.im);
        }
        if (abelianGroupMember instanceof MathInteger) {
            double d = ((MathInteger)abelianGroupMember).value();
            return new Quaternion(this.re - d, this.im);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion subtract(Quaternion quaternion) {
        return new Quaternion(this.re - quaternion.re, this.im.subtract(quaternion.im));
    }

    public Quaternion subtractReal(double d) {
        return new Quaternion(this.re - d, this.im);
    }

    public Quaternion subtractImag(Double3Vector double3Vector) {
        return new Quaternion(this.re, this.im.subtract(double3Vector));
    }

    public RingMember multiply(RingMember ringMember) {
        if (ringMember instanceof Quaternion) {
            return this.multiply((Quaternion)ringMember);
        }
        if (ringMember instanceof MathDouble) {
            double d = ((MathDouble)ringMember).value();
            return new Quaternion(d * this.re, (Double3Vector)this.im.scalarMultiply(d));
        }
        if (ringMember instanceof MathInteger) {
            double d = ((MathInteger)ringMember).value();
            return new Quaternion(d * this.re, (Double3Vector)this.im.scalarMultiply(d));
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion multiply(Quaternion quaternion) {
        return new Quaternion(this.re * quaternion.re - this.im.scalarProduct(quaternion.im), (Double3Vector)quaternion.im.scalarMultiply(this.re).add(this.im.scalarMultiply(quaternion.re)).add(this.im.multiply(quaternion.im)));
    }

    public Quaternion multiply(double d) {
        return new Quaternion(d * this.re, (Double3Vector)this.im.scalarMultiply(d));
    }

    public FieldMember divide(FieldMember fieldMember) {
        if (fieldMember instanceof Quaternion) {
            return this.divide((Quaternion)fieldMember);
        }
        if (fieldMember instanceof MathDouble) {
            double d = ((MathDouble)fieldMember).value();
            return new Quaternion(this.re / d, (Double3Vector)this.im.scalarDivide(d));
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Quaternion divide(Quaternion quaternion) {
        double d = quaternion.mod();
        Quaternion quaternion2 = this.multiply(quaternion.conjugate());
        double d2 = d * d;
        return new Quaternion(quaternion2.re / d2, (Double3Vector)quaternion2.im.scalarDivide(d2));
    }

    public Quaternion divide(double d) {
        return new Quaternion(this.re / d, (Double3Vector)this.im.scalarDivide(d));
    }
}

