/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.chaos;

import JSci.maths.Complex;
import JSci.maths.NMapping;

public final class HenonMap
implements NMapping {
    private Complex a;
    private Complex b;
    public static final Complex A_CHAOS = new Complex(1.4, 0.0);
    public static final Complex B_CHAOS = new Complex(0.3, 0.0);

    public HenonMap(double d, double d2) {
        this.a = new Complex(d, 0.0);
        this.b = new Complex(d2, 0.0);
    }

    public HenonMap(Complex complex, Complex complex2) {
        this.a = complex;
        this.b = complex2;
    }

    public double[] map(double[] dArray) {
        double[] dArray2 = new double[]{1.0 - this.a.real() * dArray[0] * dArray[0] + dArray[1], this.b.real() * dArray[0]};
        return dArray2;
    }

    public Complex[] map(Complex[] complexArray) {
        Complex[] complexArray2 = new Complex[]{Complex.ONE.add(complexArray[1]).subtract(this.a.multiply(complexArray[0].sqr())), this.b.multiply(complexArray[0])};
        return complexArray2;
    }

    public double[] iterate(int n, double[] dArray) {
        double[] dArray2 = this.map(dArray);
        int n2 = 1;
        while (n2 < n) {
            dArray2 = this.map(dArray2);
            ++n2;
        }
        return dArray2;
    }

    public Complex[] iterate(int n, Complex[] complexArray) {
        Complex[] complexArray2 = this.map(complexArray);
        int n2 = 1;
        while (n2 < n) {
            complexArray2 = this.map(complexArray2);
            ++n2;
        }
        return complexArray2;
    }
}

