/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.chaos;

import JSci.maths.Complex;
import JSci.maths.Mapping;

public final class MandelbrotMap
implements Mapping {
    private Complex a;

    public MandelbrotMap(double d) {
        this.a = new Complex(d, 0.0);
    }

    public MandelbrotMap(Complex complex) {
        this.a = complex;
    }

    public double map(double d) {
        return d * d - this.a.real();
    }

    public Complex map(Complex complex) {
        return complex.sqr().subtract(this.a);
    }

    public double iterate(int n, double d) {
        int n2 = 0;
        while (n2 < n) {
            d = d * d - this.a.real();
            ++n2;
        }
        return d;
    }

    public Complex iterate(int n, Complex complex) {
        int n2 = 0;
        while (n2 < n) {
            complex = complex.sqr().subtract(this.a);
            ++n2;
        }
        return complex;
    }
}

