/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.groups;

import JSci.maths.Complex;
import JSci.maths.ComplexDiagonalMatrix;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.groups.Group;

public class LieGroup
implements Group {
    private ComplexSquareMatrix[] generators;
    private ComplexSquareMatrix identityMatrix;

    public LieGroup(ComplexSquareMatrix[] complexSquareMatrixArray) {
        this.generators = complexSquareMatrixArray;
        this.identityMatrix = ComplexDiagonalMatrix.identity(this.generators[0].rows());
    }

    public final int dimension() {
        return this.generators.length;
    }

    public ComplexSquareMatrix getElement(DoubleVector doubleVector) {
        if (this.generators.length != doubleVector.dimension()) {
            throw new IllegalArgumentException("The vector should match the generators.");
        }
        ComplexMatrix complexMatrix = this.generators[0].scalarMultiply(doubleVector.getComponent(0));
        int n = 1;
        while (n < this.generators.length) {
            complexMatrix = complexMatrix.add(this.generators[n].scalarMultiply(doubleVector.getComponent(n)));
            ++n;
        }
        return (ComplexSquareMatrix)this.identityMatrix.add(complexMatrix.scalarMultiply(Complex.I));
    }

    public Object compose(Object object, Object object2) {
        if (!(object instanceof ComplexSquareMatrix) || !(object2 instanceof ComplexSquareMatrix)) {
            throw new IllegalArgumentException("Must be a complex square matrix.");
        }
        return ((ComplexSquareMatrix)object).multiply((ComplexSquareMatrix)object2);
    }

    public Object identity() {
        return this.identityMatrix;
    }

    public Object inverse(Object object) {
        if (!(object instanceof ComplexSquareMatrix)) {
            throw new IllegalArgumentException("Must be a complex square matrix.");
        }
        return ((ComplexSquareMatrix)object).inverse();
    }

    public final boolean isIdentity(Object object) {
        return this.identityMatrix.equals(object);
    }

    public final boolean isInverse(Object object, Object object2) {
        Object object3 = this.compose(object, object2);
        return this.identityMatrix.equals(object3);
    }
}

