/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.NumericalConstants;
import JSci.maths.SpecialMath;
import JSci.maths.statistics.OutOfRangeException;
import JSci.maths.statistics.ProbabilityDistribution;

public final class NormalDistribution
extends ProbabilityDistribution
implements NumericalConstants {
    private double mean;
    private double variance;
    private double pdfDenominator;
    private double cdfDenominator;

    public NormalDistribution() {
        this(0.0, 1.0);
    }

    public NormalDistribution(double d, double d2) {
        this.mean = d;
        if (d2 <= 0.0) {
            throw new OutOfRangeException("The variance should be (strictly) positive.");
        }
        this.variance = d2;
        this.pdfDenominator = 1.4142135623730951 * Math.sqrt(this.variance * Math.PI);
        this.cdfDenominator = 1.4142135623730951 * Math.sqrt(this.variance);
    }

    public NormalDistribution(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[0] * dArray[0];
        int n = 1;
        while (n < dArray.length) {
            d += dArray[n];
            d2 += dArray[n] * dArray[n];
            ++n;
        }
        this.mean = d / (double)dArray.length;
        this.variance = this.mean * this.mean - d2 / (double)(dArray.length * dArray.length);
        this.pdfDenominator = 1.4142135623730951 * Math.sqrt(this.variance * Math.PI);
        this.cdfDenominator = 1.4142135623730951 * Math.sqrt(this.variance);
    }

    public double getMean() {
        return this.mean;
    }

    public double getVariance() {
        return this.variance;
    }

    public double probability(double d) {
        return Math.exp(-(d - this.mean) * (d - this.mean) / (2.0 * this.variance)) / this.pdfDenominator;
    }

    public double cumulative(double d) {
        return SpecialMath.complementaryError(-(d - this.mean) / this.cdfDenominator) / 2.0;
    }

    public double inverse(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException("The argument of the distribution method should be between 0 and 1.");
        }
        if (d == 0.0) {
            return -1.7976931348623157E308;
        }
        if (d == 1.0) {
            return Double.MAX_VALUE;
        }
        if (d == 0.5) {
            return this.mean;
        }
        double d2 = this.mean;
        double d3 = this.variance;
        double d4 = this.pdfDenominator;
        double d5 = this.cdfDenominator;
        this.mean = 0.0;
        this.variance = 1.0;
        this.pdfDenominator = Math.sqrt(Math.PI * 2);
        this.cdfDenominator = 1.4142135623730951;
        double d6 = this.findRoot(d, 0.0, -100.0, 100.0);
        this.mean = d2;
        this.variance = d3;
        this.pdfDenominator = d4;
        this.cdfDenominator = d5;
        return d6 * Math.sqrt(this.variance) + this.mean;
    }
}

