/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.DOMExceptionImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedNodeMapImpl
implements NamedNodeMap,
Serializable {
    static final long serialVersionUID = -7039242451046758020L;
    static final boolean DEBUG = false;
    protected Vector nodes;
    protected Document ownerDocument;
    protected ElementImpl element;
    protected NamedNodeMapImpl defaults;
    protected int changes;
    protected int lastDefaultsChanges = -1;
    protected boolean readOnly = false;

    protected NamedNodeMapImpl(ElementImpl elementImpl, NamedNodeMapImpl namedNodeMapImpl) {
        this(elementImpl.getOwnerDocument(), namedNodeMapImpl);
        this.element = elementImpl;
    }

    protected NamedNodeMapImpl(Document document, NamedNodeMapImpl namedNodeMapImpl) {
        this.ownerDocument = document;
        this.defaults = namedNodeMapImpl;
    }

    public NamedNodeMapImpl cloneMap() {
        boolean bl = true;
        NamedNodeMapImpl namedNodeMapImpl = new NamedNodeMapImpl(this.ownerDocument, this.defaults);
        if (this.nodes != null) {
            namedNodeMapImpl.nodes = new Vector(this.nodes.size());
            int n = 0;
            while (n < this.nodes.size()) {
                NodeImpl nodeImpl = (NodeImpl)((Node)this.nodes.elementAt(n)).cloneNode(bl);
                nodeImpl.parentNode = this.element;
                namedNodeMapImpl.nodes.addElement(nodeImpl);
                ++n;
            }
        }
        namedNodeMapImpl.defaults = this.defaults;
        namedNodeMapImpl.lastDefaultsChanges = this.lastDefaultsChanges;
        return namedNodeMapImpl;
    }

    private int findNamePoint(String string, int n) {
        this.reconcileDefaults();
        int n2 = 0;
        if (this.nodes != null) {
            int n3 = n;
            int n4 = this.nodes.size() - 1;
            while (n3 <= n4) {
                n2 = (n3 + n4) / 2;
                int n5 = string.compareTo(((Node)this.nodes.elementAt(n2)).getNodeName());
                if (n5 == 0) {
                    return n2;
                }
                if (n5 < 0) {
                    n4 = n2 - 1;
                    continue;
                }
                n3 = n2 + 1;
            }
            if (n3 > n2) {
                n2 = n3;
            }
        }
        return -1 - n2;
    }

    private int findNamePoint(String string, String string2) {
        this.reconcileDefaults();
        if (this.nodes == null) {
            return -1;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return -1;
        }
        int n = 0;
        while (n < this.nodes.size()) {
            NodeImpl nodeImpl = (NodeImpl)this.nodes.elementAt(n);
            if (string.equals(nodeImpl.getNamespaceURI()) && string2.equals(nodeImpl.getLocalName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getLength() {
        this.reconcileDefaults();
        return this.nodes != null ? this.nodes.size() : 0;
    }

    public Node getNamedItem(String string) {
        int n = this.findNamePoint(string, 0);
        return n < 0 ? null : (Node)this.nodes.elementAt(n);
    }

    public Node getNamedItemNS(String string, String string2) {
        int n = this.findNamePoint(string, string2);
        return n < 0 ? null : (Node)this.nodes.elementAt(n);
    }

    boolean getReadOnly() {
        return this.readOnly;
    }

    public Node item(int n) {
        this.reconcileDefaults();
        return this.nodes != null && n < this.nodes.size() ? (Node)this.nodes.elementAt(n) : null;
    }

    protected void reconcileDefaults() {
        if (this.defaults != null && this.lastDefaultsChanges != this.defaults.changes) {
            int n = 0;
            int n2 = 0;
            int n3 = this.nodes != null ? this.nodes.size() : 0;
            int n4 = this.defaults.nodes.size();
            AttrImpl attrImpl = n3 == 0 ? null : (AttrImpl)this.nodes.elementAt(0);
            AttrImpl attrImpl2 = n4 == 0 ? null : (AttrImpl)this.defaults.nodes.elementAt(0);
            while (n < n3 && n2 < n4) {
                NodeImpl nodeImpl;
                attrImpl = (AttrImpl)this.nodes.elementAt(n);
                attrImpl2 = (AttrImpl)this.defaults.nodes.elementAt(n2);
                int n5 = attrImpl.getNodeName().compareTo(attrImpl2.getNodeName());
                if (n5 == 0) {
                    if (!attrImpl.getSpecified()) {
                        nodeImpl = (NodeImpl)attrImpl2.cloneNode(true);
                        nodeImpl.parentNode = this.element;
                        this.nodes.setElementAt(nodeImpl, n);
                        ++n;
                        ++n2;
                        continue;
                    }
                    System.out.println("reconcile (test==0, specified=true): just increment");
                    ++n;
                    ++n2;
                    continue;
                }
                if (n5 > 0) {
                    nodeImpl = (NodeImpl)attrImpl2.cloneNode(true);
                    nodeImpl.parentNode = this.element;
                    this.nodes.insertElementAt(nodeImpl, n);
                    ++n;
                    ++n2;
                    continue;
                }
                if (!attrImpl.getSpecified()) {
                    this.nodes.removeElementAt(n);
                    continue;
                }
                ++n;
            }
            if (n2 < n4) {
                if (this.nodes == null) {
                    this.nodes = new Vector();
                }
                while (n2 < n4) {
                    attrImpl2 = (AttrImpl)this.defaults.nodes.elementAt(n2++);
                    NodeImpl nodeImpl = (NodeImpl)attrImpl2.cloneNode(true);
                    nodeImpl.parentNode = this.element;
                    this.nodes.addElement(nodeImpl);
                }
            }
            this.lastDefaultsChanges = this.defaults.changes;
        }
    }

    public Node removeNamedItem(String string) throws DOMException {
        Node node;
        int n = this.findNamePoint(string, 0);
        if (n < 0) {
            throw new DOMExceptionImpl(8, "DOM008 Not found");
        }
        Node node2 = (Node)this.nodes.elementAt(n);
        if (this.defaults != null && (node = this.defaults.getNamedItem(string)) != null && this.findNamePoint(string, n + 1) < 0) {
            NodeImpl nodeImpl = (NodeImpl)node.cloneNode(true);
            nodeImpl.parentNode = this.element;
            this.nodes.setElementAt(nodeImpl, n);
        } else {
            this.nodes.removeElementAt(n);
        }
        if (this.element != null) {
            ((NodeImpl)node2).parentNode = null;
        }
        ++this.changes;
        return node2;
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        Node node;
        int n = this.findNamePoint(string, string2);
        if (n < 0) {
            throw new DOMExceptionImpl(8, "DOM008 Not found");
        }
        LCount lCount = null;
        String string3 = "";
        AttrImpl attrImpl = null;
        if (this.element != null) {
            lCount = LCount.lookup("DOMAttrModified");
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                attrImpl = (AttrImpl)this.nodes.elementAt(n);
                string3 = attrImpl.getNodeValue();
            }
        }
        Node node2 = (Node)this.nodes.elementAt(n);
        String string4 = node2.getNodeName();
        if (this.defaults != null && (node = this.defaults.getNamedItem(string4)) != null) {
            int n2 = this.findNamePoint(string4, 0);
            if (n2 >= 0 && this.findNamePoint(string4, n2 + 1) < 0) {
                NodeImpl nodeImpl = (NodeImpl)node.cloneNode(true);
                nodeImpl.parentNode = this.element;
                this.nodes.setElementAt(nodeImpl, n);
            } else {
                this.nodes.removeElementAt(n);
            }
        } else {
            this.nodes.removeElementAt(n);
        }
        if (this.element != null) {
            AttrImpl attrImpl2 = (AttrImpl)node2;
            attrImpl2.parentNode = null;
            attrImpl2.owned = false;
        }
        ++this.changes;
        if (this.element != null) {
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                MutationEventImpl mutationEventImpl = new MutationEventImpl();
                mutationEventImpl.initMutationEvent("DOMAttrModified", true, false, null, node2.getNodeValue(), this.element.getAttribute(string2), string2);
                this.element.dispatchEvent(mutationEventImpl);
            }
            this.element.dispatchAggregateEvents(null, null);
        }
        return node2;
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "DOM001 Modification not allowed");
        }
        if (node.getOwnerDocument() != this.ownerDocument) {
            throw new DOMExceptionImpl(4, "DOM005 Wrong document");
        }
        if (node instanceof AttrImpl && ((AttrImpl)node).owned) {
            throw new DOMExceptionImpl(10, "DOM009 Attribute already in use");
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        int n = this.findNamePoint(node.getNodeName(), 0);
        Node node2 = null;
        if (n >= 0) {
            node2 = (Node)this.nodes.elementAt(n);
            if (this.element != null) {
                ((NodeImpl)node).parentNode = this.element;
            }
            this.nodes.setElementAt(node, n);
        } else {
            n = -1 - n;
            if (this.nodes == null) {
                this.nodes = new Vector(5, 10);
            }
            if (this.element != null) {
                ((NodeImpl)node).parentNode = this.element;
            }
            this.nodes.insertElementAt(node, n);
        }
        if (this.element != null) {
            ((NodeImpl)node).parentNode = this.element;
        }
        ++this.changes;
        if (this.element != null) {
            this.element.dispatchAggregateEvents((AttrImpl)node, node2 == null ? null : node2.getNodeValue());
        }
        return node2;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "DOM001 Modification not allowed");
        }
        if (node.getOwnerDocument() != this.ownerDocument) {
            throw new DOMExceptionImpl(4, "DOM005 Wrong document");
        }
        if (node instanceof AttrImpl && ((AttrImpl)node).owned) {
            throw new DOMExceptionImpl(10, "DOM009 Attribute already in use");
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        int n = this.findNamePoint(nodeImpl.getNamespaceURI(), nodeImpl.getLocalName());
        Node node2 = null;
        if (n >= 0) {
            node2 = (Node)this.nodes.elementAt(n);
            if (this.element != null) {
                ((NodeImpl)node).parentNode = this.element;
            }
            this.nodes.setElementAt(node, n);
        } else {
            n = this.findNamePoint(nodeImpl.getNodeName(), 0);
            if (n >= 0) {
                node2 = (Node)this.nodes.elementAt(n);
                if (this.element != null) {
                    ((NodeImpl)node).parentNode = this.element;
                }
                this.nodes.insertElementAt(node, n);
            } else {
                n = -1 - n;
                if (this.nodes == null) {
                    this.nodes = new Vector(5, 10);
                }
                if (this.element != null) {
                    ((NodeImpl)node).parentNode = this.element;
                }
                this.nodes.insertElementAt(node, n);
            }
        }
        if (this.element != null) {
            ((NodeImpl)node).parentNode = this.element;
        }
        ++this.changes;
        if (this.element != null) {
            this.element.dispatchAggregateEvents((AttrImpl)node, node2 == null ? null : node2.getNodeValue());
        }
        return node2;
    }

    void setReadOnly(boolean bl, boolean bl2) {
        this.readOnly = bl;
        if (bl2 && this.nodes != null) {
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                ((NodeImpl)enumeration.nextElement()).setReadOnly(bl, bl2);
            }
        }
    }
}

