/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

import org.apache.xerces.utils.StringHasher;
import org.apache.xerces.utils.SymbolCache;

public final class StringPool {
    private static final boolean DEBUG_ADDITIONS = false;
    public static final int NULL_STRING = -1;
    public static final int EMPTY_STRING = 0;
    private static final int INITIAL_CHUNK_SHIFT = 8;
    private static final int INITIAL_CHUNK_SIZE = 256;
    private static final int CHUNK_SHIFT = 13;
    private static final int CHUNK_SIZE = 8192;
    private static final int CHUNK_MASK = 8191;
    private static final int INITIAL_CHUNK_COUNT = 8;
    private int fStringCount = 0;
    private int fStringFreeList = -1;
    private String[][] fString = new String[8][];
    private StringProducer[][] fStringProducer = new StringProducer[8][];
    private int[][] fOffset = new int[8][];
    private int[][] fLength = new int[8][];
    private int[][] fCharsOffset = new int[8][];
    private int[][] fDeclaration = new int[8][];
    private static final int QNAME_MASK = 0x60000000;
    private static final int QNAME_FLAG = 0x40000000;
    private int fQNameCount = 0;
    private int[][] fFullName = new int[8][];
    private int[][] fPrefix = new int[8][];
    private int[][] fLocalPart = new int[8][];
    private int[][] fURI = new int[8][];
    private int fStringListCount = 0;
    private int fActiveStringList = -1;
    private int[][] fStringList = new int[8][];
    private static final int INITIAL_BUCKET_SIZE = 4;
    private static final int HASHTABLE_SIZE = 128;
    private int[][] fSymbolTable = new int[128][];
    private SymbolCache fSymbolCache = new SymbolCache();
    private int fShuffleCount = 0;

    public StringPool() {
        if (this.addSymbol("") != 0) {
            throw new RuntimeException("UTL002 cannot happen");
        }
    }

    public int addNewSymbol(String string, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = n % 128;
        int[] nArray = this.fSymbolTable[n5];
        if (this.fStringFreeList != -1) {
            n4 = this.fStringFreeList;
            n3 = n4 >> 13;
            n2 = n4 & 0x1FFF;
            this.fStringFreeList = this.fOffset[n3][n2];
        } else {
            n4 = this.fStringCount++;
            n3 = n4 >> 13;
            n2 = n4 & 0x1FFF;
            this.ensureCapacity(n3, n2);
        }
        int n6 = string.length();
        this.fString[n3][n2] = string;
        this.fStringProducer[n3][n2] = null;
        this.fOffset[n3][n2] = -1;
        this.fLength[n3][n2] = n6;
        this.fDeclaration[n3][n2] = -1;
        this.fCharsOffset[n3][n2] = this.fSymbolCache.addSymbolToCache(string, n6, n4);
        this.hashSymbol(nArray, n, n3, n2);
        return n4;
    }

    public int addQName(int n, int n2, int n3) {
        int n4 = this.fQNameCount++;
        int n5 = n4 >> 13;
        int n6 = n4 & 0x1FFF;
        this.ensureQNameCapacity(n5, n6);
        this.fFullName[n5][n6] = n;
        this.fPrefix[n5][n6] = n2;
        this.fLocalPart[n5][n6] = n3;
        this.fURI[n5][n6] = -1;
        return n4 | 0x40000000;
    }

    public int addString(String string) {
        int n;
        int n2;
        int n3;
        if (this.fStringFreeList != -1) {
            n3 = this.fStringFreeList;
            n2 = n3 >> 13;
            n = n3 & 0x1FFF;
            this.fStringFreeList = this.fOffset[n2][n];
        } else {
            n3 = this.fStringCount++;
            n2 = n3 >> 13;
            n = n3 & 0x1FFF;
            this.ensureCapacity(n2, n);
        }
        this.fString[n2][n] = string;
        this.fStringProducer[n2][n] = null;
        this.fOffset[n2][n] = 0;
        this.fLength[n2][n] = string.length();
        this.fCharsOffset[n2][n] = -1;
        this.fDeclaration[n2][n] = -1;
        return n3;
    }

    public int addString(StringProducer stringProducer, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (this.fStringFreeList != -1) {
            n5 = this.fStringFreeList;
            n4 = n5 >> 13;
            n3 = n5 & 0x1FFF;
            this.fStringFreeList = this.fOffset[n4][n3];
        } else {
            n5 = this.fStringCount++;
            n4 = n5 >> 13;
            n3 = n5 & 0x1FFF;
            this.ensureCapacity(n4, n3);
        }
        this.fString[n4][n3] = null;
        this.fStringProducer[n4][n3] = stringProducer;
        this.fOffset[n4][n3] = n;
        this.fLength[n4][n3] = n2;
        this.fCharsOffset[n4][n3] = -1;
        this.fDeclaration[n4][n3] = -1;
        return n5;
    }

    public boolean addStringToList(int n, int n2) {
        if (n2 == -1 || n != this.fActiveStringList) {
            return false;
        }
        int n3 = this.fStringListCount >> 13;
        int n4 = this.fStringListCount & 0x1FFF;
        this.ensureListCapacity(n3, n4);
        this.fStringList[n3][n4] = n2;
        ++this.fStringListCount;
        return true;
    }

    public int addSymbol(int n) {
        if ((n & 0x60000000) == 0x40000000) {
            return n;
        }
        if (n < 0 || n >= this.fStringCount) {
            return -1;
        }
        int n2 = n >> 13;
        int n3 = n & 0x1FFF;
        if (this.fOffset[n2][n3] == -1) {
            return n;
        }
        String string = this.fString[n2][n3];
        if (string == null) {
            string = this.fStringProducer[n2][n3].toString(this.fOffset[n2][n3], this.fLength[n2][n3]);
            this.fStringProducer[n2][n3].releaseString(this.fOffset[n2][n3], this.fLength[n2][n3]);
            this.fString[n2][n3] = string;
            this.fStringProducer[n2][n3] = null;
        }
        return this.addSymbol(string);
    }

    public int addSymbol(String string) {
        int n;
        int n2;
        int n3;
        int n4 = string.length();
        int n5 = StringHasher.hashString(string, n4);
        int n6 = n5 % 128;
        int[] nArray = this.fSymbolTable[n6];
        if (nArray != null) {
            n3 = 1;
            n2 = 0;
            while (n2 < nArray[0]) {
                int n7;
                if (nArray[n3] == n5 && n4 == this.fLength[n = nArray[n3 + 1]][n7 = nArray[n3 + 2]]) {
                    int n8 = this.fCharsOffset[n][n7];
                    boolean bl = true;
                    char[] cArray = this.fSymbolCache.getSymbolChars();
                    int n9 = 0;
                    while (n9 < n4) {
                        if (cArray[n8++] != string.charAt(n9)) {
                            bl = false;
                            break;
                        }
                        ++n9;
                    }
                    if (bl) {
                        return (n << 13) + n7;
                    }
                }
                n3 += 3;
                ++n2;
            }
        }
        if (this.fStringFreeList != -1) {
            n = this.fStringFreeList;
            n3 = n >> 13;
            n2 = n & 0x1FFF;
            this.fStringFreeList = this.fOffset[n3][n2];
        } else {
            n = this.fStringCount++;
            n3 = n >> 13;
            n2 = n & 0x1FFF;
            this.ensureCapacity(n3, n2);
        }
        this.fString[n3][n2] = string;
        this.fStringProducer[n3][n2] = null;
        this.fOffset[n3][n2] = -1;
        this.fLength[n3][n2] = n4;
        this.fDeclaration[n3][n2] = -1;
        this.fCharsOffset[n3][n2] = this.fSymbolCache.addSymbolToCache(string, n4, n);
        this.hashSymbol(nArray, n5, n3, n2);
        return n;
    }

    public int addSymbol(StringProducer stringProducer, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = n3 % 128;
        int[] nArray = this.fSymbolTable[n7];
        if (nArray != null) {
            n6 = 1;
            n5 = 0;
            while (n5 < nArray[0]) {
                if (nArray[n6] == n3) {
                    n4 = nArray[n6 + 1];
                    int n8 = nArray[n6 + 2];
                    char[] cArray = this.fSymbolCache.getSymbolChars();
                    if (stringProducer.equalsString(n, n2, cArray, this.fCharsOffset[n4][n8], this.fLength[n4][n8])) {
                        stringProducer.releaseString(n, n2);
                        return (n4 << 13) + n8;
                    }
                }
                n6 += 3;
                ++n5;
            }
        }
        if (this.fStringFreeList != -1) {
            n4 = this.fStringFreeList;
            n6 = n4 >> 13;
            n5 = n4 & 0x1FFF;
            this.fStringFreeList = this.fOffset[n6][n5];
        } else {
            n4 = this.fStringCount++;
            n6 = n4 >> 13;
            n5 = n4 & 0x1FFF;
            this.ensureCapacity(n6, n5);
        }
        String string = stringProducer.toString(n, n2);
        stringProducer.releaseString(n, n2);
        int n9 = string.length();
        this.fString[n6][n5] = string;
        this.fStringProducer[n6][n5] = null;
        this.fOffset[n6][n5] = -1;
        this.fLength[n6][n5] = n9;
        this.fDeclaration[n6][n5] = -1;
        this.fCharsOffset[n6][n5] = this.fSymbolCache.addSymbolToCache(string, n9, n4);
        this.hashSymbol(nArray, n3, n6, n5);
        return n4;
    }

    public CharArrayRange createCharArrayRange() {
        return new CharArrayRange();
    }

    public int createNonMatchingSymbol(int n, int n2, int[] nArray, int n3) throws Exception {
        int n4;
        int n5;
        int n6;
        if (this.fStringFreeList != -1) {
            n6 = this.fStringFreeList;
            n5 = n6 >> 13;
            n4 = n6 & 0x1FFF;
            this.fStringFreeList = this.fOffset[n5][n4];
        } else {
            n6 = this.fStringCount++;
            n5 = n6 >> 13;
            n4 = n6 & 0x1FFF;
            this.ensureCapacity(n5, n4);
        }
        String string = this.fSymbolCache.createSymbol(n6, n, n2, nArray, n3);
        int n7 = string.length();
        this.fString[n5][n4] = string;
        this.fStringProducer[n5][n4] = null;
        this.fOffset[n5][n4] = -1;
        this.fLength[n5][n4] = n7;
        this.fCharsOffset[n5][n4] = n;
        this.fDeclaration[n5][n4] = -1;
        int n8 = StringHasher.hashString(string, n7);
        int n9 = n8 % 128;
        int[] nArray2 = this.fSymbolTable[n9];
        this.hashSymbol(nArray2, n8, n5, n4);
        return n6;
    }

    private boolean ensureCapacity(int n, int n2) {
        block4: {
            try {
                return this.fOffset[n][n2] == 0;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (n2 == 0) {
                    String[][] stringArray = new String[n * 2][];
                    System.arraycopy(this.fString, 0, stringArray, 0, n);
                    this.fString = stringArray;
                    StringProducer[][] stringProducerArray = new StringProducer[n * 2][];
                    System.arraycopy(this.fStringProducer, 0, stringProducerArray, 0, n);
                    this.fStringProducer = stringProducerArray;
                    int[][] nArray = new int[n * 2][];
                    System.arraycopy(this.fOffset, 0, nArray, 0, n);
                    this.fOffset = nArray;
                    nArray = new int[n * 2][];
                    System.arraycopy(this.fLength, 0, nArray, 0, n);
                    this.fLength = nArray;
                    nArray = new int[n * 2][];
                    System.arraycopy(this.fCharsOffset, 0, nArray, 0, n);
                    this.fCharsOffset = nArray;
                    nArray = new int[n * 2][];
                    System.arraycopy(this.fDeclaration, 0, nArray, 0, n);
                    this.fDeclaration = nArray;
                    break block4;
                }
                String[] stringArray = new String[n2 * 2];
                System.arraycopy(this.fString[n], 0, stringArray, 0, n2);
                this.fString[n] = stringArray;
                StringProducer[] stringProducerArray = new StringProducer[n2 * 2];
                System.arraycopy(this.fStringProducer[n], 0, stringProducerArray, 0, n2);
                this.fStringProducer[n] = stringProducerArray;
                int[] nArray = new int[n2 * 2];
                System.arraycopy(this.fOffset[n], 0, nArray, 0, n2);
                this.fOffset[n] = nArray;
                nArray = new int[n2 * 2];
                System.arraycopy(this.fLength[n], 0, nArray, 0, n2);
                this.fLength[n] = nArray;
                nArray = new int[n2 * 2];
                System.arraycopy(this.fCharsOffset[n], 0, nArray, 0, n2);
                this.fCharsOffset[n] = nArray;
                nArray = new int[n2 * 2];
                System.arraycopy(this.fDeclaration[n], 0, nArray, 0, n2);
                this.fDeclaration[n] = nArray;
                return true;
            }
            catch (NullPointerException nullPointerException) {}
        }
        this.fString[n] = new String[256];
        this.fStringProducer[n] = new StringProducer[256];
        this.fOffset[n] = new int[256];
        this.fLength[n] = new int[256];
        this.fCharsOffset[n] = new int[256];
        this.fDeclaration[n] = new int[256];
        return true;
    }

    private boolean ensureListCapacity(int n, int n2) {
        block4: {
            try {
                return this.fStringList[n][n2] == 0;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (n2 == 0) {
                    int[][] nArray = new int[n * 2][];
                    System.arraycopy(this.fStringList, 0, nArray, 0, n);
                    this.fStringList = nArray;
                    break block4;
                }
                int[] nArray = new int[n2 * 2];
                System.arraycopy(this.fStringList[n], 0, nArray, 0, n2);
                this.fStringList[n] = nArray;
                return true;
            }
            catch (NullPointerException nullPointerException) {}
        }
        this.fStringList[n] = new int[256];
        return true;
    }

    private boolean ensureQNameCapacity(int n, int n2) {
        block4: {
            try {
                return this.fFullName[n][n2] == 0;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (n2 == 0) {
                    int[][] nArray = new int[n * 2][];
                    System.arraycopy(this.fFullName, 0, nArray, 0, n);
                    this.fFullName = nArray;
                    nArray = new int[n * 2][];
                    System.arraycopy(this.fPrefix, 0, nArray, 0, n);
                    this.fPrefix = nArray;
                    nArray = new int[n * 2][];
                    System.arraycopy(this.fLocalPart, 0, nArray, 0, n);
                    this.fLocalPart = nArray;
                    nArray = new int[n * 2][];
                    System.arraycopy(this.fURI, 0, nArray, 0, n);
                    this.fURI = nArray;
                    break block4;
                }
                int[] nArray = new int[n2 * 2];
                System.arraycopy(this.fFullName[n], 0, nArray, 0, n2);
                this.fFullName[n] = nArray;
                nArray = new int[n2 * 2];
                System.arraycopy(this.fPrefix[n], 0, nArray, 0, n2);
                this.fPrefix[n] = nArray;
                nArray = new int[n2 * 2];
                System.arraycopy(this.fLocalPart[n], 0, nArray, 0, n2);
                this.fLocalPart[n] = nArray;
                nArray = new int[n2 * 2];
                System.arraycopy(this.fURI[n], 0, nArray, 0, n2);
                this.fURI[n] = nArray;
                return true;
            }
            catch (NullPointerException nullPointerException) {}
        }
        this.fFullName[n] = new int[256];
        this.fPrefix[n] = new int[256];
        this.fLocalPart[n] = new int[256];
        this.fURI[n] = new int[256];
        return true;
    }

    public boolean equalNames(int n, int n2) {
        int n3;
        int n4;
        boolean bl;
        if (n == n2) {
            return true;
        }
        boolean bl2 = bl = (n & 0x60000000) == 0x40000000;
        if (!bl && (n2 & 0x60000000) != 0x40000000) {
            return false;
        }
        if (bl && (n2 & 0x60000000) == 0x40000000) {
            return this.equalQNames(n, n2);
        }
        int n5 = n;
        if (!bl) {
            n5 = n2;
            n2 = n;
        }
        return this.fFullName[n4 = (n5 &= 0xBFFFFFFF) >> 13][n3 = n5 & 0x1FFF] == n2;
    }

    public boolean equalQNames(int n, int n2) {
        if ((n & 0x60000000) != 0x40000000 || (n2 & 0x60000000) != 0x40000000) {
            return false;
        }
        int n3 = n & 0xBFFFFFFF;
        int n4 = n3 >> 13;
        int n5 = n3 & 0x1FFF;
        int n6 = (n3 = n2 & 0xBFFFFFFF) >> 13;
        int n7 = n3 & 0x1FFF;
        return this.fFullName[n4][n5] == this.fFullName[n6][n7];
    }

    public void finishStringList(int n) {
        if (n != this.fActiveStringList) {
            return;
        }
        int n2 = this.fStringListCount >> 13;
        int n3 = this.fStringListCount & 0x1FFF;
        this.ensureListCapacity(n2, n3);
        this.fStringList[n2][n3] = -1;
        this.fActiveStringList = -1;
        ++this.fStringListCount;
    }

    public void getCharArrayRange(int n, CharArrayRange charArrayRange) {
        if ((n & 0x60000000) == 0x40000000) {
            int n2 = n & 0xBFFFFFFF;
            if (n2 < 0 || n2 >= this.fQNameCount) {
                charArrayRange.chars = null;
                charArrayRange.offset = -1;
                charArrayRange.length = -1;
                return;
            }
            int n3 = n2 >> 13;
            int n4 = n2 & 0x1FFF;
            this.getCharArrayRange(this.fFullName[n3][n4], charArrayRange);
            return;
        }
        if (n < 0 || n >= this.fStringCount) {
            charArrayRange.chars = null;
            charArrayRange.offset = -1;
            charArrayRange.length = -1;
            return;
        }
        int n5 = n >> 13;
        int n6 = n & 0x1FFF;
        charArrayRange.chars = this.fSymbolCache.getSymbolChars();
        charArrayRange.offset = this.fCharsOffset[n5][n6];
        charArrayRange.length = this.fLength[n5][n6];
    }

    public int getDeclaration(int n) {
        if ((n & 0x60000000) == 0x40000000) {
            int n2 = n & 0xBFFFFFFF;
            if (n2 < 0 || n2 >= this.fQNameCount) {
                return -1;
            }
            int n3 = n2 >> 13;
            int n4 = n2 & 0x1FFF;
            return this.getDeclaration(this.fFullName[n3][n4]);
        }
        if (n < 0 || n >= this.fStringCount) {
            return -1;
        }
        int n5 = n >> 13;
        int n6 = n & 0x1FFF;
        return this.fDeclaration[n5][n6];
    }

    public int getFullNameForQName(int n) {
        if ((n & 0x60000000) != 0x40000000) {
            return n;
        }
        int n2 = n & 0xBFFFFFFF;
        if (n2 < 0 || n2 >= this.fQNameCount) {
            return -1;
        }
        int n3 = n2 >> 13;
        int n4 = n2 & 0x1FFF;
        return this.fFullName[n3][n4];
    }

    public int getLocalPartForQName(int n) {
        if ((n & 0x60000000) != 0x40000000) {
            return n;
        }
        int n2 = n & 0xBFFFFFFF;
        if (n2 < 0 || n2 >= this.fQNameCount) {
            return -1;
        }
        int n3 = n2 >> 13;
        int n4 = n2 & 0x1FFF;
        return this.fLocalPart[n3][n4];
    }

    public int getPrefixForQName(int n) {
        if ((n & 0x60000000) != 0x40000000) {
            return -1;
        }
        int n2 = n & 0xBFFFFFFF;
        if (n2 < 0 || n2 >= this.fQNameCount) {
            return -1;
        }
        int n3 = n2 >> 13;
        int n4 = n2 & 0x1FFF;
        return this.fPrefix[n3][n4];
    }

    public SymbolCache getSymbolCache() {
        return this.fSymbolCache;
    }

    public int getURIForQName(int n) {
        if ((n & 0x60000000) != 0x40000000) {
            return -1;
        }
        int n2 = n & 0xBFFFFFFF;
        if (n2 < 0 || n2 >= this.fQNameCount) {
            return -1;
        }
        int n3 = n2 >> 13;
        int n4 = n2 & 0x1FFF;
        return this.fURI[n3][n4];
    }

    private void hashSymbol(int[] nArray, int n, int n2, int n3) {
        if (nArray == null) {
            nArray = new int[13];
            nArray[0] = 1;
            nArray[1] = n;
            nArray[2] = n2;
            nArray[3] = n3;
            int n4 = n % 128;
            this.fSymbolTable[n4] = nArray;
        } else {
            int n5 = nArray[0];
            int n6 = 1 + n5 * 3;
            if (n6 == nArray.length) {
                int n7 = n5 + 4;
                int[] nArray2 = new int[1 + n7 * 3];
                System.arraycopy(nArray, 0, nArray2, 0, n6);
                nArray = nArray2;
                int n8 = n % 128;
                this.fSymbolTable[n8] = nArray;
            }
            nArray[n6++] = n;
            nArray[n6++] = n2;
            nArray[n6++] = n3;
            nArray[0] = ++n5;
        }
    }

    public int lookupSymbol(StringProducer stringProducer, int n, int n2, int n3) {
        int n4 = n3 % 128;
        int[] nArray = this.fSymbolTable[n4];
        if (nArray != null) {
            int n5 = 1;
            int n6 = 0;
            while (n6 < nArray[0]) {
                if (nArray[n5] == n3) {
                    int n7 = nArray[n5 + 1];
                    int n8 = nArray[n5 + 2];
                    char[] cArray = this.fSymbolCache.getSymbolChars();
                    if (stringProducer.equalsString(n, n2, cArray, this.fCharsOffset[n7][n8], this.fLength[n7][n8])) {
                        return (n7 << 13) + n8;
                    }
                }
                n5 += 3;
                ++n6;
            }
        }
        return -1;
    }

    public String orphanString(int n) {
        if ((n & 0x60000000) == 0x40000000) {
            int n2 = n & 0xBFFFFFFF;
            if (n2 < 0 || n2 >= this.fQNameCount) {
                return null;
            }
            int n3 = n2 >> 13;
            int n4 = n2 & 0x1FFF;
            return this.toString(this.fFullName[n3][n4]);
        }
        if (n < 0 || n >= this.fStringCount) {
            return null;
        }
        int n5 = n >> 13;
        int n6 = n & 0x1FFF;
        String string = this.fString[n5][n6];
        if (string == null) {
            string = this.fStringProducer[n5][n6].toString(this.fOffset[n5][n6], this.fLength[n5][n6]);
            this.fStringProducer[n5][n6].releaseString(this.fOffset[n5][n6], this.fLength[n5][n6]);
            this.releaseStringInternal(n5, n6);
        } else if (this.fOffset[n5][n6] != -1) {
            this.releaseStringInternal(n5, n6);
        }
        return string;
    }

    public void releaseString(int n) {
        if ((n & 0x60000000) == 0x40000000) {
            return;
        }
        if (n < 0 || n >= this.fStringCount) {
            return;
        }
        int n2 = n >> 13;
        int n3 = n & 0x1FFF;
        if (this.fOffset[n2][n3] != -1) {
            if (this.fStringProducer[n2][n3] != null) {
                this.fStringProducer[n2][n3].releaseString(this.fOffset[n2][n3], this.fLength[n2][n3]);
            }
            this.releaseStringInternal(n2, n3);
        }
    }

    private void releaseStringInternal(int n, int n2) {
        int n3;
        this.fString[n][n2] = null;
        this.fStringProducer[n][n2] = null;
        this.fLength[n][n2] = 0;
        this.fOffset[n][n2] = this.fStringFreeList;
        this.fStringFreeList = n3 = (n << 13) + n2;
    }

    public void reset() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fStringCount) {
            this.fString[n][n2] = null;
            if (this.fStringProducer[n][n2] != null) {
                this.fStringProducer[n][n2].releaseString(this.fOffset[n][n2], this.fLength[n][n2]);
            }
            this.fStringProducer[n][n2] = null;
            if (++n2 == 8192) {
                ++n;
                n2 = 0;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < 128) {
            this.fSymbolTable[n4] = null;
            ++n4;
        }
        this.fStringCount = 0;
        this.fStringFreeList = -1;
        this.fQNameCount = 0;
        this.fStringListCount = 0;
        this.fActiveStringList = -1;
        this.fSymbolCache.reset();
        this.fShuffleCount = 0;
        if (this.addSymbol("") != 0) {
            throw new RuntimeException("UTL002 cannot happen");
        }
    }

    public void resetShuffleCount() {
        this.fShuffleCount = 0;
    }

    public void setDeclaration(int n, int n2) {
        if ((n & 0x60000000) == 0x40000000) {
            int n3 = n & 0xBFFFFFFF;
            if (n3 < 0 || n3 >= this.fQNameCount) {
                return;
            }
            int n4 = n3 >> 13;
            int n5 = n3 & 0x1FFF;
            this.setDeclaration(this.fFullName[n4][n5], n2);
            return;
        }
        if (n < 0 || n >= this.fStringCount) {
            return;
        }
        int n6 = n >> 13;
        int n7 = n & 0x1FFF;
        this.fDeclaration[n6][n7] = n2;
    }

    public void setURIForQName(int n, int n2) {
        if ((n & 0x60000000) != 0x40000000) {
            return;
        }
        int n3 = n & 0xBFFFFFFF;
        if (n3 < 0 || n3 >= this.fQNameCount) {
            return;
        }
        int n4 = n3 >> 13;
        int n5 = n3 & 0x1FFF;
        this.fURI[n4][n5] = n2;
    }

    public int startStringList() {
        this.fActiveStringList = this.fStringListCount;
        return this.fStringListCount;
    }

    public boolean stringInList(int n, int n2) {
        int n3 = n >> 13;
        int n4 = n & 0x1FFF;
        while (this.fStringList[n3][n4] != n2) {
            if (this.fStringList[n3][n4] == -1) {
                return false;
            }
            if (++n4 != 8192) continue;
            ++n3;
            n4 = 0;
        }
        return true;
    }

    public String stringListAsString(int n) {
        int n2 = n >> 13;
        int n3 = n & 0x1FFF;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 40;
        while (this.fStringList[n2][n3] != -1) {
            stringBuffer.append((char)n4);
            n4 = 124;
            stringBuffer.append(this.toString(this.fStringList[n2][n3]));
            if (++n3 != 8192) continue;
            ++n2;
            n3 = 0;
        }
        if (n4 == 124) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public int stringListLength(int n) {
        int n2 = n >> 13;
        int n3 = n & 0x1FFF;
        int n4 = 0;
        while (this.fStringList[n2][n3] != -1) {
            ++n4;
            if (++n3 != 8192) continue;
            ++n2;
            n3 = 0;
        }
        return n4;
    }

    public String toString(int n) {
        String string;
        if (n >= 0 && n < this.fString[0].length && (string = this.fString[0][n]) != null) {
            return string;
        }
        if ((n & 0x60000000) == 0x40000000) {
            int n2 = n & 0xBFFFFFFF;
            if (n2 < 0 || n2 >= this.fQNameCount) {
                return null;
            }
            int n3 = n2 >> 13;
            int n4 = n2 & 0x1FFF;
            return this.toString(this.fFullName[n3][n4]);
        }
        if (n < 0 || n >= this.fStringCount) {
            return null;
        }
        int n5 = n >> 13;
        int n6 = n & 0x1FFF;
        String string2 = this.fString[n5][n6];
        if (string2 != null) {
            return string2;
        }
        string2 = this.fStringProducer[n5][n6].toString(this.fOffset[n5][n6], this.fLength[n5][n6]);
        this.fStringProducer[n5][n6].releaseString(this.fOffset[n5][n6], this.fLength[n5][n6]);
        this.fString[n5][n6] = string2;
        this.fStringProducer[n5][n6] = null;
        return string2;
    }

    public void updateCacheLine(int n, int n2, int n3) {
        if (++this.fShuffleCount > 200) {
            return;
        }
        int n4 = n >> 13;
        int n5 = n & 0x1FFF;
        int n6 = this.fCharsOffset[n4][n5];
        this.fSymbolCache.updateCacheLine(n6, n2, n3);
    }

    public static interface StringProducer {
        public boolean equalsString(int var1, int var2, char[] var3, int var4, int var5);

        public void releaseString(int var1, int var2);

        public String toString(int var1, int var2);
    }

    public class CharArrayRange {
        public char[] chars;
        public int offset;
        public int length;
    }
}

