/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.IllegalFacetException;
import org.apache.xerces.validators.datatype.IllegalFacetValueException;
import org.apache.xerces.validators.datatype.InternalDatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.UnknownFacetException;

public class DecimalValidator
implements InternalDatatypeValidator {
    BigDecimal fMaxInclusive = null;
    boolean fIsMaxInclusive = false;
    BigDecimal fMaxExclusive = null;
    boolean fIsMaxExclusive = false;
    BigDecimal fMinInclusive = null;
    boolean fIsMinInclusive = false;
    BigDecimal fMinExclusive = null;
    boolean fIsMinExclusive = false;
    BigDecimal[] fEnumValues = null;
    boolean fHasEnums = false;
    int fPrecision = 0;
    boolean fIsPrecision = false;
    int fScale = 0;
    boolean fIsScale = false;
    DecimalValidator fBaseValidator = null;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();
    private Locale fLocale = null;

    private void boundsCheck(BigDecimal bigDecimal) throws InvalidDatatypeValueException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.fIsMaxInclusive) {
            bl2 = bigDecimal.compareTo(this.fMaxInclusive) <= 0;
        } else if (this.fIsMaxExclusive) {
            bl2 = bigDecimal.compareTo(this.fMaxExclusive) < 0;
        } else {
            boolean bl3 = bl2 = !this.fIsMaxInclusive && !this.fIsMaxExclusive;
        }
        if (this.fIsMinInclusive) {
            bl = bigDecimal.compareTo(this.fMinInclusive) >= 0;
        } else if (this.fIsMinExclusive) {
            bl = bigDecimal.compareTo(this.fMinInclusive) > 0;
        } else {
            boolean bl4 = bl = !this.fIsMinInclusive && !this.fIsMinExclusive;
        }
        if (!bl || !bl2) {
            throw new InvalidDatatypeValueException(this.getErrorString(9, 0, new Object[]{bigDecimal}));
        }
    }

    boolean ensureFacetsAreConsistent(Hashtable hashtable) {
        boolean bl = true;
        Enumeration enumeration = hashtable.keys();
        while (bl && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = null;
            if (string.equals("enumeration")) continue;
            string2 = (String)hashtable.get(string);
            BigDecimal bigDecimal = null;
            try {
                bigDecimal = new BigDecimal(string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (string.equals("minInclusive") && this.fIsMinInclusive) {
                bl = this.fMinInclusive.compareTo(bigDecimal) < 0;
                continue;
            }
            if (string.equals("minExclusive") && this.fIsMinExclusive) {
                bl = this.fMinExclusive.compareTo(bigDecimal) < 0;
                continue;
            }
            if (string.equals("maxInclusive") && this.fIsMaxInclusive) {
                bl = this.fMaxInclusive.compareTo(bigDecimal) >= 0;
                continue;
            }
            if (string.equals("maxExclusive") && this.fIsMaxExclusive) {
                bl = this.fMaxExclusive.compareTo(bigDecimal) > 0;
                continue;
            }
            if (!string.equals("scale") || !this.fIsScale || !this.fIsPrecision) continue;
            boolean bl2 = bl = this.fScale <= this.fPrecision;
        }
        return bl;
    }

    private void enumCheck(BigDecimal bigDecimal) throws InvalidDatatypeValueException {
        int n = 0;
        while (n < this.fEnumValues.length) {
            if (bigDecimal == this.fEnumValues[n]) {
                return;
            }
            ++n;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(10, 0, new Object[]{bigDecimal}));
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        try {
            return this.fMessageProvider.createMessage(this.fLocale, n, n2, objectArray);
        }
        catch (Exception exception) {
            return "Illegal Errorcode " + n2;
        }
    }

    public void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = (DecimalValidator)datatypeValidator;
    }

    public void setFacets(Hashtable hashtable) throws UnknownFacetException, IllegalFacetException, IllegalFacetValueException {
        Object object;
        if (this.fBaseValidator != null && !this.fBaseValidator.ensureFacetsAreConsistent(hashtable)) {
            throw new IllegalFacetValueException(this.getErrorString(4, 0, null));
        }
        this.fHasEnums = false;
        this.fIsMaxExclusive = false;
        this.fIsMaxInclusive = false;
        this.fIsMinExclusive = false;
        this.fIsMinInclusive = false;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = null;
            if (((String)object).equals("enumeration")) continue;
            string = (String)hashtable.get(object);
            BigDecimal bigDecimal = null;
            try {
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalFacetValueException(this.getErrorString(5, 0, new Object[]{string, object}));
            }
            if (((String)object).equals("minInclusive")) {
                this.fIsMinInclusive = true;
                this.fMinInclusive = bigDecimal;
                continue;
            }
            if (((String)object).equals("minExclusive")) {
                this.fIsMinExclusive = true;
                this.fMinExclusive = bigDecimal;
                continue;
            }
            if (((String)object).equals("maxInclusive")) {
                this.fIsMaxInclusive = true;
                this.fMaxInclusive = bigDecimal;
                continue;
            }
            if (((String)object).equals("maxExclusive")) {
                this.fIsMaxExclusive = true;
                this.fMaxExclusive = bigDecimal;
                continue;
            }
            if (((String)object).equals("enumeration")) continue;
            if (((String)object).equals("precision")) {
                this.fIsPrecision = true;
                this.fPrecision = bigDecimal.intValue();
                continue;
            }
            if (((String)object).equals("scale")) {
                this.fIsScale = true;
                this.fScale = bigDecimal.intValue();
                continue;
            }
            if (((String)object).equals("length") || ((String)object).equals("minLength") || ((String)object).equals("maxLength") || ((String)object).equals("literal") || ((String)object).equals("encoding") || ((String)object).equals("period") || ((String)object).equals("pattern") || ((String)object).equals("lexicalRepresentation") || ((String)object).equals("lexical")) {
                throw new IllegalFacetException(this.getErrorString(6, 0, null));
            }
            throw new UnknownFacetException(this.getErrorString(7, 0, new Object[]{object}));
        }
        if (this.fIsScale && this.fIsPrecision && this.fScale > this.fPrecision) {
            throw new IllegalFacetException(this.getErrorString(15, 0, null));
        }
        object = (Vector)hashtable.get("enumeration");
        if (object != null) {
            this.fHasEnums = true;
            this.fEnumValues = new BigDecimal[((Vector)object).size()];
            int n = 0;
            while (n < ((Vector)object).size()) {
                try {
                    this.fEnumValues[n] = new BigDecimal((String)((Vector)object).elementAt(n));
                    this.boundsCheck(this.fEnumValues[n]);
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    throw new IllegalFacetValueException(this.getErrorString(8, 0, new Object[]{((Vector)object).elementAt(n)}));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Internal Error parsing enumerated values for decimal type");
                }
                ++n;
            }
        }
    }

    public void setFacets(int[] nArray) throws UnknownFacetException, IllegalFacetException, IllegalFacetValueException {
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public void validate(int n) throws InvalidDatatypeValueException {
    }

    public void validate(String string) throws InvalidDatatypeValueException {
        int n;
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException(this.getErrorString(3, 0, new Object[]{string}));
        }
        if (this.fIsScale && bigDecimal.scale() > this.fScale) {
            throw new InvalidDatatypeValueException(this.getErrorString(17, 0, new Object[]{string}));
        }
        if (this.fIsPrecision && (n = bigDecimal.movePointRight(bigDecimal.scale()).toString().length() - (bigDecimal.signum() < 0 ? 1 : 0)) > this.fPrecision) {
            throw new InvalidDatatypeValueException(this.getErrorString(16, 0, new Object[]{string}));
        }
        this.boundsCheck(bigDecimal);
        if (this.fHasEnums) {
            this.enumCheck(bigDecimal);
        }
    }
}

