/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.IllegalFacetException;
import org.apache.xerces.validators.datatype.IllegalFacetValueException;
import org.apache.xerces.validators.datatype.InternalDatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.TimeDurationValidator;
import org.apache.xerces.validators.datatype.UnknownFacetException;

public class TimeInstantValidator
implements InternalDatatypeValidator {
    public static final int CACHE_LIMIT = 300;
    public static final int CACHE_INITIAL_SIZE = 307;
    Calendar fMaxInclusive = null;
    boolean fIsMaxInclusive = false;
    Calendar fMaxExclusive = null;
    boolean fIsMaxExclusive = false;
    Calendar fMinInclusive = null;
    boolean fIsMinInclusive = false;
    Calendar fMinExclusive = null;
    boolean fIsMinExclusive = false;
    Calendar[] fEnumValues = null;
    boolean fHasEnums = false;
    String ovalue = null;
    Locale fLocale = null;
    Hashtable facetData = null;
    TimeDurationValidator fBaseValidator = null;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();
    private Hashtable cache = new Hashtable(307);

    private void boundsCheck(Calendar calendar) throws InvalidDatatypeValueException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.fIsMaxInclusive) {
            bl2 = calendar.before(this.fMaxInclusive) || calendar.equals(this.fMaxInclusive);
        } else if (this.fIsMaxExclusive) {
            bl2 = calendar.before(this.fMaxInclusive);
        } else {
            boolean bl3 = bl2 = !this.fIsMaxInclusive && !this.fIsMaxExclusive;
        }
        if (this.fIsMinInclusive) {
            bl = calendar.after(this.fMinInclusive) || calendar.equals(this.fMinInclusive);
        } else if (this.fIsMinExclusive) {
            bl = calendar.after(this.fMinInclusive);
        } else {
            boolean bl4 = bl = !this.fIsMinInclusive && !this.fIsMinExclusive;
        }
        if (!bl || !bl2) {
            throw new InvalidDatatypeValueException(this.getErrorString(9, 0, new Object[]{this.ovalue}));
        }
    }

    boolean ensureFacetsAreConsistent(Hashtable hashtable) {
        boolean bl = true;
        Enumeration enumeration = hashtable.keys();
        while (bl && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = null;
            if (string.equals("enumeration")) continue;
            string2 = (String)hashtable.get(string);
            Calendar calendar = null;
            try {
                calendar = TimeInstantValidator.normalizeInstant(string2.toCharArray(), 0, string2.length());
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                bl = false;
            }
            if (string.equals("minInclusive") && this.fIsMinInclusive) {
                bl = this.fMinInclusive.before(calendar) || this.fMinInclusive.equals(calendar);
                continue;
            }
            if (string.equals("minExclusive") && this.fIsMinExclusive) {
                bl = this.fMinExclusive.before(calendar);
                continue;
            }
            if (string.equals("maxInclusive") && this.fIsMaxInclusive) {
                bl = this.fMaxInclusive.after(calendar) || this.fMaxInclusive.equals(calendar);
                continue;
            }
            if (!string.equals("maxExclusive") || !this.fIsMaxExclusive) continue;
            bl = this.fMaxExclusive.after(calendar);
        }
        return bl;
    }

    private void enumCheck(Calendar calendar) throws InvalidDatatypeValueException {
        int n = 0;
        while (n < this.fEnumValues.length) {
            if (calendar.equals(this.fEnumValues[n])) {
                return;
            }
            ++n;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(10, 0, new Object[]{this.ovalue}));
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        try {
            return this.fMessageProvider.createMessage(this.fLocale, n, n2, objectArray);
        }
        catch (Exception exception) {
            return "Illegal Errorcode " + n2;
        }
    }

    public static final int indexOf(char[] cArray, int n, char c) {
        return TimeInstantValidator.indexOf(cArray, n, c, cArray.length - 1);
    }

    public static final int indexOf(char[] cArray, int n, char c, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            if (cArray[n3] == c) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static final int indexOneOf(char[] cArray, int n, String string) {
        return TimeInstantValidator.indexOneOf(cArray, n, string, cArray.length - 1);
    }

    public static final int indexOneOf(char[] cArray, int n, String string, int n2) {
        int n3 = n;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < string.length()) {
                if (cArray[n3] == string.charAt(n4)) {
                    return n3;
                }
                ++n4;
            }
            ++n3;
        }
        return -1;
    }

    public static Calendar normalizeInstant(char[] cArray, int n, int n2) throws InvalidDatatypeValueException {
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        int n7 = 0;
        int n8 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        char[] cArray2 = new char[]{'0', '0', '0'};
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n9 = n + n2 - 1;
        try {
            if (n2 < 16) {
                throw new ParseException("Value is too short.", 0);
            }
            gregorianCalendar.clear();
            gregorianCalendar.setLenient(false);
            if (cArray[n6] == '-' || cArray[n6] == '+') {
                gregorianCalendar.set(0, cArray[n6] == '-' ? 0 : 1);
                ++n6;
            }
            if ((n7 = TimeInstantValidator.indexOf(cArray, n6, '-', n6 + 5)) == -1 || n7 > n9) {
                throw new ParseException("Year separator is missing or misplaced.", n6);
            }
            gregorianCalendar.set(1, TimeInstantValidator.parseInt(cArray, n6, n7 - n6));
            n6 = n7 + 1;
            gregorianCalendar.set(2, TimeInstantValidator.parseInt(cArray, n6, 2) - 1);
            if (cArray[n6 += 2] != '-') {
                throw new ParseException("Month separator is missing or misplaced.", n6);
            }
            gregorianCalendar.set(5, TimeInstantValidator.parseInt(cArray, n6 + 1, 2));
            if (cArray[n6 += 3] != 'T') {
                throw new ParseException("Time separator is missing or misplaced.", n6);
            }
            gregorianCalendar.set(11, TimeInstantValidator.parseInt(cArray, n6 + 1, 2));
            if (cArray[n6 += 3] != ':') {
                throw new ParseException("Hour separator is missing or misplaced.", n6);
            }
            gregorianCalendar.set(12, TimeInstantValidator.parseInt(cArray, n6 + 1, 2));
            if (n9 - (n6 += 3) > 1 && cArray[n6] == ':') {
                gregorianCalendar.set(13, TimeInstantValidator.parseInt(cArray, n6 + 1, 2));
                if ((n6 += 3) < n9 && cArray[n6] == '.') {
                    ++n6;
                    n8 = 0;
                    while (n6 <= n9 && n8 < 3 && Character.isDigit(cArray[n6])) {
                        cArray2[n8++] = cArray[n6++];
                    }
                    gregorianCalendar.set(14, TimeInstantValidator.parseInt(cArray2, 0, 3));
                }
                while (n6 <= n9 && Character.isDigit(cArray[n6])) {
                    ++n6;
                }
            }
            if (n6 <= n9) {
                if (cArray[n6] == 'Z') {
                    gregorianCalendar.set(15, 0);
                } else if (cArray[n6] == '-' || cArray[n6] == '+') {
                    bl2 = cArray[n6] == '-';
                    n4 = TimeInstantValidator.parseInt(cArray, n6 + 1, 2);
                    if (n9 - n6 == 5) {
                        if (cArray[n6 + 3] != ':') {
                            throw new ParseException("time zone must be 'hh:mm'.", n6);
                        }
                        n5 = TimeInstantValidator.parseInt(cArray, n6 + 4, 2);
                    }
                    n3 = n4 * 3600000 + n5 * 60000;
                    gregorianCalendar.set(15, bl2 ? -n3 : n3);
                } else {
                    throw new ParseException("Unrecognized time zone.", n6);
                }
            }
            return gregorianCalendar;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InvalidDatatypeValueException("Unable to parse timeInstant " + exception.toString());
        }
    }

    public static final int parseInt(char[] cArray, int n, int n2) throws NumberFormatException {
        int n3;
        if (cArray == null) {
            throw new NumberFormatException("null");
        }
        int n4 = 10;
        int n5 = 0;
        boolean bl = false;
        int n6 = n;
        int n7 = 0;
        if (n2 <= 0) {
            throw new NumberFormatException(new String(cArray, n, n2));
        }
        if (cArray[n6] == '-') {
            bl = true;
            n3 = Integer.MIN_VALUE;
            ++n6;
        } else if (cArray[n6] == '+') {
            bl = false;
            n3 = -2147483647;
            ++n6;
        } else {
            n3 = -2147483647;
        }
        int n8 = n3 / n4;
        if (n6 < n + n2) {
            if ((n7 = Character.digit(cArray[n6++], n4)) < 0) {
                throw new NumberFormatException(new String(cArray, n, n2));
            }
            n5 = -n7;
        }
        while (n6 < n + n2) {
            if ((n7 = Character.digit(cArray[n6++], n4)) < 0) {
                throw new NumberFormatException(new String(cArray, n, n2));
            }
            if (n5 < n8) {
                throw new NumberFormatException(new String(cArray, n, n2));
            }
            if ((n5 *= n4) < n3 + n7) {
                throw new NumberFormatException(new String(cArray, n, n2));
            }
            n5 -= n7;
        }
        if (bl) {
            if (n6 > 1) {
                return n5;
            }
            throw new NumberFormatException(new String(cArray, n, n2));
        }
        return -n5;
    }

    public void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = (TimeDurationValidator)datatypeValidator;
    }

    public void setFacets(Hashtable hashtable) throws UnknownFacetException, IllegalFacetException, IllegalFacetValueException {
        Object object;
        if (this.fBaseValidator != null && !this.fBaseValidator.ensureFacetsAreConsistent(hashtable)) {
            throw new IllegalFacetValueException(this.getErrorString(4, 0, null));
        }
        this.fHasEnums = false;
        this.fIsMaxExclusive = false;
        this.fIsMaxInclusive = false;
        this.fIsMinExclusive = false;
        this.fIsMinInclusive = false;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = null;
            if (((String)object).equals("enumeration")) continue;
            string = (String)hashtable.get(object);
            Calendar calendar = null;
            try {
                calendar = TimeInstantValidator.normalizeInstant(string.toCharArray(), 0, string.length());
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                throw new IllegalFacetValueException(this.getErrorString(5, 0, new Object[]{string, object}));
            }
            if (((String)object).equals("minInclusive")) {
                this.fIsMinInclusive = true;
                this.fMinInclusive = calendar;
                continue;
            }
            if (((String)object).equals("minExclusive")) {
                this.fIsMinExclusive = true;
                this.fMinExclusive = calendar;
                continue;
            }
            if (((String)object).equals("maxInclusive")) {
                this.fIsMaxInclusive = true;
                this.fMaxInclusive = calendar;
                continue;
            }
            if (((String)object).equals("maxExclusive")) {
                this.fIsMaxExclusive = true;
                this.fMaxExclusive = calendar;
                continue;
            }
            if (((String)object).equals("enumeration")) continue;
            if (((String)object).equals("precision") || ((String)object).equals("scale") || ((String)object).equals("length") || ((String)object).equals("minLength") || ((String)object).equals("maxLength") || ((String)object).equals("literal") || ((String)object).equals("encoding") || ((String)object).equals("period") || ((String)object).equals("pattern") || ((String)object).equals("lexicalRepresentation") || ((String)object).equals("lexical")) {
                throw new IllegalFacetException(this.getErrorString(12, 0, null));
            }
            throw new UnknownFacetException(this.getErrorString(7, 0, new Object[]{object}));
        }
        object = (Vector)hashtable.get("enumeration");
        if (object != null) {
            this.fHasEnums = true;
            this.fEnumValues = new Calendar[((Vector)object).size()];
            int n = 0;
            while (n < ((Vector)object).size()) {
                try {
                    this.fEnumValues[n] = TimeInstantValidator.normalizeInstant(((String)((Vector)object).elementAt(n)).toCharArray(), 0, ((String)((Vector)object).elementAt(n)).length());
                    this.boundsCheck(this.fEnumValues[n]);
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    throw new IllegalFacetValueException(this.getErrorString(8, 0, new Object[]{((Vector)object).elementAt(n)}));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Internal Error parsing enumerated values for timeInstant type");
                }
                ++n;
            }
        }
    }

    public void setFacets(int[] nArray) throws UnknownFacetException, IllegalFacetException, IllegalFacetValueException {
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public void validate(int n) throws InvalidDatatypeValueException {
    }

    public void validate(String string) throws InvalidDatatypeValueException {
        this.ovalue = string;
        Calendar calendar = (Calendar)this.cache.get(string);
        if (calendar == null) {
            calendar = TimeInstantValidator.normalizeInstant(string.toCharArray(), 0, string.length());
            if (this.cache.size() < 300) {
                this.cache.put(string, calendar);
            }
        }
        this.boundsCheck(calendar);
        if (this.fHasEnums) {
            this.enumCheck(calendar);
        }
    }
}

