/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.DOMExceptionImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NodeIteratorImpl;
import org.apache.xerces.dom.RangeImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;

public abstract class NodeContainer
extends NodeImpl
implements NodeList {
    static final long serialVersionUID = 2815829867152120872L;
    protected NodeImpl firstChild;
    protected NodeImpl lastChild;
    protected transient int nodeListChanges = -1;
    protected transient int nodeListLength = -1;
    protected transient NodeImpl nodeListNode;
    protected transient int nodeListIndex;
    protected transient boolean syncChildren;
    protected static int[] kidOK = new int[13];

    static {
        NodeContainer.kidOK[9] = 1410;
        NodeContainer.kidOK[1] = 446;
        NodeContainer.kidOK[5] = 446;
        NodeContainer.kidOK[6] = 446;
        NodeContainer.kidOK[11] = 446;
        NodeContainer.kidOK[2] = 40;
        NodeContainer.kidOK[12] = 0;
        NodeContainer.kidOK[4] = 0;
        NodeContainer.kidOK[3] = 0;
        NodeContainer.kidOK[8] = 0;
        NodeContainer.kidOK[7] = 0;
        NodeContainer.kidOK[10] = 0;
    }

    public NodeContainer() {
    }

    protected NodeContainer(DocumentImpl documentImpl, String string, String string2) {
        super(documentImpl, string, string2);
    }

    public Node appendChild(Node node) throws DOMException {
        return this.insertBefore(node, null);
    }

    public Node cloneNode(boolean bl) {
        NodeContainer nodeContainer = (NodeContainer)super.cloneNode(bl);
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        nodeContainer.firstChild = null;
        nodeContainer.lastChild = null;
        if (bl) {
            NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
            while (nodeImpl != null) {
                nodeContainer.appendChild(nodeImpl.cloneNode(true));
                nodeImpl = (NodeImpl)nodeImpl.getNextSibling();
            }
        }
        return nodeContainer;
    }

    public NodeList getChildNodes() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this;
    }

    public Node getFirstChild() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.firstChild;
    }

    public Node getLastChild() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.lastChild;
    }

    public int getLength() {
        if (this.nodeListChanges != this.changes || this.nodeListLength == -1) {
            this.nodeListChanges = this.changes;
            this.nodeListLength = 0;
            this.nodeListIndex = 0;
            this.nodeListNode = this.firstChild;
            NodeImpl nodeImpl = this.firstChild;
            while (nodeImpl != null) {
                ++this.nodeListLength;
                nodeImpl = nodeImpl.nextSibling;
            }
        }
        return this.nodeListLength;
    }

    public boolean hasChildNodes() {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        return this.firstChild != null;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        return this.internalInsertBefore(node, node2, 65535);
    }

    Node internalInsertBefore(Node node, Node node2, int n) throws DOMException {
        Object object;
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "DOM001 Modification not allowed");
        }
        boolean bl = this.ownerDocument.errorChecking;
        if (bl && !(node instanceof NodeImpl) || node.getOwnerDocument() != this.ownerDocument && (this.getNodeType() != 9 || node.getOwnerDocument() != (Document)((Object)this))) {
            throw new DOMExceptionImpl(4, "DOM005 Wrong document");
        }
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        NodeImpl nodeImpl = (NodeImpl)node;
        if (bl) {
            boolean bl2 = true;
            object = this.parentNode;
            while (bl2 && object != null) {
                bl2 = nodeImpl != object;
                object = ((NodeImpl)object).parentNode;
            }
            if (!bl2) {
                throw new DOMExceptionImpl(3, "DOM006 Hierarchy request error");
            }
            if (node2 != null && node2.getParentNode() != this) {
                throw new DOMExceptionImpl(8, "DOM008 Not found");
            }
        }
        if (nodeImpl.getNodeType() == 11) {
            Node node3 = nodeImpl.getFirstChild();
            while (node3 != null) {
                if (bl && !this.ownerDocument.isKidOK(this, node3)) {
                    throw new DOMExceptionImpl(3, "DOM006 Hierarchy request error");
                }
                node3 = node3.getNextSibling();
            }
            while (nodeImpl.hasChildNodes()) {
                this.insertBefore(nodeImpl.getFirstChild(), node2);
            }
        } else {
            if (bl && !this.ownerDocument.isKidOK(this, nodeImpl)) {
                throw new DOMExceptionImpl(3, "DOM006 Hierarchy request error");
            }
            NodeImpl.EnclosingAttr enclosingAttr = null;
            if ((n & 2) != 0) {
                object = LCount.lookup("DOMAttrModified");
                if (((LCount)object).captures + ((LCount)object).bubbles + ((LCount)object).defaults > 0) {
                    enclosingAttr = this.getEnclosingAttr();
                }
            }
            if ((object = nodeImpl.getParentNode()) != null) {
                object.removeChild(nodeImpl);
            }
            NodeImpl nodeImpl2 = node2 == null ? this.lastChild : ((NodeImpl)node2).previousSibling;
            nodeImpl.parentNode = this;
            nodeImpl.previousSibling = nodeImpl2;
            if (nodeImpl2 == null) {
                this.firstChild = nodeImpl;
            } else {
                nodeImpl2.nextSibling = nodeImpl;
            }
            nodeImpl.nextSibling = (NodeImpl)node2;
            if (node2 == null) {
                this.lastChild = nodeImpl;
            } else {
                ((NodeImpl)node2).previousSibling = nodeImpl;
            }
            this.changed();
            if ((n & 1) != 0) {
                Object object2;
                LCount lCount = LCount.lookup("DOMNodeInserted");
                if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                    object2 = new MutationEventImpl();
                    object2.initMutationEvent("DOMNodeInserted", true, false, this, null, null, null);
                    nodeImpl.dispatchEvent((Event)object2);
                }
                lCount = LCount.lookup("DOMNodeInsertedIntoDocument");
                if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                    object2 = this;
                    if (enclosingAttr != null) {
                        object2 = (NodeImpl)((Object)enclosingAttr.node.getOwnerElement());
                    }
                    if (object2 != null) {
                        Object object3 = object2;
                        while (object3 != null) {
                            object2 = object3;
                            object3 = ((NodeImpl)object3).getNodeType() == 2 ? (ElementImpl)((AttrImpl)object3).getOwnerElement() : ((NodeImpl)object3).parentNode;
                        }
                        if (((NodeImpl)object2).getNodeType() == 9) {
                            MutationEventImpl mutationEventImpl = new MutationEventImpl();
                            mutationEventImpl.initMutationEvent("DOMNodeInsertedIntoDocument", false, false, null, null, null, null);
                            this.dispatchEventToSubtree(nodeImpl, mutationEventImpl);
                        }
                    }
                }
            }
            if ((n & 2) != 0) {
                this.dispatchAggregateEvents(enclosingAttr);
            }
        }
        return nodeImpl;
    }

    Node internalRemoveChild(Node node, int n) throws DOMException {
        NodeImpl nodeImpl;
        Object object;
        Enumeration enumeration;
        if (this.readOnly) {
            throw new DOMExceptionImpl(7, "DOM001 Modification not allowed");
        }
        if (this.ownerDocument.errorChecking && node != null && node.getParentNode() != this) {
            throw new DOMExceptionImpl(8, "DOM008 Not found");
        }
        Enumeration enumeration2 = this.ownerDocument.getNodeIterators();
        if (enumeration2 != null) {
            while (enumeration2.hasMoreElements()) {
                ((NodeIteratorImpl)enumeration2.nextElement()).removeNode(node);
            }
        }
        if ((enumeration = this.ownerDocument.getRanges()) != null) {
            while (enumeration.hasMoreElements()) {
                ((RangeImpl)enumeration.nextElement()).removeNode(node);
            }
        }
        NodeImpl nodeImpl2 = (NodeImpl)node;
        NodeImpl.EnclosingAttr enclosingAttr = null;
        LCount lCount = LCount.lookup("DOMAttrModified");
        if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
            enclosingAttr = this.getEnclosingAttr();
        }
        if ((n & 1) != 0) {
            lCount = LCount.lookup("DOMNodeRemoved");
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                object = new MutationEventImpl();
                object.initMutationEvent("DOMNodeRemoved", true, false, this, null, null, null);
                nodeImpl2.dispatchEvent((Event)object);
            }
            lCount = LCount.lookup("DOMNodeRemovedFromDocument");
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                object = this;
                if (enclosingAttr != null) {
                    object = (NodeImpl)((Object)enclosingAttr.node.getOwnerElement());
                }
                if (object != null) {
                    nodeImpl = ((NodeImpl)object).parentNode;
                    while (nodeImpl != null) {
                        object = nodeImpl;
                        nodeImpl = nodeImpl.parentNode;
                    }
                    if (((NodeImpl)object).getNodeType() == 9) {
                        MutationEventImpl mutationEventImpl = new MutationEventImpl();
                        mutationEventImpl.initMutationEvent("DOMNodeRemovedFromDocument", false, false, null, null, null, null);
                        this.dispatchEventToSubtree(nodeImpl2, mutationEventImpl);
                    }
                }
            }
        }
        object = nodeImpl2.previousSibling;
        nodeImpl = nodeImpl2.nextSibling;
        if (object != null) {
            ((NodeImpl)object).nextSibling = nodeImpl;
        } else {
            this.firstChild = nodeImpl;
        }
        if (nodeImpl != null) {
            nodeImpl.previousSibling = object;
        } else {
            this.lastChild = object;
        }
        nodeImpl2.parentNode = null;
        nodeImpl2.nextSibling = null;
        nodeImpl2.previousSibling = null;
        this.changed();
        if ((n & 2) != 0) {
            this.dispatchAggregateEvents(enclosingAttr);
        }
        return nodeImpl2;
    }

    public Node item(int n) {
        if (this.nodeListChanges == this.changes) {
            if (this.nodeListIndex < n) {
                while (this.nodeListIndex < n && this.nodeListNode != null) {
                    ++this.nodeListIndex;
                    this.nodeListNode = this.nodeListNode.nextSibling;
                }
            } else if (this.nodeListIndex > n) {
                while (this.nodeListIndex > n && this.nodeListNode != null) {
                    --this.nodeListIndex;
                    this.nodeListNode = this.nodeListNode.previousSibling;
                }
            }
            return this.nodeListNode;
        }
        this.nodeListChanges = this.changes;
        this.nodeListNode = this.firstChild;
        this.nodeListIndex = 0;
        while (this.nodeListIndex < n && this.nodeListNode != null) {
            this.nodeListNode = this.nodeListNode.nextSibling;
            ++this.nodeListIndex;
        }
        return this.nodeListNode;
    }

    public void normalize() {
        Node node = this.getFirstChild();
        while (node != null) {
            node.normalize();
            node = node.getNextSibling();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.nodeListChanges = -1;
    }

    public Node removeChild(Node node) throws DOMException {
        return this.internalRemoveChild(node, 65535);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        NodeImpl.EnclosingAttr enclosingAttr = null;
        LCount lCount = LCount.lookup("DOMAttrModified");
        if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
            enclosingAttr = this.getEnclosingAttr();
        }
        this.internalInsertBefore(node, node2, 1);
        this.internalRemoveChild(node2, 1);
        this.dispatchAggregateEvents(enclosingAttr);
        return node2;
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        super.setReadOnly(bl, bl2);
        if (bl2) {
            if (this.syncChildren) {
                this.synchronizeChildren();
            }
            NodeImpl nodeImpl = this.firstChild;
            while (nodeImpl != null) {
                if (!(nodeImpl instanceof EntityReference)) {
                    nodeImpl.setReadOnly(bl, true);
                }
                nodeImpl = nodeImpl.nextSibling;
            }
        }
    }

    protected void synchronizeChildren() {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.syncChildren) {
            this.synchronizeChildren();
        }
        objectOutputStream.defaultWriteObject();
    }
}

