/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.IllegalFacetException;
import org.apache.xerces.validators.datatype.IllegalFacetValueException;
import org.apache.xerces.validators.datatype.InternalDatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.TimeInstantValidator;
import org.apache.xerces.validators.datatype.UnknownFacetException;

public class TimeDurationValidator
implements InternalDatatypeValidator {
    public static final int CACHE_LIMIT = 300;
    public static final int CACHE_INITIAL_SIZE = 307;
    long fMaxInclusive = 0L;
    boolean fIsMaxInclusive = false;
    long fMaxExclusive = 0L;
    boolean fIsMaxExclusive = false;
    long fMinInclusive = 0L;
    boolean fIsMinInclusive = false;
    long fMinExclusive = 0L;
    boolean fIsMinExclusive = false;
    long[] fEnumValues = null;
    boolean fHasEnums = false;
    String ovalue = null;
    Locale fLocale = null;
    Hashtable facetData = null;
    TimeDurationValidator fBaseValidator = null;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();
    private Hashtable cache = new Hashtable(307);

    private void boundsCheck(long l) throws InvalidDatatypeValueException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.fIsMaxInclusive) {
            bl2 = l <= this.fMaxInclusive;
        } else if (this.fIsMaxExclusive) {
            bl2 = l < this.fMaxExclusive;
        } else {
            boolean bl3 = bl2 = !this.fIsMaxInclusive && !this.fIsMaxExclusive;
        }
        if (this.fIsMinInclusive) {
            bl = l >= this.fMinInclusive;
        } else if (this.fIsMinExclusive) {
            bl = l > this.fMinInclusive;
        } else {
            boolean bl4 = bl = !this.fIsMinInclusive && !this.fIsMinExclusive;
        }
        if (!bl || !bl2) {
            throw new InvalidDatatypeValueException(this.getErrorString(9, 0, new Object[]{this.ovalue}));
        }
    }

    boolean ensureFacetsAreConsistent(Hashtable hashtable) {
        boolean bl = true;
        Enumeration enumeration = hashtable.keys();
        while (bl && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = null;
            if (string.equals("enumeration")) continue;
            string2 = (String)hashtable.get(string);
            long l = 0L;
            try {
                l = TimeDurationValidator.normalizeDuration(string2.toCharArray(), 0, string2.length());
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                bl = false;
            }
            if (string.equals("minInclusive") && this.fIsMinInclusive) {
                bl = this.fMinInclusive <= l;
                continue;
            }
            if (string.equals("minExclusive") && this.fIsMinExclusive) {
                bl = this.fMinExclusive < l;
                continue;
            }
            if (string.equals("maxInclusive") && this.fIsMaxInclusive) {
                bl = this.fMaxInclusive >= l;
                continue;
            }
            if (!string.equals("maxExclusive") || !this.fIsMaxExclusive) continue;
            boolean bl2 = bl = this.fMaxExclusive > l;
        }
        return bl;
    }

    private void enumCheck(long l) throws InvalidDatatypeValueException {
        int n = 0;
        while (n < this.fEnumValues.length) {
            if (l == this.fEnumValues[n]) {
                return;
            }
            ++n;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(10, 0, new Object[]{this.ovalue}));
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        try {
            return this.fMessageProvider.createMessage(this.fLocale, n, n2, objectArray);
        }
        catch (Exception exception) {
            return "Illegal Errorcode " + n2;
        }
    }

    public static long normalizeDuration(char[] cArray, int n, int n2) throws InvalidDatatypeValueException {
        int n3;
        int n4;
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n7 = 0;
        int n8 = n;
        int n9 = 0;
        int n10 = n4 = n + n2 - 1;
        char[] cArray2 = new char[]{'Y', 'M', 'D'};
        char[] cArray3 = new char[]{'H', 'M', 'S'};
        char[] cArray4 = new char[]{'0', '0', '0'};
        int[] nArray = new int[17];
        n5 = 0;
        while (n5 < nArray.length) {
            nArray[n5] = 0;
            ++n5;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        Calendar calendar = null;
        Calendar calendar2 = null;
        try {
            if (cArray[n8] == '-') {
                bl6 = true;
            }
            if ((n3 = TimeInstantValidator.indexOf(cArray, n, '/')) > -1 && n3 < n4) {
                if (cArray[n3 + 1] == '-') {
                    bl7 = true;
                }
                if (cArray[bl6 ? n8 + 1 : n8] == 'P') {
                    if (bl6) {
                        ++n8;
                    }
                    bl8 = true;
                    n10 = n3 - 1;
                } else {
                    calendar = (GregorianCalendar)TimeInstantValidator.normalizeInstant(cArray, n8, n3 - n8);
                }
                if (cArray[bl7 ? n3 + 2 : n3 + 1] == 'P') {
                    bl9 = true;
                    n8 = bl7 ? n3 + 2 : n3 + 1;
                } else {
                    calendar2 = (GregorianCalendar)TimeInstantValidator.normalizeInstant(cArray, ++n3, n4 - n3 + 1);
                }
            } else {
                int n11 = n8 = bl6 ? n + 1 : n;
            }
            if (calendar != null && calendar2 != null) {
                return calendar2.getTime().getTime() - calendar.getTime().getTime();
            }
            if (bl8 && bl9) {
                throw new ParseException("Period cannot be expressed as 2 durations.", 0);
            }
            if (bl8 && cArray[n8] != 'P') {
                throw new ParseException("Invalid start character for timeDuration:" + cArray[n8], n8);
            }
            if (bl9 && cArray[n8] != 'P') {
                throw new ParseException("Invalid start character for timeDuration:" + cArray[n8], n8);
            }
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException(exception.toString());
        }
        try {
            n9 = n8 + 1;
            n5 = n8 + 1;
            while (n5 <= n10) {
                if (Character.isDigit(cArray[n5]) || cArray[n5] == '.') {
                    if (cArray[n5] == '.') {
                        bl5 = true;
                    }
                } else if (cArray[n5] == 'T') {
                    bl4 = true;
                    n7 = 0;
                    n9 = n5 + 1;
                } else {
                    n7 = TimeInstantValidator.indexOf(bl4 ? cArray3 : cArray2, n7, cArray[n5]);
                    if (n7 == -1) {
                        throw new ParseException("Illegal or misplaced separator.", n5);
                    }
                    ++n7;
                    if (bl5 && cArray[n5] != 'S') {
                        throw new ParseException("Fractional digits allowed only for 'seconds'.", n5);
                    }
                    bl = false;
                    switch (cArray[n5]) {
                        case 'Y': {
                            if (bl4) {
                                throw new ParseException("Year must be specified before 'T' separator.", n5);
                            }
                            nArray[1] = TimeInstantValidator.parseInt(cArray, n9, n5 - n9);
                            break;
                        }
                        case 'D': {
                            if (bl4) {
                                throw new ParseException("Days must be specified before 'T' separator.", n5);
                            }
                            nArray[5] = TimeInstantValidator.parseInt(cArray, n9, n5 - n9);
                            break;
                        }
                        case 'H': {
                            if (!bl4) {
                                throw new ParseException("Hours must be specified after 'T' separator.", n5);
                            }
                            nArray[11] = TimeInstantValidator.parseInt(cArray, n9, n5 - n9);
                            break;
                        }
                        case 'M': {
                            nArray[bl4 ? 12 : 2] = TimeInstantValidator.parseInt(cArray, n9, n5 - n9);
                            break;
                        }
                        case 'S': {
                            if (!bl4) {
                                throw new ParseException("Seconds must be specified after 'T' separator.", n5);
                            }
                            if (!bl5) {
                                nArray[13] = TimeInstantValidator.parseInt(cArray, n9, n5 - n9);
                                break;
                            }
                            n3 = TimeInstantValidator.indexOf(cArray, n9, '.');
                            nArray[13] = TimeInstantValidator.parseInt(cArray, n9, n3 - n9);
                            ++n3;
                            n6 = 0;
                            while (n3 <= n10 && n6 < 3 && Character.isDigit(cArray[n3])) {
                                cArray4[n6++] = cArray[n3++];
                            }
                            nArray[14] = TimeInstantValidator.parseInt(cArray4, 0, 3);
                            bl5 = false;
                            break;
                        }
                        default: {
                            throw new ParseException("Illegal 'picture' character: " + cArray[n5], n5);
                        }
                    }
                    n9 = n5 + 1;
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException(exception.toString());
        }
        try {
            if (calendar != null) {
                long l = calendar.getTime().getTime();
                n6 = 0;
                while (n6 < nArray.length) {
                    if (nArray[n6] != 0) {
                        ((GregorianCalendar)calendar).add(n6, bl7 ? -nArray[n6] : nArray[n6]);
                    }
                    ++n6;
                }
                long l2 = calendar.getTime().getTime();
                return l2 - l;
            }
            if (calendar2 != null) {
                long l = calendar2.getTime().getTime();
                n6 = 0;
                while (n6 < nArray.length) {
                    if (nArray[n6] > 0) {
                        ((GregorianCalendar)calendar2).add(n6, bl6 ? nArray[n6] : -nArray[n6]);
                    }
                    ++n6;
                }
                long l3 = calendar2.getTime().getTime();
                return l3 - l;
            }
            long l = ((long)nArray[1] * 31104000L + (long)nArray[2] * 2592000L + (long)nArray[5] * 86400L + (long)nArray[11] * 3600L + (long)nArray[12] * 60L + (long)nArray[13]) * 1000L + (long)nArray[14];
            return bl6 ? -l : l;
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException(exception.toString());
        }
    }

    public void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = (TimeDurationValidator)datatypeValidator;
    }

    public void setFacets(Hashtable hashtable) throws UnknownFacetException, IllegalFacetException, IllegalFacetValueException {
        Object object;
        if (this.fBaseValidator != null && !this.fBaseValidator.ensureFacetsAreConsistent(hashtable)) {
            throw new IllegalFacetValueException(this.getErrorString(4, 0, null));
        }
        this.fHasEnums = false;
        this.fIsMaxExclusive = false;
        this.fIsMaxInclusive = false;
        this.fIsMinExclusive = false;
        this.fIsMinInclusive = false;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = null;
            if (((String)object).equals("enumeration")) continue;
            string = (String)hashtable.get(object);
            long l = 0L;
            try {
                l = TimeDurationValidator.normalizeDuration(string.toCharArray(), 0, string.length());
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                throw new IllegalFacetValueException(this.getErrorString(5, 0, new Object[]{string, object}));
            }
            if (((String)object).equals("minInclusive")) {
                this.fIsMinInclusive = true;
                this.fMinInclusive = l;
                continue;
            }
            if (((String)object).equals("minExclusive")) {
                this.fIsMinExclusive = true;
                this.fMinExclusive = l;
                continue;
            }
            if (((String)object).equals("maxInclusive")) {
                this.fIsMaxInclusive = true;
                this.fMaxInclusive = l;
                continue;
            }
            if (((String)object).equals("maxExclusive")) {
                this.fIsMaxExclusive = true;
                this.fMaxExclusive = l;
                continue;
            }
            if (((String)object).equals("enumeration")) continue;
            if (((String)object).equals("precision") || ((String)object).equals("scale") || ((String)object).equals("length") || ((String)object).equals("minLength") || ((String)object).equals("maxLength") || ((String)object).equals("literal") || ((String)object).equals("encoding") || ((String)object).equals("period") || ((String)object).equals("pattern") || ((String)object).equals("lexicalRepresentation") || ((String)object).equals("lexical")) {
                throw new IllegalFacetException(this.getErrorString(12, 0, null));
            }
            throw new UnknownFacetException(this.getErrorString(7, 0, new Object[]{object}));
        }
        object = (Vector)hashtable.get("enumeration");
        if (object != null) {
            this.fHasEnums = true;
            this.fEnumValues = new long[((Vector)object).size()];
            int n = 0;
            while (n < ((Vector)object).size()) {
                try {
                    this.fEnumValues[n] = TimeDurationValidator.normalizeDuration(((String)((Vector)object).elementAt(n)).toCharArray(), 0, ((String)((Vector)object).elementAt(n)).length());
                    this.boundsCheck(this.fEnumValues[n]);
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    throw new IllegalFacetValueException(this.getErrorString(8, 0, new Object[]{((Vector)object).elementAt(n)}));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Internal Error parsing enumerated values for timeDuration type");
                }
                ++n;
            }
        }
    }

    public void setFacets(int[] nArray) throws UnknownFacetException, IllegalFacetException, IllegalFacetValueException {
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public void validate(int n) throws InvalidDatatypeValueException {
    }

    public void validate(String string) throws InvalidDatatypeValueException {
        this.ovalue = string;
        Long l = (Long)this.cache.get(string);
        if (l == null) {
            l = new Long(TimeDurationValidator.normalizeDuration(string.toCharArray(), 0, string.length()));
            if (this.cache.size() < 300) {
                this.cache.put(string, l);
            }
        }
        this.boundsCheck(l);
        if (this.fHasEnums) {
            this.enumCheck(l);
        }
    }
}

