/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;

public final class XMLSerializer
extends BaseMarkupSerializer {
    public XMLSerializer() {
        this.setOutputFormat(null);
    }

    public XMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        this.setOutputFormat(outputFormat);
        try {
            this.setOutputByteStream(outputStream);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public XMLSerializer(Writer writer, OutputFormat outputFormat) {
        this.setOutputFormat(outputFormat);
        this.setOutputCharStream(writer);
    }

    public XMLSerializer(OutputFormat outputFormat) {
        this.setOutputFormat(outputFormat);
    }

    public void endElement(String string) {
        this.endElement(null, null, string);
    }

    public void endElement(String string, String string2, String string3) {
        this.unindent();
        ElementState elementState = this.getElementState();
        if (elementState.empty) {
            this.printText("/>");
        } else {
            if (elementState.inCData) {
                this.printText("]]>");
            }
            if (this._format.getIndenting() && !elementState.preserveSpace && elementState.afterElement) {
                this.breakLine();
            }
            this.printText("</" + elementState.rawName + ">");
        }
        elementState = this.leaveElementState();
        if (elementState != null) {
            elementState.afterElement = true;
            elementState.empty = false;
        } else {
            this.flush();
        }
    }

    protected String getEntityRef(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }

    protected void serializeElement(Element element) {
        boolean bl;
        String string = element.getTagName();
        ElementState elementState = this.getElementState();
        if (elementState == null) {
            if (!this._started) {
                this.startDocument(string);
            }
            bl = this._format.getPreserveSpace();
        } else {
            if (elementState.empty) {
                this.printText(">");
            }
            bl = elementState.preserveSpace;
            if (this._format.getIndenting() && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this.breakLine();
            }
        }
        this.printText(String.valueOf('<') + string);
        this.indent();
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                String string2 = attr.getName();
                String string3 = attr.getValue();
                if (string3 == null) {
                    string3 = "";
                }
                if (attr.getSpecified()) {
                    this.printSpace();
                    this.printText(String.valueOf(string2) + "=\"" + this.escape(string3) + '\"');
                }
                if (string2.equals("xml:space")) {
                    bl = string3.equals("preserve") ? true : this._format.getPreserveSpace();
                }
                ++n;
            }
        }
        if (element.hasChildNodes()) {
            elementState = this.enterElementState(null, null, string, bl);
            elementState.doCData = this._format.isCDataElement(string);
            elementState.unescaped = this._format.isNonEscapingElement(string);
            Node node = element.getFirstChild();
            while (node != null) {
                this.serializeNode(node);
                node = node.getNextSibling();
            }
            this.endElement(string);
        } else {
            this.unindent();
            this.printText("/>");
            if (elementState != null) {
                elementState.afterElement = true;
                elementState.empty = false;
            }
        }
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        if (outputFormat == null) {
            super.setOutputFormat(new OutputFormat("xml", null, false));
        } else {
            super.setOutputFormat(outputFormat);
        }
    }

    public void startDocument() {
        if (this._writer == null) {
            throw new IllegalStateException("SER002 No writer supplied for serializer");
        }
    }

    protected void startDocument(String string) {
        String string2 = this.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuffer stringBuffer = new StringBuffer("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    stringBuffer.append(this._format.getVersion());
                } else {
                    stringBuffer.append("1.0");
                }
                stringBuffer.append('\"');
                if (this._format.getEncoding() != null) {
                    stringBuffer.append(" encoding=\"");
                    stringBuffer.append(this._format.getEncoding());
                    stringBuffer.append('\"');
                }
                if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                    stringBuffer.append(" standalone=\"yes\"");
                }
                stringBuffer.append("?>");
                this.printText(stringBuffer.toString());
                this.breakLine();
            }
            if (this._docTypeSystemId != null) {
                this.printText("<!DOCTYPE ");
                this.printText(string);
                if (this._docTypePublicId != null) {
                    this.printText(" PUBLIC ");
                    this.printDoctypeURL(this._docTypePublicId);
                    if (this._format.getIndenting()) {
                        this.breakLine();
                        int n = 0;
                        while (n < 18 + string.length()) {
                            this.printText(" ");
                            ++n;
                        }
                    } else {
                        this.printText(" ");
                    }
                    this.printDoctypeURL(this._docTypeSystemId);
                } else {
                    this.printText(" SYSTEM ");
                    this.printDoctypeURL(this._docTypeSystemId);
                }
                if (string2 != null && string2.length() > 0) {
                    this.printText(" [");
                    this.printText(string2, true);
                    this.printText("]");
                }
                this.printText(">");
                this.breakLine();
            } else if (string2 != null && string2.length() > 0) {
                this.printText("<!DOCTYPE ");
                this.printText(string);
                this.printText(" [");
                this.printText(string2, true);
                this.printText("]>");
                this.breakLine();
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        String string4;
        String string5;
        Object object;
        boolean bl;
        boolean bl2 = false;
        if (this._writer == null) {
            throw new IllegalStateException("SER002 No writer supplied for serializer");
        }
        ElementState elementState = this.getElementState();
        if (elementState == null) {
            if (!this._started) {
                this.startDocument(string2 == null ? string3 : string2);
            }
            bl = this._format.getPreserveSpace();
        } else {
            if (elementState.empty) {
                this.printText(">");
            }
            bl = elementState.preserveSpace;
            if (this._format.getIndenting() && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this.breakLine();
            }
        }
        if (string3 == null) {
            string3 = string2;
            if (string != null && ((String)(object = this.getPrefix(string))).length() > 0) {
                string3 = String.valueOf(object) + ":" + string2;
            }
            bl2 = true;
        }
        this.printText(String.valueOf('<') + string3);
        this.indent();
        if (attributes != null) {
            int n = 0;
            while (n < attributes.getLength()) {
                this.printSpace();
                string5 = attributes.getRawName(n);
                if (string5 == null) {
                    string5 = attributes.getLocalName(n);
                    String string6 = attributes.getURI(n);
                    if (!(string6 == null || string != null && string6.equals(string) || (object = this.getPrefix(string6)) == null || ((String)object).length() <= 0)) {
                        string5 = String.valueOf(object) + ":" + string5;
                    }
                }
                if ((string4 = attributes.getValue(n)) == null) {
                    string4 = "";
                }
                this.printText(String.valueOf(string5) + "=\"" + this.escape(string4) + '\"');
                if (string5.equals("xml:space")) {
                    bl = string4.equals("preserve") ? true : this._format.getPreserveSpace();
                }
                ++n;
            }
        }
        if (bl2) {
            object = this._prefixes.keys();
            while (object.hasMoreElements()) {
                this.printSpace();
                string4 = (String)object.nextElement();
                string5 = (String)this._prefixes.get(string4);
                if (string5.length() == 0) {
                    this.printText("xmlns=\"" + string4 + '\"');
                    continue;
                }
                this.printText("xmlns:" + string5 + "=\"" + string4 + '\"');
            }
        }
        elementState = this.enterElementState(string, string2, string3, bl);
        elementState.doCData = this._format.isCDataElement(string == null ? string3 : String.valueOf(string) + "^" + string2);
        elementState.unescaped = this._format.isNonEscapingElement(string == null ? string3 : String.valueOf(string) + "^" + string2);
    }

    public void startElement(String string, AttributeList attributeList) {
        boolean bl;
        if (this._writer == null) {
            throw new IllegalStateException("SER002 No writer supplied for serializer");
        }
        ElementState elementState = this.getElementState();
        if (elementState == null) {
            if (!this._started) {
                this.startDocument(string);
            }
            bl = this._format.getPreserveSpace();
        } else {
            if (elementState.empty) {
                this.printText(">");
            }
            bl = elementState.preserveSpace;
            if (this._format.getIndenting() && !elementState.preserveSpace && (elementState.empty || elementState.afterElement)) {
                this.breakLine();
            }
        }
        this.printText(String.valueOf('<') + string);
        this.indent();
        if (attributeList != null) {
            int n = 0;
            while (n < attributeList.getLength()) {
                this.printSpace();
                String string2 = attributeList.getName(n);
                String string3 = attributeList.getValue(n);
                if (string3 == null) {
                    string3 = "";
                }
                this.printText(String.valueOf(string2) + "=\"" + this.escape(string3) + '\"');
                if (string2.equals("xml:space")) {
                    bl = string3.equals("preserve") ? true : this._format.getPreserveSpace();
                }
                ++n;
            }
        }
        elementState = this.enterElementState(null, null, string, bl);
        elementState.doCData = this._format.isCDataElement(string);
        elementState.unescaped = this._format.isNonEscapingElement(string);
    }
}

