/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.ArrayMath;
import JSci.maths.EngineerMath;
import JSci.maths.NumericalConstants;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.Signal;

public final class FWTCoef
implements NumericalConstants,
Cloneable {
    protected double[][] coefs;
    static final double normalisation = 0.7071067811865475;

    public FWTCoef() {
    }

    public FWTCoef(double[][] dArray) {
        this.coefs = dArray;
    }

    public Object clone() {
        try {
            FWTCoef fWTCoef = (FWTCoef)super.clone();
            if (this.coefs != null) {
                fWTCoef.coefs = ArrayMath.copy((double[][])this.coefs);
            }
            return fWTCoef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int getJ() {
        return this.coefs.length;
    }

    public int dimension(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("This dimension doesn't exist : " + n + ", " + this.coefs.length);
        }
        return this.coefs[n].length;
    }

    public double[][] getCoefs() {
        return this.coefs;
    }

    public double[] norm() {
        double[] dArray = new double[this.coefs.length];
        int n = 0;
        while (n < this.coefs.length) {
            dArray[n] = ArrayMath.norm((double[])this.coefs[n]);
            ++n;
        }
        return dArray;
    }

    public double norm(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        double d = ArrayMath.norm((double[])this.coefs[n]);
        return d;
    }

    private double[] sumSquares() {
        double[] dArray = new double[this.coefs.length];
        int n = 0;
        while (n < this.coefs.length) {
            dArray[n] = ArrayMath.sumSquares((double[])this.coefs[n]);
            ++n;
        }
        return dArray;
    }

    public double sumSquares(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        double d = ArrayMath.sumSquares((double[])this.coefs[n]);
        return d;
    }

    public double mass(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        double d = ArrayMath.mass((double[])this.coefs[n]);
        return d;
    }

    private double[] variance() {
        double[] dArray = new double[this.coefs.length];
        int n = 0;
        while (n < this.coefs.length) {
            dArray[n] = ArrayMath.variance((double[])this.coefs[n]);
            ++n;
        }
        return dArray;
    }

    public double variance(int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        double d = ArrayMath.variance((double[])this.coefs[n]);
        return d;
    }

    public double sumEnergies() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = this.sumSquares();
        double d = 0.0;
        int n = 1;
        while (n < dArray.length) {
            d += dArray[n];
            ++n;
        }
        return d;
    }

    public double entropy() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double d = this.sumEnergies();
        int n = 0;
        int n2 = 1;
        while (n2 < this.coefs.length) {
            n += this.coefs[n2].length;
            ++n2;
        }
        double[] dArray = new double[n];
        int n3 = 0;
        int n4 = 1;
        while (n4 < this.coefs.length) {
            int n5 = 0;
            while (n5 < this.coefs[n4].length) {
                dArray[n3] = this.coefs[n4][n5] * this.coefs[n4][n5] / d;
                ++n3;
                ++n5;
            }
            ++n4;
        }
        return EngineerMath.icf((double[])dArray);
    }

    public double sumVariance() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = this.variance();
        double d = 0.0;
        int n = 1;
        while (n < dArray.length) {
            d += dArray[n];
            ++n;
        }
        return d;
    }

    public double energyRatio(int n) {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        if (n < 1 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        if (this.sumEnergies() == 0.0) {
            if (this.coefs.length != 0) {
                return 1 / this.coefs.length;
            }
            throw new IllegalArgumentException("No energy!");
        }
        return this.sumSquares(n) / this.sumEnergies();
    }

    public double varianceRatio(int n) {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        if (n < 1 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        if (this.sumVariance() == 0.0) {
            if (this.coefs.length != 0) {
                return 1 / this.coefs.length;
            }
            throw new IllegalArgumentException("No energy!");
        }
        return this.variance(n) / this.sumVariance();
    }

    public double icf() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = new double[this.coefs.length - 1];
        int n = 1;
        while (n < this.coefs.length) {
            dArray[n - 1] = this.energyRatio(n);
            ++n;
        }
        return EngineerMath.icf((double[])dArray);
    }

    public double varianceICF() {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No wavelet coefficients!");
        }
        double[] dArray = new double[this.coefs.length - 1];
        int n = 1;
        while (n < this.coefs.length) {
            dArray[n - 1] = this.varianceRatio(n);
            ++n;
        }
        return EngineerMath.icf((double[])dArray);
    }

    public void setCoefs(double[][] dArray) {
        this.coefs = dArray;
    }

    public void setCoefs(double[] dArray, int n) {
        if (n < 0 || n >= this.coefs.length) {
            throw new IllegalArgumentException("The integer parameter " + n + " should be between 0 and " + (this.coefs.length - 1));
        }
        this.coefs[n] = dArray;
    }

    public void synthesize(Filter filter, double[] dArray) {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No synthesis possible : " + this.coefs.length);
        }
        double[] dArray2 = filter.lowpass(this.coefs[0], dArray);
        double[] dArray3 = filter.highpass(this.coefs[this.coefs.length - 1], dArray);
        if ((dArray2 = ArrayMath.scalarMultiply((double)0.7071067811865475, (double[])dArray2)).length != dArray3.length) {
            throw new IllegalArgumentException("Synthesis impossible : bad data/multiresolution?" + this.coefs[0].length + ", " + this.coefs[this.coefs.length - 1].length + ", " + dArray2.length + ", " + dArray3.length);
        }
        dArray2 = ArrayMath.add((double[])dArray2, (double[])dArray3);
        double[][] dArray4 = new double[this.coefs.length - 1][];
        int n = 1;
        while (n < this.coefs.length - 1) {
            dArray4[n] = this.coefs[n];
            ++n;
        }
        dArray4[0] = dArray2;
        this.coefs = dArray4;
    }

    public void synthesize(Filter filter, double[] dArray, int n) {
        if (n < 0 || n > this.coefs.length - 1) {
            throw new IllegalArgumentException("The integer parameter " + n + " must be between 0 and " + (this.coefs.length - 1));
        }
        int n2 = 0;
        while (n2 < n) {
            this.synthesize(filter, dArray);
            ++n2;
        }
    }

    public void synthesizeAll(Filter filter, double[] dArray) {
        this.synthesize(filter, dArray, this.coefs.length - 1);
    }

    public void synthesize(Filter filter) {
        if (this.coefs.length <= 1) {
            throw new IllegalArgumentException("No synthesis possible : " + this.coefs.length);
        }
        double[] dArray = filter.lowpass(this.coefs[0]);
        double[] dArray2 = filter.highpass(this.coefs[this.coefs.length - 1]);
        if ((dArray = ArrayMath.scalarMultiply((double)0.7071067811865475, (double[])dArray)).length != dArray2.length) {
            throw new IllegalArgumentException("Synthesis impossible : bad data/multiresolution?" + this.coefs[0].length + ", " + this.coefs[this.coefs.length - 1].length + ", " + dArray.length + ", " + dArray2.length);
        }
        dArray = ArrayMath.add((double[])dArray, (double[])dArray2);
        double[][] dArray3 = new double[this.coefs.length - 1][];
        int n = 1;
        while (n < this.coefs.length - 1) {
            dArray3[n] = this.coefs[n];
            ++n;
        }
        dArray3[0] = dArray;
        this.coefs = dArray3;
    }

    public void synthesize(Filter filter, int n) {
        if (n < 0 || n > this.coefs.length - 1) {
            throw new IllegalArgumentException("The integer parameter " + n + " must be between 0 and " + (this.coefs.length - 1));
        }
        int n2 = 0;
        while (n2 < n) {
            this.synthesize(filter);
            ++n2;
        }
    }

    public void synthesizeAll(Filter filter) {
        this.synthesize(filter, this.coefs.length - 1);
    }

    public Signal rebuildSignal(Filter filter) {
        FWTCoef fWTCoef = new FWTCoef(this.coefs);
        fWTCoef.synthesizeAll(filter);
        return new Signal(fWTCoef.getCoefs()[0]);
    }

    public Signal rebuildSignal(Filter filter, double[] dArray) {
        FWTCoef fWTCoef = new FWTCoef(this.coefs);
        fWTCoef.synthesizeAll(filter, dArray);
        return new Signal(fWTCoef.getCoefs()[0]);
    }

    public void denoise(double d) {
        int n = 1;
        while (n < this.coefs.length) {
            this.coefs[n] = FWTCoef.denoise(this.coefs[n], d);
            ++n;
        }
    }

    public void denoise(double d, int n) {
        this.coefs[n] = FWTCoef.denoise(this.coefs[n], d);
    }

    public static double[] denoise(double[] dArray, double d) {
        if (d == 0.0) {
            return dArray;
        }
        double[] dArray2 = dArray;
        double d2 = ArrayMath.percentile((double[])ArrayMath.abs((double[])dArray2), (double)(1.0 - d));
        int n = 0;
        while (n < dArray2.length) {
            if (Math.abs(dArray2[n]) >= d2) {
                dArray2[n] = 0.0;
            }
            ++n;
        }
        return dArray2;
    }

    public void compress(double d) {
        int n = 1;
        while (n < this.coefs.length) {
            this.coefs[n] = FWTCoef.compress(this.coefs[n], d);
            ++n;
        }
    }

    public void compress(double d, int n) {
        this.coefs[n] = FWTCoef.compress(this.coefs[n], d);
    }

    public static double[] compress(double[] dArray, double d) {
        if (d == 0.0) {
            return dArray;
        }
        double[] dArray2 = dArray;
        double d2 = ArrayMath.percentile((double[])ArrayMath.abs((double[])dArray2), (double)d);
        int n = 0;
        while (n < dArray2.length) {
            if (Math.abs(dArray2[n]) <= d2) {
                dArray2[n] = 0.0;
            }
            ++n;
        }
        return dArray2;
    }

    public void denoiseHard(double d) {
        int n = 1;
        while (n < this.coefs.length) {
            this.coefs[n] = FWTCoef.denoiseHard(this.coefs[n], d);
            ++n;
        }
    }

    public void denoiseHard(double d, int n) {
        this.coefs[n] = FWTCoef.denoiseHard(this.coefs[n], d);
    }

    public static double[] denoiseHard(double[] dArray, double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("The cutoff value must be positive.");
        }
        double[] dArray2 = dArray;
        int n = 0;
        while (n < dArray2.length) {
            if (Math.abs(dArray2[n]) >= d) {
                dArray2[n] = 0.0;
            }
            ++n;
        }
        return dArray2;
    }

    public void compressHard(double d) {
        int n = 1;
        while (n < this.coefs.length) {
            this.coefs[n] = FWTCoef.compressHard(this.coefs[n], d);
            ++n;
        }
    }

    public void compressHard(double d, int n) {
        this.coefs[n] = FWTCoef.compressHard(this.coefs[n], d);
    }

    public static double[] compressHard(double[] dArray, double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("The cutoff value must be positive.");
        }
        double[] dArray2 = dArray;
        int n = 0;
        while (n < dArray2.length) {
            if (Math.abs(dArray2[n]) <= d) {
                dArray2[n] = 0.0;
            }
            ++n;
        }
        return dArray2;
    }
}

