/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.ArrayMath;
import JSci.maths.MaximumIterationsExceededException;
import JSci.maths.wavelet.BasisFunctionLibrary;
import JSci.maths.wavelet.Cosine;
import JSci.maths.wavelet.DiscreteFunction;
import JSci.maths.wavelet.DiscreteHilbertSpace;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.Sine;

public class MatchingPursuit
extends BasisFunctionLibrary
implements Cloneable {
    private int[] Record;
    private double[] Coefs;
    private double[][][] TF = new double[0][][];

    public void add(MultiscaleFunction multiscaleFunction, MultiscaleFunction multiscaleFunction2) {
        super.add(multiscaleFunction, multiscaleFunction2);
        double[][][] dArray = this.TF;
        this.TF = new double[this.getSize()][][];
        System.arraycopy(dArray, 0, this.TF, 0, dArray.length);
        this.TF[this.getSize() - 1] = this.getTF(this.Fprimary[this.getSize() - 1]);
    }

    public Object clone() {
        MatchingPursuit matchingPursuit = (MatchingPursuit)super.clone();
        if (this.Record != null) {
            matchingPursuit.Record = ArrayMath.copy((int[])this.Record);
        }
        if (this.Coefs != null) {
            matchingPursuit.Coefs = ArrayMath.copy((double[])this.Coefs);
        }
        if (this.TF != null) {
            this.TF = new double[this.TF.length][][];
            System.arraycopy(this.TF, 0, matchingPursuit.TF, 0, this.TF.length);
        }
        return matchingPursuit;
    }

    private void addToRecord(int n, double d) {
        if (this.Record == null) {
            this.Record = new int[1];
            this.Record[0] = n;
            this.Coefs = new double[1];
            this.Coefs[0] = d;
            return;
        }
        int[] nArray = this.Record;
        double[] dArray = this.Coefs;
        this.Record = new int[this.Record.length + 1];
        this.Coefs = new double[this.Record.length + 1];
        System.arraycopy(nArray, 0, this.Record, 0, this.Record.length - 1);
        System.arraycopy(dArray, 0, this.Coefs, 0, this.Record.length - 1);
        this.Record[this.Record.length - 1] = n;
        this.Coefs[this.Record.length - 1] = d;
    }

    public int[] getRecord() {
        return this.Record;
    }

    public double[] getRecordedNorms() {
        double[] dArray = new double[this.Record.length];
        int n = 0;
        while (n < this.Record.length) {
            dArray[n] = Math.abs(this.Coefs[n]) * this.Fprimary[n].norm();
            ++n;
        }
        return dArray;
    }

    public double[] getCoefs() {
        return this.Coefs;
    }

    public MatchingPursuit(DiscreteFunction discreteFunction) {
        super(discreteFunction);
    }

    public void setData(DiscreteFunction discreteFunction) {
        if (this.DFunction != null && discreteFunction.dimension() != this.DFunction.dimension()) {
            throw new IllegalArgumentException("You cannot change the dimension of the data object. Please create a new object.");
        }
        this.DFunction = (DiscreteFunction)discreteFunction.clone();
        this.Record = null;
        this.Coefs = null;
    }

    private MatchingPursuit() {
    }

    public void diagnostic(double d) throws MaximumIterationsExceededException {
        if (d < 0.0) {
            throw new IllegalArgumentException("A tolerance cannot be negative :" + d + " < 0");
        }
        MatchingPursuit matchingPursuit = (MatchingPursuit)this.clone();
        int n = 0;
        while (n < this.getSize()) {
            matchingPursuit.DFunction = (DiscreteFunction)this.Fprimary[n].clone();
            double d2 = matchingPursuit.DFunction.norm();
            matchingPursuit.match();
            double d3 = matchingPursuit.DFunction.norm();
            if (d3 > d2 * d) {
                throw new IllegalArgumentException("Fail to match dictionnary element number " + n + " got a 'de facto' tolerance of " + d3 / d2);
            }
            ++n;
        }
    }

    private double[][] getTF(int n, double d) {
        double[][] dArray = ArrayMath.copy((double[][])this.TF[n]);
        int n2 = 0;
        while (n2 < dArray.length) {
            int n3 = 0;
            while (n3 < dArray[n2].length) {
                double[] dArray2 = dArray[n2];
                int n4 = n3++;
                dArray2[n4] = dArray2[n4] * d;
            }
            ++n2;
        }
        return dArray;
    }

    private double[][] getTF(DiscreteFunction discreteFunction) {
        int n = (int)Math.ceil((double)this.DFunction.dimension() / 2.0);
        double[][] dArray = new double[n][this.DFunction.dimension()];
        double[] dArray2 = discreteFunction.evaluate(0);
        int n2 = 0;
        while (n2 < n) {
            double d = BasisFunctionLibrary.norm(DiscreteHilbertSpace.integrate(discreteFunction, new Cosine(this.DFunction.dimension(), n2)), DiscreteHilbertSpace.integrate(discreteFunction, new Sine(this.DFunction.dimension(), n2)));
            int n3 = 0;
            while (n3 < this.DFunction.dimension()) {
                dArray[n2][n3] = dArray2[n3] * d;
                ++n3;
            }
            ++n2;
        }
        return dArray;
    }

    public double[][] match() {
        double d = this.getWeigth(0);
        int n = 0;
        double d2 = this.getResidue(0);
        int n2 = 1;
        while (n2 < this.getSize()) {
            double d3 = DiscreteHilbertSpace.integrate(this.DFunction, this.Fdual[n2]);
            double[] dArray = DiscreteHilbertSpace.add(this.DFunction, -d3, this.Fprimary[n2]);
            double d4 = ArrayMath.norm((double[])dArray);
            if (d4 < d2) {
                d2 = d4;
                d = d3;
                n = n2;
            }
            ++n2;
        }
        this.addToRecord(n, d);
        this.DFunction = new DiscreteFunction(DiscreteHilbertSpace.add(this.DFunction, -d, this.Fprimary[n]));
        return this.getTF(n, d);
    }

    public double[][] matchAll(double d) throws MaximumIterationsExceededException {
        if (d > 1.0 || d < 0.0) {
            throw new IllegalArgumentException("The percentile should be between 0 and 1: " + d);
        }
        int n = 0;
        double d2 = this.DFunction.norm();
        double d3 = d2 * d;
        int n2 = 5 * this.getSize();
        double[][] dArray = new double[0][0];
        while (this.DFunction.norm() > d3) {
            if (++n > n2) {
                throw new MaximumIterationsExceededException("Impossible to match to the desired precision (" + d + ") with this dictionnary of size " + this.getSize() + " after " + n + " iterations. You might want to expand the dictionnary.");
            }
            dArray = dArray.length != 0 ? BasisFunctionLibrary.add(dArray, this.match()) : this.match();
        }
        return dArray;
    }

    public double[][] forcedMatch(int n) {
        double d = DiscreteHilbertSpace.integrate(this.DFunction, this.Fdual[n]);
        this.addToRecord(n, d);
        this.DFunction = new DiscreteFunction(DiscreteHilbertSpace.add(this.DFunction, -d, this.Fprimary[n]));
        return this.getTF(n, d);
    }

    public double[][] match(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Can't do " + n + " matching... Must be a positive number.");
        }
        double[][] dArray = this.match();
        int n2 = 1;
        while (n2 < n) {
            dArray = BasisFunctionLibrary.add(dArray, this.match());
            ++n2;
        }
        return dArray;
    }
}

