/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.cdf2_4;

import JSci.maths.ArrayMath;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.splines.LinearSpline;

public final class MultiSpline2_4
implements Filter {
    static final double[] vg = new double[]{0.5, 1.0, 0.5};
    static final double[] v0 = new double[]{1.0, 0.5};
    static final double[] og = new double[]{0.0234375, 0.046875, -0.125, -0.296875, 0.703125, -0.296875, -0.125, 0.046875, 0.0234375};
    static final double[] o0 = new double[]{-0.546875, 0.5696614583333334, -0.3138020833333333, -0.103515625, 0.10677083333333333, 0.043619791666666664, -0.01953125, -0.009765625};
    static final double[] on0_1 = ArrayMath.invert((double[])o0);
    static final double[] o1 = new double[]{0.234375, -0.087890625, -0.41015625, 0.673828125, -0.2421875, -0.103515625, 0.03515625, 0.017578125};
    static final double[] on0_2 = ArrayMath.invert((double[])o1);

    public int previousDimension(int n) {
        int n2 = (int)Math.round((double)(n + 1) / 2.0);
        if (2 * n2 - 1 == n) {
            return n2;
        }
        throw new IllegalScalingException("Even number of values presented to an odd Filter. Please change the number of values/iterations.");
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        if (dArray.length < 2) {
            throw new IllegalScalingException("The array is not long enough : " + dArray.length + " < 2");
        }
        double[] dArray2 = new double[2 * dArray.length - 1];
        int n = 1;
        while (n < dArray.length - 1) {
            int n2 = 2 * n - 1;
            dArray2[n2] = dArray2[n2] + dArray[n] * vg[0];
            int n3 = 2 * n;
            dArray2[n3] = dArray2[n3] + dArray[n] * vg[1];
            int n4 = 2 * n + 1;
            dArray2[n4] = dArray2[n4] + dArray[n] * vg[2];
            ++n;
        }
        dArray2[0] = dArray2[0] + v0[0] * dArray[0];
        dArray2[1] = dArray2[1] + v0[1] * dArray[0];
        int n5 = dArray2.length - 1;
        dArray2[n5] = dArray2[n5] + v0[0] * dArray[dArray.length - 1];
        int n6 = dArray2.length - 2;
        dArray2[n6] = dArray2[n6] + v0[1] * dArray[dArray.length - 1];
        return dArray2;
    }

    public double[] highpass(double[] dArray) {
        int n = dArray.length + 1;
        double[] dArray2 = ArrayMath.scalarMultiplyFast((double)dArray[0], (double[])MultiSpline2_4.wavelet(n, 0).interpolate(0));
        int n2 = 1;
        while (n2 < dArray.length) {
            dArray2 = ArrayMath.add((double[])dArray2, (double[])ArrayMath.scalarMultiply((double)dArray[n2], (double[])MultiSpline2_4.wavelet(n, n2).interpolate(0)));
            ++n2;
        }
        return dArray2;
    }

    public static LinearSpline hat(int n, int n2) {
        if (n2 < 0 || n < 0 || n2 >= n) {
            throw new IllegalArgumentException("Incorrect parameters : " + n + ", " + n2 + " !");
        }
        if (n < 5) {
            throw new IllegalScalingException(n, 5);
        }
        double[] dArray = new double[n];
        dArray[n2] = 1.0;
        return new LinearSpline(dArray);
    }

    public static LinearSpline scaling(int n, int n2) {
        return MultiSpline2_4.hat(n, n2);
    }

    public static LinearSpline wavelet(int n, int n2) {
        if (n2 < 0 || n < 0 || n2 >= n - 1) {
            throw new IllegalArgumentException("Incorrect parameters : " + n + ", " + n2);
        }
        if (n < 5) {
            throw new IllegalScalingException(n, 5);
        }
        double[] dArray = new double[2 * n - 1];
        if (n2 > 1 && n2 < n - 3) {
            dArray = ArrayMath.padding((int)dArray.length, (int)(2 * n2 - 4 + 1), (double[])og);
        } else if (n2 == 0) {
            dArray = ArrayMath.padding((int)dArray.length, (int)0, (double[])o0);
        } else if (n2 == 1) {
            dArray = ArrayMath.padding((int)dArray.length, (int)0, (double[])o1);
        } else if (n2 == n - 2) {
            dArray = ArrayMath.padding((int)dArray.length, (int)(dArray.length - on0_1.length), (double[])on0_1);
        } else if (n2 == n - 3) {
            dArray = ArrayMath.padding((int)dArray.length, (int)(dArray.length - on0_2.length), (double[])on0_2);
        } else {
            throw new IllegalArgumentException("Oups!");
        }
        return new LinearSpline(dArray);
    }
}

