/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.cdf3_5;

import JSci.maths.ArrayMath;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.Multiresolution;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.cdf3_5.DualScaling3_5;
import JSci.maths.wavelet.cdf3_5.DualWavelet3_5;
import JSci.maths.wavelet.cdf3_5.MultiSpline3_5;

public final class CDF3_5
extends Multiresolution
implements Filter {
    protected static final int filtretype = 2;
    protected static final int minlength = 12;
    static final double[] v0 = new double[]{1.6998046875, 2.9005859375, -2.928515625, -1.616015625, 1.837109375, 2.265234375, -3.2373046875, 1.0791015625};
    static final double[] v1 = new double[]{-0.1919921875, 0.5759765625, 1.944140625, 0.631640625, -0.946484375, -0.999609375, 1.4794921875, -0.4931640625};
    static final double[] v2 = new double[]{0.05658203125, -0.16974609375, -0.1508984375, 0.9053515625, 1.5183723958333333, 0.8797265625, -1.53955078125, 0.4611002604166667, 0.05859375, -0.01953125};
    static final double[] v3 = new double[]{-0.01541015625, 0.04623046875, 0.0207421875, -0.1855078125, -0.0339453125, 0.6376171875, 2.16259765625, -0.36669921875, -0.37890625, 0.07421875, 0.05859375, -0.01953125};
    static final double[] v4 = new double[]{0.0021875, -0.0065625, -0.001875, 0.023125, -0.001875, -0.061875, -0.4296875, 1.4765625, 1.3671875, -0.1015625, -0.37890625, 0.07421875, 0.05859375, -0.01953125};
    static final double[] v5;
    static final double[] vg;
    static final double[] vd0;
    static final double[] vd1;
    static final double[] vd2;
    static final double[] vd3;
    static final double[] vd4;
    static final double[] vd5;
    static final double[] phvg;

    public int getFilterType() {
        return 2;
    }

    public MultiscaleFunction primaryScaling(int n, int n2) {
        return MultiSpline3_5.scaling(n, n2);
    }

    public MultiscaleFunction dualScaling(int n, int n2) {
        return new DualScaling3_5(n, n2);
    }

    public MultiscaleFunction primaryWavelet(int n, int n2) {
        return MultiSpline3_5.wavelet(n, n2);
    }

    public MultiscaleFunction dualWavelet(int n, int n2) {
        return new DualWavelet3_5(n, n2);
    }

    public int previousDimension(int n) {
        return Cascades.previousDimension(2, n);
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        int n;
        if (dArray.length < 12) {
            throw new IllegalScalingException("The array is not long enough : " + dArray.length + " < 12");
        }
        double[] dArray2 = new double[2 * dArray.length - 2];
        int n2 = dArray.length - 1;
        int n3 = 6;
        while (n3 <= n2 - 6) {
            n = -6;
            while (n <= 5) {
                int n4 = 2 * n3 + n;
                dArray2[n4] = dArray2[n4] + vg[n + 6] * dArray[n3];
                ++n;
            }
            ++n3;
        }
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[0], (double[])v0, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[1], (double[])v1, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[2], (double[])v2, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[3], (double[])v3, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[4], (double[])v4, (int)0);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[5], (double[])v5, (int)0);
        n = dArray2.length - vd0.length;
        int n5 = dArray2.length - vd1.length;
        int n6 = dArray2.length - vd2.length;
        int n7 = dArray2.length - vd3.length;
        int n8 = dArray2.length - vd4.length;
        int n9 = dArray2.length - vd5.length;
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2], (double[])vd0, (int)n);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 1], (double[])vd1, (int)n5);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 2], (double[])vd2, (int)n6);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 3], (double[])vd3, (int)n7);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 4], (double[])vd4, (int)n8);
        dArray2 = ArrayMath.add((double[])dArray2, (double)dArray[n2 - 5], (double[])vd5, (int)n9);
        return dArray2;
    }

    public double[] highpass(double[] dArray) {
        if (dArray.length < 4) {
            throw new IllegalScalingException("The array is not long enough : " + dArray.length + " < 4");
        }
        double[] dArray2 = new double[2 * dArray.length + 2];
        int n = 0;
        while (n < dArray.length) {
            int n2 = 2 * n;
            dArray2[n2] = dArray2[n2] + dArray[n] * phvg[0];
            int n3 = 2 * n + 1;
            dArray2[n3] = dArray2[n3] + dArray[n] * phvg[1];
            int n4 = 2 * n + 2;
            dArray2[n4] = dArray2[n4] + dArray[n] * phvg[2];
            int n5 = 2 * n + 3;
            dArray2[n5] = dArray2[n5] + dArray[n] * phvg[3];
            ++n;
        }
        return dArray2;
    }

    public double[] evalScaling(int n, int n2, int n3) {
        return Cascades.evalScaling(this, n, n3, n2);
    }

    public double[] evalWavelet(int n, int n2, int n3) {
        return Cascades.evalWaveletQuadratic(this, n, n3, n2);
    }

    static {
        double[] dArray = new double[16];
        dArray[6] = 0.1328125;
        dArray[7] = -0.3984375;
        dArray[8] = -0.1015625;
        dArray[9] = 1.3671875;
        dArray[10] = 1.3671875;
        dArray[11] = -0.1015625;
        dArray[12] = -0.37890625;
        dArray[13] = 0.07421875;
        dArray[14] = 0.05859375;
        dArray[15] = -0.01953125;
        v5 = dArray;
        vg = new double[]{-0.01953125, 0.05859375, 0.07421875, -0.37890625, -0.1015625, 1.3671875, 1.3671875, -0.1015625, -0.37890625, 0.07421875, 0.05859375, -0.01953125};
        vd0 = ArrayMath.invert((double[])v0);
        vd1 = ArrayMath.invert((double[])v1);
        vd2 = ArrayMath.invert((double[])v2);
        vd3 = ArrayMath.invert((double[])v3);
        vd4 = ArrayMath.invert((double[])v4);
        vd5 = ArrayMath.invert((double[])v5);
        phvg = new double[]{-0.5, 1.5, -1.5, 0.5};
    }
}

