/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies3;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies3.Daubechies3;

public final class Wavelet3
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies3 cdf = new Daubechies3();

    public Wavelet3(int n, int n2) {
        this.setParameters(n, n2);
    }

    public Wavelet3() {
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Wavelet3) {
            Wavelet3 wavelet3 = (Wavelet3)object;
            return this.dimension(0) == wavelet3.dimension(0) && this.position() == wavelet3.position();
        }
        return false;
    }

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public int getFilterType() {
        return 4;
    }

    public void setParameters(int n, int n2) {
        if (n < 8) {
            throw new IllegalScalingException(n, 8);
        }
        this.n0 = n;
        this.k = n2;
    }

    public Object clone() {
        Wavelet3 wavelet3 = (Wavelet3)super.clone();
        wavelet3.n0 = this.n0;
        wavelet3.k = this.k;
        return wavelet3;
    }

    public double[] evaluate(int n) {
        return cdf.evalWavelet(this.n0, this.k, n);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n + 1, 4);
    }

    public int dimension() {
        return this.dimension(0);
    }

    public int position() {
        return this.k;
    }
}

