/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies8;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies8.Daubechies8;

public final class Wavelet8
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies8 cdf = new Daubechies8();

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Wavelet8) {
            Wavelet8 wavelet8 = (Wavelet8)object;
            return this.dimension(0) == wavelet8.dimension(0) && this.position() == wavelet8.position();
        }
        return false;
    }

    public Wavelet8(int n, int n2) {
        this.setParameters(n, n2);
    }

    public Wavelet8() {
    }

    public int getFilterType() {
        return 14;
    }

    public void setParameters(int n, int n2) {
        if (n < 28) {
            throw new IllegalScalingException(n, 28);
        }
        this.n0 = n;
        this.k = n2;
    }

    public Object clone() {
        Wavelet8 wavelet8 = (Wavelet8)super.clone();
        wavelet8.n0 = this.n0;
        wavelet8.k = this.k;
        return wavelet8;
    }

    public double[] evaluate(int n) {
        return cdf.evalWavelet(this.n0, this.k, n);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n + 1, 14);
    }

    public int dimension() {
        return this.dimension(0);
    }

    public int position() {
        return this.k;
    }
}

