/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.ExtraMath;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.RingMember;
import JSci.maths.fields.ComplexField;
import JSci.maths.fields.FieldMember;
import JSci.maths.groups.AbelianGroupMember;
import java.io.Serializable;

public final class Complex
implements FieldMember,
Serializable {
    private double re;
    private double im;
    private boolean isModCached = false;
    private double modCache;
    private boolean isArgCached = false;
    private double argCache;
    public static final Complex I = ComplexField.I;
    public static final Complex ONE = ComplexField.ONE;
    public static final Complex ZERO = ComplexField.ZERO;

    public Complex(double d, double d2) {
        this.re = d;
        this.im = d2;
    }

    public Complex(String string) throws NumberFormatException {
        String string2;
        int n = string.indexOf(105);
        if (n == -1) {
            this.re = Double.valueOf(string);
            this.im = 0.0;
            return;
        }
        int n2 = string.indexOf(43, 1);
        if (n2 == -1) {
            n2 = string.indexOf(45, 1);
        }
        if (n2 == -1) {
            this.re = 0.0;
            string2 = string;
        } else if (n < n2) {
            string2 = string.substring(0, n2);
            this.re = Double.valueOf(string.substring(n2 + 1));
        } else {
            this.re = Double.valueOf(string.substring(0, n2));
            string2 = string.substring(n2 + 1);
        }
        if (string2.startsWith("i")) {
            this.im = Double.valueOf(string2.substring(1));
            return;
        }
        if (string2.endsWith("i")) {
            this.im = Double.valueOf(string2.substring(0, string2.length() - 1));
            return;
        }
        throw new NumberFormatException("The imaginary part should have 'i' as a prefix or suffix.");
    }

    public static Complex polar(double d, double d2) {
        Complex complex = new Complex(d * Math.cos(d2), d * Math.sin(d2));
        complex.modCache = d;
        complex.isModCached = true;
        complex.argCache = d2;
        complex.isArgCached = true;
        return complex;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Complex) {
            Complex complex = (Complex)object;
            return Math.abs(this.re - complex.re) <= GlobalSettings.ZERO_TOL && Math.abs(this.im - complex.im) <= GlobalSettings.ZERO_TOL;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.re);
        if (this.im >= 0.0) {
            stringBuffer.append("+");
        }
        stringBuffer.append(this.im);
        stringBuffer.append("i");
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.mod());
    }

    public boolean isNaN() {
        return this.re == Double.NaN || this.im == Double.NaN;
    }

    public boolean isInfinite() {
        return this.re == Double.POSITIVE_INFINITY || this.re == Double.NEGATIVE_INFINITY || this.im == Double.POSITIVE_INFINITY || this.im == Double.NEGATIVE_INFINITY;
    }

    public double real() {
        return this.re;
    }

    public double imag() {
        return this.im;
    }

    public double mod() {
        if (this.isModCached) {
            return this.modCache;
        }
        double d = Math.abs(this.re);
        double d2 = Math.abs(this.im);
        this.modCache = d <= GlobalSettings.ZERO_TOL && d2 <= GlobalSettings.ZERO_TOL ? 0.0 : (d < d2 ? d2 * Math.sqrt(1.0 + this.re / this.im * (this.re / this.im)) : d * Math.sqrt(1.0 + this.im / this.re * (this.im / this.re)));
        this.isModCached = true;
        return this.modCache;
    }

    public double arg() {
        if (this.isArgCached) {
            return this.argCache;
        }
        this.argCache = this.re > GlobalSettings.ZERO_TOL ? Math.atan(this.im / this.re) : (this.re < -GlobalSettings.ZERO_TOL ? (this.im >= -GlobalSettings.ZERO_TOL ? Math.atan(this.im / this.re) + Math.PI : Math.atan(this.im / this.re) - Math.PI) : (this.im > GlobalSettings.ZERO_TOL ? 1.5707963267948966 : (this.im < -GlobalSettings.ZERO_TOL ? -1.5707963267948966 : 0.0)));
        this.isArgCached = true;
        return this.argCache;
    }

    public AbelianGroupMember negate() {
        return new Complex(-this.re, -this.im);
    }

    public FieldMember inverse() {
        double d;
        double d2;
        double d3;
        if (Math.abs(this.re) < Math.abs(this.im)) {
            d3 = this.re / this.im;
            d2 = -1.0;
            d = this.re * d3 + this.im;
        } else {
            d3 = 1.0;
            d2 = -this.im / this.re;
            d = this.re - this.im * d2;
        }
        return new Complex(d3 / d, d2 / d);
    }

    public Complex conjugate() {
        return new Complex(this.re, -this.im);
    }

    public AbelianGroupMember add(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof Complex) {
            return this.add((Complex)abelianGroupMember);
        }
        if (abelianGroupMember instanceof MathDouble) {
            return this.addReal(((MathDouble)abelianGroupMember).value());
        }
        if (abelianGroupMember instanceof MathInteger) {
            return this.addReal(((MathInteger)abelianGroupMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Complex add(Complex complex) {
        return new Complex(this.re + complex.re, this.im + complex.im);
    }

    public Complex addReal(double d) {
        return new Complex(this.re + d, this.im);
    }

    public Complex addImag(double d) {
        return new Complex(this.re, this.im + d);
    }

    public AbelianGroupMember subtract(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof Complex) {
            return this.subtract((Complex)abelianGroupMember);
        }
        if (abelianGroupMember instanceof MathDouble) {
            return this.subtractReal(((MathDouble)abelianGroupMember).value());
        }
        if (abelianGroupMember instanceof MathInteger) {
            return this.subtractReal(((MathInteger)abelianGroupMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Complex subtract(Complex complex) {
        return new Complex(this.re - complex.re, this.im - complex.im);
    }

    public Complex subtractReal(double d) {
        return new Complex(this.re - d, this.im);
    }

    public Complex subtractImag(double d) {
        return new Complex(this.re, this.im - d);
    }

    public RingMember multiply(RingMember ringMember) {
        if (ringMember instanceof Complex) {
            return this.multiply((Complex)ringMember);
        }
        if (ringMember instanceof MathDouble) {
            return this.multiply(((MathDouble)ringMember).value());
        }
        if (ringMember instanceof MathInteger) {
            return this.multiply(((MathInteger)ringMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Complex multiply(Complex complex) {
        return new Complex(this.re * complex.re - this.im * complex.im, this.re * complex.im + this.im * complex.re);
    }

    public Complex multiply(double d) {
        return new Complex(d * this.re, d * this.im);
    }

    public FieldMember divide(FieldMember fieldMember) {
        if (fieldMember instanceof Complex) {
            return this.divide((Complex)fieldMember);
        }
        if (fieldMember instanceof MathDouble) {
            return this.divide(((MathDouble)fieldMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Complex divide(Complex complex) {
        double d;
        double d2;
        double d3;
        if (Math.abs(complex.re) < Math.abs(complex.im)) {
            double d4 = complex.re / complex.im;
            d3 = complex.re * d4 + complex.im;
            d2 = this.re * d4 + this.im;
            d = this.im * d4 - this.re;
        } else {
            double d5 = complex.im / complex.re;
            d3 = complex.re + complex.im * d5;
            d2 = this.re + this.im * d5;
            d = this.im - this.re * d5;
        }
        return new Complex(d2 / d3, d / d3);
    }

    public Complex divide(double d) {
        return new Complex(this.re / d, this.im / d);
    }

    public Complex pow(Complex complex) {
        double d = this.mod();
        double d2 = this.arg();
        double d3 = Math.pow(d, complex.re) / Math.exp(d2 * complex.im);
        double d4 = d2 * complex.re + Math.log(d) * complex.im;
        return Complex.polar(d3, d4);
    }

    public Complex pow(double d) {
        return Complex.polar(Math.pow(this.mod(), d), this.arg() * d);
    }

    public Complex sqr() {
        return new Complex(this.re * this.re - this.im * this.im, 2.0 * this.re * this.im);
    }

    public Complex sqrt() {
        return Complex.polar(Math.pow(this.mod(), 0.5), this.arg() * 0.5);
    }

    public static Complex exp(Complex complex) {
        return new Complex(Math.exp(complex.re) * Math.cos(complex.im), Math.exp(complex.re) * Math.sin(complex.im));
    }

    public static Complex log(Complex complex) {
        return new Complex(Math.log(complex.mod()), complex.arg());
    }

    public static Complex sin(Complex complex) {
        return new Complex(Math.sin(complex.re) * ExtraMath.cosh(complex.im), Math.cos(complex.re) * ExtraMath.sinh(complex.im));
    }

    public static Complex cos(Complex complex) {
        return new Complex(Math.cos(complex.re) * ExtraMath.cosh(complex.im), -Math.sin(complex.re) * ExtraMath.sinh(complex.im));
    }

    public static Complex tan(Complex complex) {
        double d = Math.sin(complex.re);
        double d2 = Math.cos(complex.re);
        double d3 = ExtraMath.sinh(complex.im);
        double d4 = ExtraMath.cosh(complex.im);
        double d5 = d2 * d2 * d4 * d4 + d * d * d3 * d3;
        return new Complex(d * d2 / d5, d3 * d4 / d5);
    }

    public static Complex sinh(Complex complex) {
        return new Complex(ExtraMath.sinh(complex.re) * Math.cos(complex.im), ExtraMath.cosh(complex.re) * Math.sin(complex.im));
    }

    public static Complex cosh(Complex complex) {
        return new Complex(ExtraMath.cosh(complex.re) * Math.cos(complex.im), ExtraMath.sinh(complex.re) * Math.sin(complex.im));
    }

    public static Complex tanh(Complex complex) {
        double d = ExtraMath.sinh(complex.re);
        double d2 = ExtraMath.cosh(complex.re);
        double d3 = Math.sin(complex.im);
        double d4 = Math.cos(complex.im);
        double d5 = d2 * d2 * d4 * d4 + d * d * d3 * d3;
        return new Complex(d * d2 / d5, d3 * d4 / d5);
    }

    public static Complex asin(Complex complex) {
        if (complex.equals(ONE)) {
            return ComplexField.PI_2;
        }
        if (complex.equals(ComplexField.MINUS_ONE)) {
            return ComplexField.MINUS_PI_2;
        }
        double d = 1.0 - complex.re * complex.re + complex.im * complex.im;
        double d2 = -2.0 * complex.re * complex.im;
        return Complex.atan(complex.divide(new Complex(d, d2).sqrt()));
    }

    public static Complex acos(Complex complex) {
        if (complex.equals(ONE)) {
            return ZERO;
        }
        if (complex.equals(ComplexField.MINUS_ONE)) {
            return ComplexField.PI;
        }
        double d = 1.0 - complex.re * complex.re + complex.im * complex.im;
        double d2 = -2.0 * complex.re * complex.im;
        return ComplexField.PI_2.subtract(Complex.atan(complex.divide(new Complex(d, d2).sqrt())));
    }

    public static Complex atan(Complex complex) {
        return ComplexField.MINUS_I.multiply(Complex.atanh(I.multiply(complex)));
    }

    public static Complex asinh(Complex complex) {
        if (complex.equals(I)) {
            return ComplexField.PI_2_I;
        }
        if (complex.equals(ComplexField.MINUS_I)) {
            return ComplexField.MINUS_PI_2_I;
        }
        double d = complex.re * complex.re - complex.im * complex.im + 1.0;
        double d2 = 2.0 * complex.re * complex.im;
        return Complex.log(complex.add(new Complex(d, d2).sqrt()));
    }

    public static Complex acosh(Complex complex) {
        if (complex.equals(ONE)) {
            return ZERO;
        }
        if (complex.equals(ComplexField.MINUS_ONE)) {
            return ComplexField.PI_I;
        }
        double d = complex.re * complex.re - complex.im * complex.im - 1.0;
        double d2 = 2.0 * complex.re * complex.im;
        return Complex.log(complex.add(new Complex(d, d2).sqrt()));
    }

    public static Complex atanh(Complex complex) {
        double d = 1.0 - 2.0 * complex.re + complex.im * complex.im + complex.re * complex.re;
        return Complex.log(new Complex((1.0 - complex.re * complex.re - complex.im * complex.im) / d, 2.0 * complex.im / d)).divide(2.0);
    }
}

