/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.Complex;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleTridiagonalMatrix;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public class ComplexTridiagonalMatrix
extends ComplexSquareMatrix {
    protected static final int TRIDIAGONAL = 3;
    protected static final int storageFormat = 3;

    protected ComplexTridiagonalMatrix() {
    }

    public ComplexTridiagonalMatrix(int n) {
        this();
        this.matrix = new Complex[3][n];
    }

    public ComplexTridiagonalMatrix(Complex[][] complexArray) {
        this(complexArray.length);
        if (complexArray.length == complexArray[0].length) {
            this.matrix[1][0] = complexArray[0][0];
            this.matrix[2][0] = complexArray[0][1];
            int n = 1;
            while (n < complexArray.length - 1) {
                this.matrix[0][n] = complexArray[n][n - 1];
                this.matrix[1][n] = complexArray[n][n];
                this.matrix[2][n] = complexArray[n][n + 1];
                ++n;
            }
            this.matrix[0][n] = complexArray[n][n - 1];
            this.matrix[1][n] = complexArray[n][n];
            return;
        }
        this.matrix = null;
        throw new MatrixDimensionException("The array is not square.");
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ComplexTridiagonalMatrix && this.matrix[1].length == ((ComplexTridiagonalMatrix)object).rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix = (ComplexTridiagonalMatrix)object;
            if (!this.matrix[1][0].equals(complexTridiagonalMatrix.getElement(0, 0))) {
                return false;
            }
            if (!this.matrix[2][0].equals(complexTridiagonalMatrix.getElement(0, 1))) {
                return false;
            }
            int n = 1;
            while (n < this.matrix[1].length - 1) {
                if (!this.matrix[0][n].equals(complexTridiagonalMatrix.getElement(n, n - 1))) {
                    return false;
                }
                if (!this.matrix[1][n].equals(complexTridiagonalMatrix.getElement(n, n))) {
                    return false;
                }
                if (!this.matrix[2][n].equals(complexTridiagonalMatrix.getElement(n, n + 1))) {
                    return false;
                }
                ++n;
            }
            if (!this.matrix[0][n].equals(complexTridiagonalMatrix.getElement(n, n - 1))) {
                return false;
            }
            return this.matrix[1][n].equals(complexTridiagonalMatrix.getElement(n, n));
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.matrix.length * this.matrix[1].length);
        int n = 0;
        while (n < this.rows()) {
            int n2 = 0;
            while (n2 < this.columns()) {
                stringBuffer.append(this.getElement(n, n2).toString());
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public DoubleMatrix real() {
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.matrix[1].length);
        doubleTridiagonalMatrix.matrix[1][0] = this.matrix[1][0].real();
        doubleTridiagonalMatrix.matrix[2][0] = this.matrix[2][0].real();
        int n = 1;
        while (n < this.matrix[1].length - 1) {
            doubleTridiagonalMatrix.matrix[0][n] = this.matrix[0][n].real();
            doubleTridiagonalMatrix.matrix[1][n] = this.matrix[1][n].real();
            doubleTridiagonalMatrix.matrix[2][n] = this.matrix[2][n].real();
            ++n;
        }
        doubleTridiagonalMatrix.matrix[0][n] = this.matrix[0][n].real();
        doubleTridiagonalMatrix.matrix[1][n] = this.matrix[1][n].real();
        return doubleTridiagonalMatrix;
    }

    public DoubleMatrix imag() {
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.matrix[1].length);
        doubleTridiagonalMatrix.matrix[1][0] = this.matrix[1][0].imag();
        doubleTridiagonalMatrix.matrix[2][0] = this.matrix[2][0].imag();
        int n = 1;
        while (n < this.matrix[1].length - 1) {
            doubleTridiagonalMatrix.matrix[0][n] = this.matrix[0][n].imag();
            doubleTridiagonalMatrix.matrix[1][n] = this.matrix[1][n].imag();
            doubleTridiagonalMatrix.matrix[2][n] = this.matrix[2][n].imag();
            ++n;
        }
        doubleTridiagonalMatrix.matrix[0][n] = this.matrix[0][n].imag();
        doubleTridiagonalMatrix.matrix[1][n] = this.matrix[1][n].imag();
        return doubleTridiagonalMatrix;
    }

    public Complex getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix[1].length && n2 >= 0 && n2 < this.matrix[1].length) {
            if (n2 == n - 1) {
                return this.matrix[0][n];
            }
            if (n2 == n) {
                return this.matrix[1][n];
            }
            if (n2 == n + 1) {
                return this.matrix[2][n];
            }
            return Complex.ZERO;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public void setElement(int n, int n2, Complex complex) {
        if (n >= 0 && n < this.matrix[1].length && n2 >= 0 && n2 < this.matrix[1].length) {
            if (n2 == n - 1) {
                this.matrix[0][n] = complex;
                return;
            }
            if (n2 == n) {
                this.matrix[1][n] = complex;
                return;
            }
            if (n2 == n + 1) {
                this.matrix[2][n] = complex;
                return;
            }
            throw new MatrixDimensionException("Invalid element.");
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public Complex trace() {
        double d = this.matrix[0][0].real();
        double d2 = this.matrix[0][0].imag();
        int n = 1;
        while (n < this.matrix[1].length) {
            d += this.matrix[0][n].real();
            d2 += this.matrix[0][n].imag();
            ++n;
        }
        return new Complex(d, d2);
    }

    public double infNorm() {
        double d;
        double d2 = this.matrix[1][0].mod() + this.matrix[2][0].mod();
        int n = 1;
        while (n < this.matrix[1].length - 1) {
            d = this.matrix[0][n].mod() + this.matrix[1][n].mod() + this.matrix[2][n].mod();
            if (d > d2) {
                d2 = d;
            }
            ++n;
        }
        d = this.matrix[0][n].mod() + this.matrix[1][n].mod();
        if (d > d2) {
            d2 = d;
        }
        return d2;
    }

    public double frobeniusNorm() {
        double d = this.matrix[1][0].mod() * this.matrix[1][0].mod() + this.matrix[2][0].mod() * this.matrix[2][0].mod();
        int n = 1;
        while (n < this.matrix[1].length - 1) {
            d += this.matrix[0][n].mod() * this.matrix[0][n].mod() + this.matrix[1][n].mod() * this.matrix[1][n].mod() + this.matrix[2][n].mod() * this.matrix[2][n].mod();
            ++n;
        }
        return Math.sqrt(d += this.matrix[0][n].mod() * this.matrix[0][n].mod() + this.matrix[1][n].mod() * this.matrix[1][n].mod());
    }

    public int rows() {
        return this.matrix[1].length;
    }

    public int columns() {
        return this.matrix[1].length;
    }

    public ComplexMatrix add(ComplexMatrix complexMatrix) {
        if (complexMatrix instanceof ComplexTridiagonalMatrix) {
            return this.add((ComplexTridiagonalMatrix)complexMatrix);
        }
        if (complexMatrix instanceof ComplexSquareMatrix) {
            return this.rawAdd((ComplexSquareMatrix)complexMatrix);
        }
        return this.rawAdd(complexMatrix);
    }

    private ComplexMatrix rawAdd(ComplexMatrix complexMatrix) {
        if (this.matrix[1].length == complexMatrix.rows() && this.matrix[1].length == complexMatrix.columns()) {
            Complex[][] complexArray = new Complex[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = this.getElement(n, 0).add(complexMatrix.getElement(n, 0));
                int n2 = 1;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = this.getElement(n, n2).add(complexMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix complexSquareMatrix) {
        if (complexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.add((ComplexTridiagonalMatrix)complexSquareMatrix);
        }
        return this.rawAdd(complexSquareMatrix);
    }

    private ComplexSquareMatrix rawAdd(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrix[1].length == complexSquareMatrix.rows()) {
            Complex[][] complexArray = new Complex[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = this.getElement(n, 0).add(complexSquareMatrix.getElement(n, 0));
                int n2 = 1;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = this.getElement(n, n2).add(complexSquareMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix add(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.matrix[1].length;
        if (n == complexTridiagonalMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.matrix[1][0] = this.matrix[1][0].add(complexTridiagonalMatrix.getElement(0, 0));
            complexTridiagonalMatrix2.matrix[2][0] = this.matrix[2][0].add(complexTridiagonalMatrix.getElement(0, 1));
            --n;
            int n2 = 1;
            while (n2 < n) {
                complexTridiagonalMatrix2.matrix[0][n2] = this.matrix[0][n2].add(complexTridiagonalMatrix.getElement(n2, n2 - 1));
                complexTridiagonalMatrix2.matrix[1][n2] = this.matrix[1][n2].add(complexTridiagonalMatrix.getElement(n2, n2));
                complexTridiagonalMatrix2.matrix[2][n2] = this.matrix[2][n2].add(complexTridiagonalMatrix.getElement(n2, n2 + 1));
                ++n2;
            }
            complexTridiagonalMatrix2.matrix[0][n] = this.matrix[0][n].add(complexTridiagonalMatrix.getElement(n, n - 1));
            complexTridiagonalMatrix2.matrix[1][n] = this.matrix[1][n].add(complexTridiagonalMatrix.getElement(n, n));
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix subtract(ComplexMatrix complexMatrix) {
        if (complexMatrix instanceof ComplexTridiagonalMatrix) {
            return this.subtract((ComplexTridiagonalMatrix)complexMatrix);
        }
        if (complexMatrix instanceof ComplexSquareMatrix) {
            return this.rawSubtract((ComplexSquareMatrix)complexMatrix);
        }
        return this.rawSubtract(complexMatrix);
    }

    private ComplexMatrix rawSubtract(ComplexMatrix complexMatrix) {
        if (this.matrix[1].length == complexMatrix.rows() && this.matrix[1].length == complexMatrix.columns()) {
            Complex[][] complexArray = new Complex[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = this.getElement(n, 0).subtract(complexMatrix.getElement(n, 0));
                int n2 = 1;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = this.getElement(n, n2).subtract(complexMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix complexSquareMatrix) {
        if (complexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.subtract((ComplexTridiagonalMatrix)complexSquareMatrix);
        }
        return this.rawSubtract(complexSquareMatrix);
    }

    private ComplexSquareMatrix rawSubtract(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrix[1].length == complexSquareMatrix.rows()) {
            Complex[][] complexArray = new Complex[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = this.getElement(n, 0).subtract(complexSquareMatrix.getElement(n, 0));
                int n2 = 1;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = this.getElement(n, n2).subtract(complexSquareMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexTridiagonalMatrix subtract(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.matrix[1].length;
        if (n == complexTridiagonalMatrix.rows()) {
            ComplexTridiagonalMatrix complexTridiagonalMatrix2 = new ComplexTridiagonalMatrix(n);
            complexTridiagonalMatrix2.matrix[1][0] = this.matrix[1][0].subtract(complexTridiagonalMatrix.getElement(0, 0));
            complexTridiagonalMatrix2.matrix[2][0] = this.matrix[2][0].subtract(complexTridiagonalMatrix.getElement(0, 1));
            --n;
            int n2 = 1;
            while (n2 < n) {
                complexTridiagonalMatrix2.matrix[0][n2] = this.matrix[0][n2].subtract(complexTridiagonalMatrix.getElement(n2, n2 - 1));
                complexTridiagonalMatrix2.matrix[1][n2] = this.matrix[1][n2].subtract(complexTridiagonalMatrix.getElement(n2, n2));
                complexTridiagonalMatrix2.matrix[2][n2] = this.matrix[2][n2].subtract(complexTridiagonalMatrix.getElement(n2, n2 + 1));
                ++n2;
            }
            complexTridiagonalMatrix2.matrix[0][n] = this.matrix[0][n].subtract(complexTridiagonalMatrix.getElement(n, n - 1));
            complexTridiagonalMatrix2.matrix[1][n] = this.matrix[1][n].subtract(complexTridiagonalMatrix.getElement(n, n));
            return complexTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix scalarMultiply(Complex complex) {
        int n = this.matrix[1].length;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.matrix[1][0] = complex.multiply(this.matrix[1][0]);
        complexTridiagonalMatrix.matrix[2][0] = complex.multiply(this.matrix[2][0]);
        --n;
        int n2 = 1;
        while (n2 < n) {
            complexTridiagonalMatrix.matrix[0][n2] = complex.multiply(this.matrix[0][n2]);
            complexTridiagonalMatrix.matrix[1][n2] = complex.multiply(this.matrix[1][n2]);
            complexTridiagonalMatrix.matrix[2][n2] = complex.multiply(this.matrix[2][n2]);
            ++n2;
        }
        complexTridiagonalMatrix.matrix[0][n] = complex.multiply(this.matrix[0][n]);
        complexTridiagonalMatrix.matrix[1][n] = complex.multiply(this.matrix[1][n]);
        return complexTridiagonalMatrix;
    }

    public ComplexMatrix scalarMultiply(double d) {
        int n = this.matrix[1].length;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.matrix[1][0] = this.matrix[1][0].multiply(d);
        complexTridiagonalMatrix.matrix[2][0] = this.matrix[2][0].multiply(d);
        --n;
        int n2 = 1;
        while (n2 < n) {
            complexTridiagonalMatrix.matrix[0][n2] = this.matrix[0][n2].multiply(d);
            complexTridiagonalMatrix.matrix[1][n2] = this.matrix[1][n2].multiply(d);
            complexTridiagonalMatrix.matrix[2][n2] = this.matrix[2][n2].multiply(d);
            ++n2;
        }
        complexTridiagonalMatrix.matrix[0][n] = this.matrix[0][n].multiply(d);
        complexTridiagonalMatrix.matrix[1][n] = this.matrix[1][n].multiply(d);
        return complexTridiagonalMatrix;
    }

    public ComplexVector multiply(ComplexVector complexVector) {
        int n = this.matrix[1].length;
        if (n == complexVector.dimension()) {
            Complex[] complexArray = new Complex[n];
            complexArray[0] = this.matrix[1][0].multiply(complexVector.getComponent(0)).add(this.matrix[2][0].multiply(complexVector.getComponent(1)));
            --n;
            int n2 = 1;
            while (n2 < n) {
                complexArray[n2] = this.matrix[0][n2].multiply(complexVector.getComponent(n2 - 1)).add(this.matrix[1][n2].multiply(complexVector.getComponent(n2))).add(this.matrix[2][n2].multiply(complexVector.getComponent(n2 + 1)));
                ++n2;
            }
            complexArray[n] = this.matrix[0][n].multiply(complexVector.getComponent(n - 1)).add(this.matrix[1][n].multiply(complexVector.getComponent(n)));
            return new ComplexVector(complexArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public ComplexMatrix multiply(ComplexMatrix complexMatrix) {
        if (complexMatrix instanceof ComplexTridiagonalMatrix) {
            return this.multiply((ComplexTridiagonalMatrix)complexMatrix);
        }
        if (complexMatrix instanceof ComplexSquareMatrix) {
            return this.rawMultiply((ComplexSquareMatrix)complexMatrix);
        }
        return this.rawMultiply(complexMatrix);
    }

    private ComplexMatrix rawMultiply(ComplexMatrix complexMatrix) {
        if (this.matrix[1].length == complexMatrix.rows()) {
            Complex[][] complexArray = new Complex[this.matrix[1].length][complexMatrix.columns()];
            int n = 0;
            while (n < complexArray.length) {
                int n2 = 0;
                while (n2 < complexArray[0].length) {
                    complexArray[n][n2] = this.getElement(n, 0).multiply(complexMatrix.getElement(0, n2));
                    int n3 = 1;
                    while (n3 < this.matrix[1].length) {
                        complexArray[n][n2] = complexArray[n][n2].add(this.getElement(n, n3).multiply(complexMatrix.getElement(n3, n2)));
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(complexArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix complexSquareMatrix) {
        if (complexSquareMatrix instanceof ComplexTridiagonalMatrix) {
            return this.multiply((ComplexTridiagonalMatrix)complexSquareMatrix);
        }
        return this.rawMultiply(complexSquareMatrix);
    }

    private ComplexSquareMatrix rawMultiply(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrix[1].length == complexSquareMatrix.rows()) {
            Complex[][] complexArray = new Complex[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < complexArray.length) {
                int n2 = 0;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = this.getElement(n, 0).multiply(complexSquareMatrix.getElement(0, n2));
                    int n3 = 1;
                    while (n3 < complexArray.length) {
                        complexArray[n][n2] = complexArray[n][n2].add(this.getElement(n, n3).multiply(complexSquareMatrix.getElement(n3, n2)));
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexSquareMatrix multiply(ComplexTridiagonalMatrix complexTridiagonalMatrix) {
        int n = this.matrix[1].length;
        if (n == complexTridiagonalMatrix.rows()) {
            Complex[][] complexArray = new Complex[n][n];
            complexArray[0][0] = this.matrix[1][0].multiply(complexTridiagonalMatrix.getElement(0, 0)).add(this.matrix[2][0].multiply(complexTridiagonalMatrix.getElement(1, 0)));
            complexArray[0][1] = this.matrix[1][0].multiply(complexTridiagonalMatrix.getElement(0, 1)).add(this.matrix[2][0].multiply(complexTridiagonalMatrix.getElement(1, 1)));
            complexArray[0][2] = this.matrix[2][0].multiply(complexTridiagonalMatrix.getElement(1, 2));
            if (n > 3) {
                complexArray[1][0] = this.matrix[0][1].multiply(complexTridiagonalMatrix.getElement(0, 0)).add(this.matrix[1][1].multiply(complexTridiagonalMatrix.getElement(1, 0)));
                complexArray[1][1] = this.matrix[0][1].multiply(complexTridiagonalMatrix.getElement(0, 1)).add(this.matrix[1][1].multiply(complexTridiagonalMatrix.getElement(1, 1))).add(this.matrix[2][1].multiply(complexTridiagonalMatrix.getElement(2, 1)));
                complexArray[1][2] = this.matrix[1][1].multiply(complexTridiagonalMatrix.getElement(1, 2)).add(this.matrix[2][1].multiply(complexTridiagonalMatrix.getElement(2, 2)));
                complexArray[1][3] = this.matrix[2][1].multiply(complexTridiagonalMatrix.getElement(2, 3));
            }
            if (n == 3) {
                complexArray[1][0] = this.matrix[0][1].multiply(complexTridiagonalMatrix.getElement(0, 0)).add(this.matrix[1][1].multiply(complexTridiagonalMatrix.getElement(1, 0)));
                complexArray[1][1] = this.matrix[0][1].multiply(complexTridiagonalMatrix.getElement(0, 1)).add(this.matrix[1][1].multiply(complexTridiagonalMatrix.getElement(1, 1))).add(this.matrix[2][1].multiply(complexTridiagonalMatrix.getElement(2, 1)));
                complexArray[1][2] = this.matrix[1][1].multiply(complexTridiagonalMatrix.getElement(1, 2)).add(this.matrix[2][1].multiply(complexTridiagonalMatrix.getElement(2, 2)));
            } else if (n > 4) {
                int n2 = 2;
                while (n2 < n - 2) {
                    complexArray[n2][n2 - 2] = this.matrix[0][n2].multiply(complexTridiagonalMatrix.getElement(n2 - 1, n2 - 2));
                    complexArray[n2][n2 - 1] = this.matrix[0][n2].multiply(complexTridiagonalMatrix.getElement(n2 - 1, n2 - 1)).add(this.matrix[1][n2].multiply(complexTridiagonalMatrix.getElement(n2, n2 - 1)));
                    complexArray[n2][n2] = this.matrix[0][n2].multiply(complexTridiagonalMatrix.getElement(n2 - 1, n2)).add(this.matrix[1][n2].multiply(complexTridiagonalMatrix.getElement(n2, n2))).add(this.matrix[2][n2].multiply(complexTridiagonalMatrix.getElement(n2 + 1, n2)));
                    complexArray[n2][n2 + 1] = this.matrix[1][n2].multiply(complexTridiagonalMatrix.getElement(n2, n2 + 1)).add(this.matrix[2][n2].multiply(complexTridiagonalMatrix.getElement(n2 + 1, n2 + 1)));
                    complexArray[n2][n2 + 2] = this.matrix[2][n2].multiply(complexTridiagonalMatrix.getElement(n2 + 1, n2 + 2));
                    ++n2;
                }
            }
            if (n > 3) {
                complexArray[n - 2][n - 4] = this.matrix[0][n - 2].multiply(complexTridiagonalMatrix.getElement(n - 3, n - 4));
                complexArray[n - 2][n - 3] = this.matrix[0][n - 2].multiply(complexTridiagonalMatrix.getElement(n - 3, n - 3)).add(this.matrix[1][n - 2].multiply(complexTridiagonalMatrix.getElement(n - 2, n - 3)));
                complexArray[n - 2][n - 2] = this.matrix[0][n - 2].multiply(complexTridiagonalMatrix.getElement(n - 3, n - 2)).add(this.matrix[1][n - 2].multiply(complexTridiagonalMatrix.getElement(n - 2, n - 2))).add(this.matrix[2][n - 2].multiply(complexTridiagonalMatrix.getElement(n - 1, n - 2)));
                complexArray[n - 2][n - 1] = this.matrix[1][n - 2].multiply(complexTridiagonalMatrix.getElement(n - 2, n - 1)).add(this.matrix[2][n - 2].multiply(complexTridiagonalMatrix.getElement(n - 1, n - 1)));
            }
            complexArray[n][--n - 2] = this.matrix[0][n].multiply(complexTridiagonalMatrix.getElement(n - 1, n - 2));
            complexArray[n][n - 1] = this.matrix[0][n].multiply(complexTridiagonalMatrix.getElement(n - 1, n - 1)).add(this.matrix[1][n].multiply(complexTridiagonalMatrix.getElement(n, n - 1)));
            complexArray[n][n] = this.matrix[0][n].multiply(complexTridiagonalMatrix.getElement(n - 1, n)).add(this.matrix[1][n].multiply(complexTridiagonalMatrix.getElement(n, n)));
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexMatrix hermitianAdjoint() {
        int n = this.matrix[1].length;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.matrix[1][0] = this.matrix[1][0].conjugate();
        complexTridiagonalMatrix.setElement(1, 0, this.matrix[2][0].conjugate());
        --n;
        int n2 = 1;
        while (n2 < n) {
            complexTridiagonalMatrix.setElement(n2 - 1, n2, this.matrix[0][n2].conjugate());
            complexTridiagonalMatrix.matrix[1][n2] = this.matrix[1][n2].conjugate();
            complexTridiagonalMatrix.setElement(n2 + 1, n2, this.matrix[2][n2].conjugate());
            ++n2;
        }
        complexTridiagonalMatrix.setElement(n - 1, n, this.matrix[0][n].conjugate());
        complexTridiagonalMatrix.matrix[1][n] = this.matrix[1][n].conjugate();
        return complexTridiagonalMatrix;
    }

    public ComplexMatrix conjugate() {
        int n = this.matrix[1].length;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.matrix[1][0] = this.matrix[1][0].conjugate();
        complexTridiagonalMatrix.matrix[2][0] = this.matrix[2][0].conjugate();
        --n;
        int n2 = 1;
        while (n2 < n) {
            complexTridiagonalMatrix.matrix[0][n2] = this.matrix[0][n2].conjugate();
            complexTridiagonalMatrix.matrix[1][n2] = this.matrix[1][n2].conjugate();
            complexTridiagonalMatrix.matrix[2][n2] = this.matrix[2][n2].conjugate();
            ++n2;
        }
        complexTridiagonalMatrix.matrix[0][n] = this.matrix[0][n].conjugate();
        complexTridiagonalMatrix.matrix[1][n] = this.matrix[1][n].conjugate();
        return complexTridiagonalMatrix;
    }

    public Matrix transpose() {
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(this.matrix[1].length);
        System.arraycopy(this.matrix[0], 1, complexTridiagonalMatrix.matrix[2], 0, this.matrix[0].length - 1);
        System.arraycopy(this.matrix[1], 0, complexTridiagonalMatrix.matrix[1], 0, this.matrix[1].length);
        System.arraycopy(this.matrix[2], 0, complexTridiagonalMatrix.matrix[0], 1, this.matrix[2].length - 1);
        return complexTridiagonalMatrix;
    }

    public ComplexSquareMatrix[] luDecompose() {
        Complex[][][] complexArray = new Complex[2][this.matrix[1].length][this.matrix[1].length];
        complexArray[0][0][0] = Complex.ONE;
        int n = 1;
        while (n < this.matrix[1].length) {
            complexArray[0][n][n] = Complex.ONE;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.matrix[1].length) {
            int n3;
            Complex complex;
            n = 0;
            while (n <= n2) {
                complex = this.getElement(n, n2);
                n3 = 0;
                while (n3 < n) {
                    complex = complex.subtract(complexArray[0][n][n3].multiply(complexArray[1][n3][n2]));
                    ++n3;
                }
                complexArray[1][n][n2] = complex;
                ++n;
            }
            n = n2 + 1;
            while (n < this.matrix[1].length) {
                complex = this.getElement(n, n2);
                n3 = 0;
                while (n3 < n2) {
                    complex = complex.subtract(complexArray[0][n][n3].multiply(complexArray[1][n3][n2]));
                    ++n3;
                }
                complexArray[0][n][n2] = complex.divide(complexArray[1][n2][n2]);
                ++n;
            }
            ++n2;
        }
        ComplexSquareMatrix[] complexSquareMatrixArray = new ComplexSquareMatrix[]{new ComplexSquareMatrix(complexArray[0]), new ComplexSquareMatrix(complexArray[1])};
        return complexSquareMatrixArray;
    }

    public ComplexMatrix mapElements(Mapping mapping) {
        int n = this.matrix[1].length;
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(n);
        complexTridiagonalMatrix.matrix[1][0] = mapping.map(this.matrix[1][0]);
        complexTridiagonalMatrix.matrix[2][0] = mapping.map(this.matrix[2][0]);
        --n;
        int n2 = 1;
        while (n2 < n) {
            complexTridiagonalMatrix.matrix[0][n2] = mapping.map(this.matrix[0][n2]);
            complexTridiagonalMatrix.matrix[1][n2] = mapping.map(this.matrix[1][n2]);
            complexTridiagonalMatrix.matrix[2][n2] = mapping.map(this.matrix[2][n2]);
            ++n2;
        }
        complexTridiagonalMatrix.matrix[0][n] = mapping.map(this.matrix[0][n]);
        complexTridiagonalMatrix.matrix[1][n] = mapping.map(this.matrix[1][n]);
        return complexTridiagonalMatrix;
    }
}

