/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.AlgebraMember;
import JSci.maths.Complex;
import JSci.maths.ComplexMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.IntegerMatrix;
import JSci.maths.Mapping;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.RingMember;
import JSci.maths.groups.AbelianGroupMember;

public class DoubleMatrix
extends Matrix {
    protected static final int ARRAY_2D = 1;
    protected static final int storageFormat = 1;
    protected double[][] matrix;

    protected DoubleMatrix() {
    }

    public DoubleMatrix(int n, int n2) {
        this();
        this.matrix = new double[n][n2];
    }

    public DoubleMatrix(double[][] dArray) {
        this();
        this.matrix = dArray;
    }

    public DoubleMatrix(DoubleVector[] doubleVectorArray) {
        this(doubleVectorArray[0].dimension(), doubleVectorArray.length);
        int n = 0;
        while (n < this.matrix.length) {
            int n2 = 0;
            while (n2 < this.matrix[0].length) {
                this.matrix[n][n2] = doubleVectorArray[n2].getComponent(n);
                ++n2;
            }
            ++n;
        }
    }

    protected void finalize() throws Throwable {
        this.matrix = null;
        super.finalize();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DoubleMatrix && this.matrix.length == ((DoubleMatrix)object).rows() && this.matrix[0].length == ((DoubleMatrix)object).columns()) {
            DoubleMatrix doubleMatrix = (DoubleMatrix)object;
            int n = 0;
            while (n < this.matrix.length) {
                int n2 = 0;
                while (n2 < this.matrix[0].length) {
                    if (Math.abs(this.matrix[n][n2] - doubleMatrix.getElement(n, n2)) > GlobalSettings.ZERO_TOL) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.matrix.length * this.matrix[0].length);
        int n = 0;
        while (n < this.matrix.length) {
            int n2 = 0;
            while (n2 < this.matrix[0].length) {
                stringBuffer.append(this.matrix[n][n2]);
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public IntegerMatrix toIntegerMatrix() {
        int[][] nArray = new int[this.matrix.length][this.matrix[0].length];
        int n = 0;
        while (n < this.matrix.length) {
            int n2 = 0;
            while (n2 < this.matrix[0].length) {
                nArray[n][n2] = Math.round((float)this.matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new IntegerMatrix(nArray);
    }

    public ComplexMatrix toComplexMatrix() {
        Complex[][] complexArray = new Complex[this.matrix.length][this.matrix[0].length];
        int n = 0;
        while (n < this.matrix.length) {
            int n2 = 0;
            while (n2 < this.matrix[0].length) {
                complexArray[n][n2] = new Complex(this.matrix[n][n2], 0.0);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(complexArray);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix.length && n2 >= 0 && n2 < this.matrix[0].length) {
            return this.matrix[n][n2];
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public void setElement(int n, int n2, double d) {
        if (n >= 0 && n < this.matrix.length && n2 >= 0 && n2 < this.matrix[0].length) {
            this.matrix[n][n2] = d;
            return;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public double infNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.matrix.length) {
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.matrix[0].length) {
                d2 += Math.abs(this.matrix[n][n2]);
                ++n2;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.matrix.length) {
            int n2 = 0;
            while (n2 < this.matrix[0].length) {
                d += this.matrix[n][n2] * this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return Math.sqrt(d);
    }

    public int rows() {
        return this.matrix.length;
    }

    public int columns() {
        return this.matrix[0].length;
    }

    public AbelianGroupMember negate() {
        double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n][0] = -this.matrix[n][0];
            int n2 = 1;
            while (n2 < dArray[0].length) {
                dArray[n][n2] = -this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public AbelianGroupMember add(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof DoubleMatrix) {
            return this.add((DoubleMatrix)abelianGroupMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        switch (1) {
            case 1: {
                return this.rawAdd(doubleMatrix);
            }
        }
        if (this.matrix.length == doubleMatrix.rows() && this.matrix[0].length == doubleMatrix.columns()) {
            double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[n][0] + doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.matrix[n][n2] + doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleMatrix rawAdd(DoubleMatrix doubleMatrix) {
        if (this.matrix.length == doubleMatrix.matrix.length && this.matrix[0].length == doubleMatrix.matrix[0].length) {
            double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[n][0] + doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.matrix[n][n2] + doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbelianGroupMember subtract(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof DoubleMatrix) {
            return this.subtract((DoubleMatrix)abelianGroupMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        switch (1) {
            case 1: {
                return this.rawSubtract(doubleMatrix);
            }
        }
        if (this.matrix.length == doubleMatrix.rows() && this.matrix[0].length == doubleMatrix.columns()) {
            double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[n][0] - doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.matrix[n][n2] - doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleMatrix rawSubtract(DoubleMatrix doubleMatrix) {
        if (this.matrix.length == doubleMatrix.matrix.length && this.matrix[0].length == doubleMatrix.matrix[0].length) {
            double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[n][0] - doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.matrix[n][n2] - doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AlgebraMember scalarMultiply(RingMember ringMember) {
        if (ringMember instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)ringMember).value());
        }
        if (ringMember instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)ringMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public DoubleMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n][0] = d * this.matrix[n][0];
            int n2 = 1;
            while (n2 < dArray[0].length) {
                dArray[n][n2] = d * this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public DoubleVector multiply(DoubleVector doubleVector) {
        if (this.matrix[0].length == doubleVector.dimension()) {
            double[] dArray = new double[this.matrix.length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n] = this.matrix[n][0] * doubleVector.getComponent(0);
                int n2 = 1;
                while (n2 < this.matrix[0].length) {
                    int n3 = n;
                    dArray[n3] = dArray[n3] + this.matrix[n][n2] * doubleVector.getComponent(n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public RingMember multiply(RingMember ringMember) {
        if (ringMember instanceof DoubleMatrix) {
            return this.multiply((DoubleMatrix)ringMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public DoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        switch (1) {
            case 1: {
                return this.rawMultiply(doubleMatrix);
            }
        }
        if (this.matrix[0].length == doubleMatrix.rows()) {
            double[][] dArray = new double[this.matrix.length][doubleMatrix.columns()];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.matrix[n][0] * doubleMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < this.matrix[0].length) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.matrix[n][n3] * doubleMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (dArray.length == dArray[0].length) {
                return new DoubleSquareMatrix(dArray);
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleMatrix rawMultiply(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.matrix.length) {
            double[][] dArray = new double[this.matrix.length][doubleMatrix.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.matrix[n][0] * doubleMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < this.matrix[0].length) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.matrix[n][n3] * doubleMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (dArray.length == dArray[0].length) {
                return new DoubleSquareMatrix(dArray);
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.matrix[0].length][this.matrix.length];
        int n = 0;
        while (n < dArray[0].length) {
            dArray[0][n] = this.matrix[n][0];
            int n2 = 1;
            while (n2 < dArray.length) {
                dArray[n2][n] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public DoubleMatrix mapElements(Mapping mapping) {
        double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n][0] = mapping.map(this.matrix[n][0]);
            int n2 = 1;
            while (n2 < dArray[0].length) {
                dArray[n][n2] = mapping.map(this.matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }
}

