/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.Complex;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexTridiagonalMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleTridiagonalMatrix;
import JSci.maths.IntegerMatrix;
import JSci.maths.IntegerSquareMatrix;
import JSci.maths.IntegerVector;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public class IntegerTridiagonalMatrix
extends IntegerSquareMatrix {
    protected static final int TRIDIAGONAL = 3;
    protected static final int storageFormat = 3;

    protected IntegerTridiagonalMatrix() {
    }

    public IntegerTridiagonalMatrix(int n) {
        this();
        this.matrix = new int[3][n];
    }

    public IntegerTridiagonalMatrix(int[][] nArray) {
        this(nArray.length);
        if (nArray.length == nArray[0].length) {
            this.matrix[1][0] = nArray[0][0];
            this.matrix[2][0] = nArray[0][1];
            int n = 1;
            while (n < nArray.length - 1) {
                this.matrix[0][n] = nArray[n][n - 1];
                this.matrix[1][n] = nArray[n][n];
                this.matrix[2][n] = nArray[n][n + 1];
                ++n;
            }
            this.matrix[0][n] = nArray[n][n - 1];
            this.matrix[1][n] = nArray[n][n];
            return;
        }
        this.matrix = null;
        throw new MatrixDimensionException("The array is not square.");
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof IntegerTridiagonalMatrix && this.matrix[1].length == ((IntegerTridiagonalMatrix)object).rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix = (IntegerTridiagonalMatrix)object;
            if (this.matrix[1][0] != integerTridiagonalMatrix.getElement(0, 0)) {
                return false;
            }
            if (this.matrix[2][0] != integerTridiagonalMatrix.getElement(0, 1)) {
                return false;
            }
            int n = 1;
            while (n < this.matrix[1].length - 1) {
                if (this.matrix[0][n] != integerTridiagonalMatrix.getElement(n, n - 1)) {
                    return false;
                }
                if (this.matrix[1][n] != integerTridiagonalMatrix.getElement(n, n)) {
                    return false;
                }
                if (this.matrix[2][n] != integerTridiagonalMatrix.getElement(n, n + 1)) {
                    return false;
                }
                ++n;
            }
            if (this.matrix[0][n] != integerTridiagonalMatrix.getElement(n, n - 1)) {
                return false;
            }
            return this.matrix[1][n] == integerTridiagonalMatrix.getElement(n, n);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.matrix.length * this.matrix[1].length);
        int n = 0;
        while (n < this.rows()) {
            int n2 = 0;
            while (n2 < this.columns()) {
                stringBuffer.append(this.getElement(n, n2));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public DoubleMatrix toDoubleMatrix() {
        DoubleTridiagonalMatrix doubleTridiagonalMatrix = new DoubleTridiagonalMatrix(this.matrix[1].length);
        doubleTridiagonalMatrix.matrix[1][0] = this.matrix[1][0];
        doubleTridiagonalMatrix.matrix[2][0] = this.matrix[2][0];
        int n = 1;
        while (n < this.matrix[1].length - 1) {
            doubleTridiagonalMatrix.matrix[0][n] = this.matrix[0][n];
            doubleTridiagonalMatrix.matrix[1][n] = this.matrix[1][n];
            doubleTridiagonalMatrix.matrix[2][n] = this.matrix[2][n];
            ++n;
        }
        doubleTridiagonalMatrix.matrix[0][n] = this.matrix[0][n];
        doubleTridiagonalMatrix.matrix[1][n] = this.matrix[1][n];
        return doubleTridiagonalMatrix;
    }

    public ComplexMatrix toComplexMatrix() {
        ComplexTridiagonalMatrix complexTridiagonalMatrix = new ComplexTridiagonalMatrix(this.matrix[1].length);
        complexTridiagonalMatrix.matrix[1][0] = new Complex(this.matrix[1][0], 0.0);
        complexTridiagonalMatrix.matrix[2][0] = new Complex(this.matrix[2][0], 0.0);
        int n = 1;
        while (n < this.matrix[1].length - 1) {
            complexTridiagonalMatrix.matrix[0][n] = new Complex(this.matrix[0][n], 0.0);
            complexTridiagonalMatrix.matrix[1][n] = new Complex(this.matrix[1][n], 0.0);
            complexTridiagonalMatrix.matrix[2][n] = new Complex(this.matrix[2][n], 0.0);
            ++n;
        }
        complexTridiagonalMatrix.matrix[0][n] = new Complex(this.matrix[0][n], 0.0);
        complexTridiagonalMatrix.matrix[1][n] = new Complex(this.matrix[1][n], 0.0);
        return complexTridiagonalMatrix;
    }

    public int getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix[1].length && n2 >= 0 && n2 < this.matrix[1].length) {
            if (n2 == n - 1) {
                return this.matrix[0][n];
            }
            if (n2 == n) {
                return this.matrix[1][n];
            }
            if (n2 == n + 1) {
                return this.matrix[2][n];
            }
            return 0;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public void setElement(int n, int n2, int n3) {
        if (n >= 0 && n < this.matrix[1].length && n2 >= 0 && n2 < this.matrix[1].length) {
            if (n2 == n - 1) {
                this.matrix[0][n] = n3;
                return;
            }
            if (n2 == n) {
                this.matrix[1][n] = n3;
                return;
            }
            if (n2 == n + 1) {
                this.matrix[2][n] = n3;
                return;
            }
            throw new MatrixDimensionException("Invalid element.");
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public boolean isSymmetric() {
        if (this.matrix[0][1] != this.matrix[2][0]) {
            return false;
        }
        int n = 1;
        while (n < this.matrix[1].length - 1) {
            if (this.matrix[0][n + 1] != this.matrix[2][n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int trace() {
        int n = this.matrix[1][0];
        int n2 = 1;
        while (n2 < this.matrix[1].length) {
            n += this.matrix[1][n2];
            ++n2;
        }
        return n;
    }

    public int infNorm() {
        int n;
        int n2 = Math.abs(this.matrix[1][0]) + Math.abs(this.matrix[2][0]);
        int n3 = 1;
        while (n3 < this.matrix[1].length - 1) {
            n = Math.abs(this.matrix[0][n3]) + Math.abs(this.matrix[1][n3]) + Math.abs(this.matrix[2][n3]);
            if (n > n2) {
                n2 = n;
            }
            ++n3;
        }
        n = Math.abs(this.matrix[0][n3]) + Math.abs(this.matrix[1][n3]);
        if (n > n2) {
            n2 = n;
        }
        return n2;
    }

    public double frobeniusNorm() {
        int n = this.matrix[1][0] * this.matrix[1][0] + this.matrix[2][0] * this.matrix[2][0];
        int n2 = 1;
        while (n2 < this.matrix[1].length - 1) {
            n += this.matrix[0][n2] * this.matrix[0][n2] + this.matrix[1][n2] * this.matrix[1][n2] + this.matrix[2][n2] * this.matrix[2][n2];
            ++n2;
        }
        return Math.sqrt(n += this.matrix[0][n2] * this.matrix[0][n2] + this.matrix[1][n2] * this.matrix[1][n2]);
    }

    public int rows() {
        return this.matrix[1].length;
    }

    public int columns() {
        return this.matrix[1].length;
    }

    public IntegerMatrix add(IntegerMatrix integerMatrix) {
        if (integerMatrix instanceof IntegerTridiagonalMatrix) {
            return this.add((IntegerTridiagonalMatrix)integerMatrix);
        }
        if (integerMatrix instanceof IntegerSquareMatrix) {
            return this.rawAdd((IntegerSquareMatrix)integerMatrix);
        }
        return this.rawAdd(integerMatrix);
    }

    private IntegerMatrix rawAdd(IntegerMatrix integerMatrix) {
        if (this.matrix[1].length == integerMatrix.rows() && this.matrix[1].length == integerMatrix.columns()) {
            int[][] nArray = new int[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.getElement(n, 0) + integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = this.getElement(n, n2) + integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix add(IntegerSquareMatrix integerSquareMatrix) {
        if (integerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.add((IntegerTridiagonalMatrix)integerSquareMatrix);
        }
        return this.rawAdd(integerSquareMatrix);
    }

    private IntegerSquareMatrix rawAdd(IntegerSquareMatrix integerSquareMatrix) {
        if (this.matrix[1].length == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.getElement(n, 0) + integerSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = this.getElement(n, n2) + integerSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix add(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        int n = this.matrix[1].length;
        if (n == integerTridiagonalMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.matrix[1][0] = this.matrix[1][0] + integerTridiagonalMatrix.getElement(0, 0);
            integerTridiagonalMatrix2.matrix[2][0] = this.matrix[2][0] + integerTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix2.matrix[0][n2] = this.matrix[0][n2] + integerTridiagonalMatrix.getElement(n2, n2 - 1);
                integerTridiagonalMatrix2.matrix[1][n2] = this.matrix[1][n2] + integerTridiagonalMatrix.getElement(n2, n2);
                integerTridiagonalMatrix2.matrix[2][n2] = this.matrix[2][n2] + integerTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            integerTridiagonalMatrix2.matrix[0][n] = this.matrix[0][n] + integerTridiagonalMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix2.matrix[1][n] = this.matrix[1][n] + integerTridiagonalMatrix.getElement(n, n);
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerMatrix subtract(IntegerMatrix integerMatrix) {
        if (integerMatrix instanceof IntegerTridiagonalMatrix) {
            return this.subtract((IntegerTridiagonalMatrix)integerMatrix);
        }
        if (integerMatrix instanceof IntegerSquareMatrix) {
            return this.rawSubtract((IntegerSquareMatrix)integerMatrix);
        }
        return this.rawSubtract(integerMatrix);
    }

    private IntegerMatrix rawSubtract(IntegerMatrix integerMatrix) {
        if (this.matrix[1].length == integerMatrix.rows() && this.matrix[1].length == integerMatrix.columns()) {
            int[][] nArray = new int[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.getElement(n, 0) - integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = this.getElement(n, n2) - integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix subtract(IntegerSquareMatrix integerSquareMatrix) {
        if (integerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.subtract((IntegerTridiagonalMatrix)integerSquareMatrix);
        }
        return this.rawSubtract(integerSquareMatrix);
    }

    private IntegerSquareMatrix rawSubtract(IntegerSquareMatrix integerSquareMatrix) {
        if (this.matrix[1].length == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.getElement(n, 0) - integerSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = this.getElement(n, n2) - integerSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix subtract(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        int n = this.matrix[1].length;
        if (n == integerTridiagonalMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.matrix[1][0] = this.matrix[1][0] - integerTridiagonalMatrix.getElement(0, 0);
            integerTridiagonalMatrix2.matrix[2][0] = this.matrix[2][0] - integerTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix2.matrix[0][n2] = this.matrix[0][n2] - integerTridiagonalMatrix.getElement(n2, n2 - 1);
                integerTridiagonalMatrix2.matrix[1][n2] = this.matrix[1][n2] - integerTridiagonalMatrix.getElement(n2, n2);
                integerTridiagonalMatrix2.matrix[2][n2] = this.matrix[2][n2] - integerTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            integerTridiagonalMatrix2.matrix[0][n] = this.matrix[0][n] - integerTridiagonalMatrix.getElement(n, n - 1);
            integerTridiagonalMatrix2.matrix[1][n] = this.matrix[1][n] - integerTridiagonalMatrix.getElement(n, n);
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerMatrix scalarMultiply(int n) {
        int n2 = this.matrix[1].length;
        IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(n2);
        integerTridiagonalMatrix.matrix[1][0] = n * this.matrix[1][0];
        integerTridiagonalMatrix.matrix[2][0] = n * this.matrix[2][0];
        --n2;
        int n3 = 1;
        while (n3 < n2) {
            integerTridiagonalMatrix.matrix[0][n3] = n * this.matrix[0][n3];
            integerTridiagonalMatrix.matrix[1][n3] = n * this.matrix[1][n3];
            integerTridiagonalMatrix.matrix[2][n3] = n * this.matrix[2][n3];
            ++n3;
        }
        integerTridiagonalMatrix.matrix[0][n2] = n * this.matrix[0][n2];
        integerTridiagonalMatrix.matrix[0][n2] = n * this.matrix[1][n2];
        return integerTridiagonalMatrix;
    }

    public IntegerVector multiply(IntegerVector integerVector) {
        int n = this.matrix[1].length;
        if (n == integerVector.dimension()) {
            int[] nArray = new int[n];
            nArray[0] = this.matrix[1][0] * integerVector.getComponent(0) + this.matrix[2][0] * integerVector.getComponent(1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                nArray[n2] = this.matrix[0][n2] * integerVector.getComponent(n2 - 1) + this.matrix[1][n2] * integerVector.getComponent(n2) + this.matrix[2][n2] * integerVector.getComponent(n2 + 1);
                ++n2;
            }
            nArray[n] = this.matrix[0][n] * integerVector.getComponent(n - 1) + this.matrix[1][n] * integerVector.getComponent(n);
            return new IntegerVector(nArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public IntegerMatrix multiply(IntegerMatrix integerMatrix) {
        if (integerMatrix instanceof IntegerTridiagonalMatrix) {
            return this.multiply((IntegerTridiagonalMatrix)integerMatrix);
        }
        if (integerMatrix instanceof IntegerSquareMatrix) {
            return this.rawMultiply((IntegerSquareMatrix)integerMatrix);
        }
        return this.rawMultiply(integerMatrix);
    }

    private IntegerMatrix rawMultiply(IntegerMatrix integerMatrix) {
        if (this.matrix[1].length == integerMatrix.rows()) {
            int[][] nArray = new int[this.matrix[1].length][integerMatrix.columns()];
            int n = 0;
            while (n < nArray.length) {
                int n2 = 0;
                while (n2 < nArray[0].length) {
                    nArray[n][n2] = this.getElement(n, 0) * integerMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < this.matrix[1].length) {
                        int[] nArray2 = nArray[n];
                        int n4 = n2;
                        nArray2[n4] = nArray2[n4] + this.getElement(n, n3) * integerMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerSquareMatrix multiply(IntegerSquareMatrix integerSquareMatrix) {
        if (integerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.multiply((IntegerTridiagonalMatrix)integerSquareMatrix);
        }
        return this.rawMultiply(integerSquareMatrix);
    }

    private IntegerSquareMatrix rawMultiply(IntegerSquareMatrix integerSquareMatrix) {
        if (this.matrix[1].length == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.matrix[1].length][this.matrix[1].length];
            int n = 0;
            while (n < nArray.length) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    nArray[n][n2] = this.getElement(n, 0) * integerSquareMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < nArray.length) {
                        int[] nArray2 = nArray[n];
                        int n4 = n2;
                        nArray2[n4] = nArray2[n4] + this.getElement(n, n3) * integerSquareMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerSquareMatrix multiply(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        int n = this.matrix[1].length;
        if (n == integerTridiagonalMatrix.rows()) {
            int[][] nArray = new int[n][n];
            nArray[0][0] = this.matrix[1][0] * integerTridiagonalMatrix.getElement(0, 0) + this.matrix[2][0] * integerTridiagonalMatrix.getElement(1, 0);
            nArray[0][1] = this.matrix[1][0] * integerTridiagonalMatrix.getElement(0, 1) + this.matrix[2][0] * integerTridiagonalMatrix.getElement(1, 1);
            nArray[0][2] = this.matrix[2][0] * integerTridiagonalMatrix.getElement(1, 2);
            if (n > 3) {
                nArray[1][0] = this.matrix[0][1] * integerTridiagonalMatrix.getElement(0, 0) + this.matrix[1][1] * integerTridiagonalMatrix.getElement(1, 0);
                nArray[1][1] = this.matrix[0][1] * integerTridiagonalMatrix.getElement(0, 1) + this.matrix[1][1] * integerTridiagonalMatrix.getElement(1, 1) + this.matrix[2][1] * integerTridiagonalMatrix.getElement(2, 1);
                nArray[1][2] = this.matrix[1][1] * integerTridiagonalMatrix.getElement(1, 2) + this.matrix[2][1] * integerTridiagonalMatrix.getElement(2, 2);
                nArray[1][3] = this.matrix[2][1] * integerTridiagonalMatrix.getElement(2, 3);
            }
            if (n == 3) {
                nArray[1][0] = this.matrix[0][1] * integerTridiagonalMatrix.getElement(0, 0) + this.matrix[1][1] * integerTridiagonalMatrix.getElement(1, 0);
                nArray[1][1] = this.matrix[0][1] * integerTridiagonalMatrix.getElement(0, 1) + this.matrix[1][1] * integerTridiagonalMatrix.getElement(1, 1) + this.matrix[2][1] * integerTridiagonalMatrix.getElement(2, 1);
                nArray[1][2] = this.matrix[1][1] * integerTridiagonalMatrix.getElement(1, 2) + this.matrix[2][1] * integerTridiagonalMatrix.getElement(2, 2);
            } else if (n > 4) {
                int n2 = 2;
                while (n2 < n - 2) {
                    nArray[n2][n2 - 2] = this.matrix[0][n2] * integerTridiagonalMatrix.getElement(n2 - 1, n2 - 2);
                    nArray[n2][n2 - 1] = this.matrix[0][n2] * integerTridiagonalMatrix.getElement(n2 - 1, n2 - 1) + this.matrix[1][n2] * integerTridiagonalMatrix.getElement(n2, n2 - 1);
                    nArray[n2][n2] = this.matrix[0][n2] * integerTridiagonalMatrix.getElement(n2 - 1, n2) + this.matrix[1][n2] * integerTridiagonalMatrix.getElement(n2, n2) + this.matrix[2][n2] * integerTridiagonalMatrix.getElement(n2 + 1, n2);
                    nArray[n2][n2 + 1] = this.matrix[1][n2] * integerTridiagonalMatrix.getElement(n2, n2 + 1) + this.matrix[2][n2] * integerTridiagonalMatrix.getElement(n2 + 1, n2 + 1);
                    nArray[n2][n2 + 2] = this.matrix[2][n2] * integerTridiagonalMatrix.getElement(n2 + 1, n2 + 2);
                    ++n2;
                }
            }
            if (n > 3) {
                nArray[n - 2][n - 4] = this.matrix[0][n - 2] * integerTridiagonalMatrix.getElement(n - 3, n - 4);
                nArray[n - 2][n - 3] = this.matrix[0][n - 2] * integerTridiagonalMatrix.getElement(n - 3, n - 3) + this.matrix[1][n - 2] * integerTridiagonalMatrix.getElement(n - 2, n - 3);
                nArray[n - 2][n - 2] = this.matrix[0][n - 2] * integerTridiagonalMatrix.getElement(n - 3, n - 2) + this.matrix[1][n - 2] * integerTridiagonalMatrix.getElement(n - 2, n - 2) + this.matrix[2][n - 2] * integerTridiagonalMatrix.getElement(n - 1, n - 2);
                nArray[n - 2][n - 1] = this.matrix[1][n - 2] * integerTridiagonalMatrix.getElement(n - 2, n - 1) + this.matrix[2][n - 2] * integerTridiagonalMatrix.getElement(n - 1, n - 1);
            }
            nArray[n][--n - 2] = this.matrix[0][n] * integerTridiagonalMatrix.getElement(n - 1, n - 2);
            nArray[n][n - 1] = this.matrix[0][n] * integerTridiagonalMatrix.getElement(n - 1, n - 1) + this.matrix[1][n] * integerTridiagonalMatrix.getElement(n, n - 1);
            nArray[n][n] = this.matrix[0][n] * integerTridiagonalMatrix.getElement(n - 1, n) + this.matrix[1][n] * integerTridiagonalMatrix.getElement(n, n);
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        IntegerTridiagonalMatrix integerTridiagonalMatrix = new IntegerTridiagonalMatrix(this.matrix[1].length);
        System.arraycopy(this.matrix[0], 1, integerTridiagonalMatrix.matrix[2], 0, this.matrix[0].length - 1);
        System.arraycopy(this.matrix[1], 0, integerTridiagonalMatrix.matrix[1], 0, this.matrix[1].length);
        System.arraycopy(this.matrix[2], 0, integerTridiagonalMatrix.matrix[0], 1, this.matrix[2].length - 1);
        return integerTridiagonalMatrix;
    }

    public DoubleSquareMatrix[] luDecompose() {
        double[][][] dArray = new double[2][this.matrix[1].length][this.matrix[1].length];
        dArray[0][0][0] = 1.0;
        int n = 1;
        while (n < this.matrix[1].length) {
            dArray[0][n][n] = 1.0;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.matrix[1].length) {
            int n3;
            double d;
            n = 0;
            while (n <= n2) {
                d = this.getElement(n, n2);
                n3 = 0;
                while (n3 < n) {
                    d -= dArray[0][n][n3] * dArray[1][n3][n2];
                    ++n3;
                }
                dArray[1][n][n2] = d;
                ++n;
            }
            n = n2 + 1;
            while (n < this.matrix[1].length) {
                d = this.getElement(n, n2);
                n3 = 0;
                while (n3 < n2) {
                    d -= dArray[0][n][n3] * dArray[1][n3][n2];
                    ++n3;
                }
                dArray[0][n][n2] = d / dArray[1][n2][n2];
                ++n;
            }
            ++n2;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray[0]), new DoubleSquareMatrix(dArray[1])};
        return doubleSquareMatrixArray;
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        double[][][] dArray = new double[2][this.matrix[1].length][this.matrix[1].length];
        double d = Math.sqrt(this.getElement(0, 0));
        dArray[1][0][0] = d;
        dArray[0][0][0] = d;
        int n = 1;
        while (n < this.matrix[1].length) {
            double d2 = (double)this.getElement(n, 0) / dArray[0][0][0];
            dArray[1][0][n] = d2;
            dArray[0][n][0] = d2;
            ++n;
        }
        int n2 = 1;
        while (n2 < this.matrix[1].length) {
            double d3 = this.getElement(n2, n2);
            n = 0;
            while (n < n2) {
                d3 -= dArray[0][n2][n] * dArray[0][n2][n];
                ++n;
            }
            double d4 = Math.sqrt(d3);
            dArray[1][n2][n2] = d4;
            dArray[0][n2][n2] = d4;
            n = n2 + 1;
            while (n < this.matrix[1].length) {
                d3 = this.getElement(n, n2);
                int n3 = 0;
                while (n3 < n) {
                    d3 -= dArray[0][n2][n3] * dArray[1][n3][n];
                    ++n3;
                }
                double d5 = d3 / dArray[1][n2][n2];
                dArray[1][n2][n] = d5;
                dArray[0][n][n2] = d5;
                ++n;
            }
            ++n2;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray[0]), new DoubleSquareMatrix(dArray[1])};
        return doubleSquareMatrixArray;
    }
}

