/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.algebras;

import JSci.maths.Complex;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.algebras.LieAlgebra;
import JSci.maths.fields.ComplexField;

public final class su3Dim3
extends LieAlgebra {
    private static final Complex T8_1 = new Complex(0.5 / Math.sqrt(3.0), 0.0);
    private static final Complex T8_2 = new Complex(-1.0 / Math.sqrt(3.0), 0.0);
    private static final Complex[][] t1 = new Complex[][]{{Complex.ZERO, ComplexField.HALF, Complex.ZERO}, {ComplexField.HALF, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO}};
    private static final Complex[][] t2 = new Complex[][]{{Complex.ZERO, ComplexField.MINUS_HALF_I, Complex.ZERO}, {ComplexField.HALF_I, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO}};
    private static final Complex[][] t3 = new Complex[][]{{ComplexField.HALF, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, ComplexField.MINUS_HALF, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO}};
    private static final Complex[][] t4 = new Complex[][]{{Complex.ZERO, Complex.ZERO, ComplexField.HALF}, {Complex.ZERO, Complex.ZERO, Complex.ZERO}, {ComplexField.HALF, Complex.ZERO, Complex.ZERO}};
    private static final Complex[][] t5 = new Complex[][]{{Complex.ZERO, Complex.ZERO, ComplexField.MINUS_HALF_I}, {Complex.ZERO, Complex.ZERO, Complex.ZERO}, {ComplexField.HALF_I, Complex.ZERO, Complex.ZERO}};
    private static final Complex[][] t6 = new Complex[][]{{Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, ComplexField.HALF}, {Complex.ZERO, ComplexField.HALF, Complex.ZERO}};
    private static final Complex[][] t7 = new Complex[][]{{Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, ComplexField.MINUS_HALF_I}, {Complex.ZERO, ComplexField.HALF_I, Complex.ZERO}};
    private static final Complex[][] t8 = new Complex[][]{{T8_1, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, T8_1, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, T8_2}};
    private static final ComplexSquareMatrix[] basisMatrices = new ComplexSquareMatrix[]{new ComplexSquareMatrix(t1), new ComplexSquareMatrix(t2), new ComplexSquareMatrix(t3), new ComplexSquareMatrix(t4), new ComplexSquareMatrix(t5), new ComplexSquareMatrix(t6), new ComplexSquareMatrix(t7), new ComplexSquareMatrix(t8)};

    public su3Dim3() {
        super("su(3) [3]");
    }

    public ComplexSquareMatrix getElement(DoubleVector doubleVector) {
        ComplexMatrix complexMatrix = basisMatrices[0].scalarMultiply(doubleVector.getComponent(0));
        complexMatrix = complexMatrix.add(basisMatrices[1].scalarMultiply(doubleVector.getComponent(1)));
        complexMatrix = complexMatrix.add(basisMatrices[2].scalarMultiply(doubleVector.getComponent(2)));
        complexMatrix = complexMatrix.add(basisMatrices[3].scalarMultiply(doubleVector.getComponent(3)));
        complexMatrix = complexMatrix.add(basisMatrices[4].scalarMultiply(doubleVector.getComponent(4)));
        complexMatrix = complexMatrix.add(basisMatrices[5].scalarMultiply(doubleVector.getComponent(5)));
        complexMatrix = complexMatrix.add(basisMatrices[6].scalarMultiply(doubleVector.getComponent(6)));
        complexMatrix = complexMatrix.add(basisMatrices[7].scalarMultiply(doubleVector.getComponent(7)));
        return (ComplexSquareMatrix)complexMatrix.scalarMultiply(Complex.I);
    }

    public DoubleVector multiply(DoubleVector doubleVector, DoubleVector doubleVector2) {
        double[] dArray = new double[]{doubleVector2.getComponent(1) * doubleVector.getComponent(2) - doubleVector2.getComponent(2) * doubleVector.getComponent(1) + 0.5 * (doubleVector2.getComponent(3) * doubleVector.getComponent(6) - doubleVector2.getComponent(6) * doubleVector.getComponent(3) + doubleVector2.getComponent(5) * doubleVector.getComponent(4) - doubleVector2.getComponent(4) * doubleVector.getComponent(5)), doubleVector2.getComponent(2) * doubleVector.getComponent(0) - doubleVector2.getComponent(0) * doubleVector.getComponent(2) + 0.5 * (doubleVector2.getComponent(3) * doubleVector.getComponent(5) - doubleVector2.getComponent(5) * doubleVector.getComponent(3) + doubleVector2.getComponent(4) * doubleVector.getComponent(6) - doubleVector2.getComponent(6) * doubleVector.getComponent(4)), doubleVector2.getComponent(0) * doubleVector.getComponent(1) - doubleVector2.getComponent(1) * doubleVector.getComponent(0) + 0.5 * (doubleVector2.getComponent(3) * doubleVector.getComponent(4) - doubleVector2.getComponent(4) * doubleVector.getComponent(3) + doubleVector2.getComponent(6) * doubleVector.getComponent(5) - doubleVector2.getComponent(5) * doubleVector.getComponent(6)), Math.sqrt(0.75) * (doubleVector2.getComponent(4) * doubleVector.getComponent(7) - doubleVector2.getComponent(7) * doubleVector.getComponent(4)) + 0.5 * (doubleVector2.getComponent(6) * doubleVector.getComponent(0) - doubleVector2.getComponent(0) * doubleVector.getComponent(6) + doubleVector2.getComponent(5) * doubleVector.getComponent(1) - doubleVector2.getComponent(1) * doubleVector.getComponent(5) + doubleVector2.getComponent(4) * doubleVector.getComponent(2) - doubleVector2.getComponent(2) * doubleVector.getComponent(4)), Math.sqrt(0.75) * (doubleVector2.getComponent(7) * doubleVector.getComponent(3) - doubleVector2.getComponent(3) * doubleVector.getComponent(7)) + 0.5 * (doubleVector2.getComponent(0) * doubleVector.getComponent(5) - doubleVector2.getComponent(5) * doubleVector.getComponent(0) + doubleVector2.getComponent(6) * doubleVector.getComponent(1) - doubleVector2.getComponent(1) * doubleVector.getComponent(6) + doubleVector2.getComponent(2) * doubleVector.getComponent(3) - doubleVector2.getComponent(3) * doubleVector.getComponent(2)), Math.sqrt(0.75) * (doubleVector2.getComponent(6) * doubleVector.getComponent(7) - doubleVector2.getComponent(7) * doubleVector.getComponent(6)) + 0.5 * (doubleVector2.getComponent(4) * doubleVector.getComponent(0) - doubleVector2.getComponent(0) * doubleVector.getComponent(4) + doubleVector2.getComponent(1) * doubleVector.getComponent(3) - doubleVector2.getComponent(3) * doubleVector.getComponent(1) + doubleVector2.getComponent(2) * doubleVector.getComponent(6) - doubleVector2.getComponent(6) * doubleVector.getComponent(2)), Math.sqrt(0.75) * (doubleVector2.getComponent(7) * doubleVector.getComponent(5) - doubleVector2.getComponent(5) * doubleVector.getComponent(7)) + 0.5 * (doubleVector2.getComponent(0) * doubleVector.getComponent(3) - doubleVector2.getComponent(3) * doubleVector.getComponent(0) + doubleVector2.getComponent(1) * doubleVector.getComponent(4) - doubleVector2.getComponent(4) * doubleVector.getComponent(1) + doubleVector2.getComponent(5) * doubleVector.getComponent(2) - doubleVector2.getComponent(2) * doubleVector.getComponent(5)), Math.sqrt(0.75) * (doubleVector2.getComponent(3) * doubleVector.getComponent(4) - doubleVector2.getComponent(4) * doubleVector.getComponent(3) + doubleVector2.getComponent(5) * doubleVector.getComponent(6) - doubleVector2.getComponent(6) * doubleVector.getComponent(5))};
        return new DoubleVector(dArray);
    }

    public ComplexSquareMatrix[] basis() {
        return basisMatrices;
    }
}

