/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.chaos;

import JSci.maths.Complex;
import JSci.maths.Mapping;

public final class LogisticMap
implements Mapping {
    private Complex r;
    public static final double R_2CYCLE = 3.0;
    public static final double R_4CYCLE = 1.0 + Math.sqrt(6.0);
    public static final double R_6CYCLE = 3.5441;
    public static final double R_8CYCLE = 3.5664;
    public static final double R_ACCUMULATION = 3.5699;

    public LogisticMap(double d) {
        this.r = new Complex(d, 0.0);
    }

    public LogisticMap(Complex complex) {
        this.r = complex;
    }

    public double map(double d) {
        return this.r.real() * d * (1.0 - d);
    }

    public Complex map(Complex complex) {
        return this.r.multiply(complex).multiply(Complex.ONE.subtract(complex));
    }

    public double iterate(int n, double d) {
        int n2 = 0;
        while (n2 < n) {
            d = this.map(d);
            ++n2;
        }
        return d;
    }

    public Complex iterate(int n, Complex complex) {
        int n2 = 0;
        while (n2 < n) {
            complex = this.map(complex);
            ++n2;
        }
        return complex;
    }
}

