/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.quantum;

import JSci.maths.Complex;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DimensionException;
import JSci.maths.MathVector;
import JSci.maths.ModuleMember;
import JSci.maths.RingMember;
import JSci.maths.VectorDimensionException;
import JSci.maths.groups.AbelianGroupMember;
import JSci.physics.quantum.KetVector;
import JSci.physics.quantum.Operator;

public final class BraVector
extends MathVector {
    private ComplexVector representation;

    public BraVector(ComplexVector complexVector) {
        this.representation = complexVector;
    }

    public boolean equals(Object object) {
        return this.representation.equals((Object)((BraVector)((Object)object)).representation);
    }

    public String toString() {
        return this.representation.toString();
    }

    public int hashCode() {
        return this.representation.hashCode();
    }

    public KetVector toKetVector() {
        return new KetVector(this.representation.conjugate());
    }

    public ComplexVector getRepresentation() {
        return this.representation;
    }

    public int dimension() {
        return this.representation.dimension();
    }

    public double norm() {
        return this.representation.norm();
    }

    public AbelianGroupMember negate() {
        return this.representation.negate();
    }

    public AbelianGroupMember add(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof BraVector) {
            BraVector braVector = (BraVector)abelianGroupMember;
            return new BraVector(this.representation.add(braVector.representation));
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public BraVector add(BraVector braVector) {
        return new BraVector(this.representation.add(braVector.representation));
    }

    public AbelianGroupMember subtract(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof BraVector) {
            BraVector braVector = (BraVector)abelianGroupMember;
            return new BraVector(this.representation.subtract(braVector.representation));
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public BraVector subtract(BraVector braVector) {
        return new BraVector(this.representation.subtract(braVector.representation));
    }

    public ModuleMember scalarMultiply(RingMember ringMember) {
        return this.representation.scalarMultiply(ringMember);
    }

    public Complex multiply(KetVector ketVector) {
        int n = this.representation.dimension();
        if (n == ketVector.dimension()) {
            ComplexVector complexVector = ketVector.getRepresentation();
            Complex complex = this.representation.getComponent(0).multiply(complexVector.getComponent(0));
            int n2 = 1;
            while (n2 < n) {
                complex = complex.add(this.representation.getComponent(n2).multiply(complexVector.getComponent(n2)));
                ++n2;
            }
            return complex;
        }
        throw new VectorDimensionException("Vectors have different dimensions.");
    }

    public BraVector multiply(Operator operator) {
        int n = this.representation.dimension();
        if (n == operator.dimension()) {
            ComplexSquareMatrix complexSquareMatrix = operator.getRepresentation();
            Complex[] complexArray = new Complex[n];
            int n2 = 0;
            while (n2 < n) {
                Complex complex = this.representation.getComponent(0).multiply(complexSquareMatrix.getElement(0, n2));
                int n3 = 1;
                while (n3 < n) {
                    complex = complex.add(this.representation.getComponent(n3).multiply(complexSquareMatrix.getElement(n3, n2)));
                    ++n3;
                }
                complexArray[n2] = complex;
                ++n2;
            }
            return new BraVector(new ComplexVector(complexArray));
        }
        throw new DimensionException("Operator and vector have different dimensions.");
    }
}

