/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.quantum;

import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.physics.quantum.KetVector;
import JSci.physics.quantum.Operator;
import JSci.physics.quantum.Projector;

public final class DensityMatrix
extends Operator {
    private static ComplexSquareMatrix constructor(KetVector[] ketVectorArray, double[] dArray) {
        ComplexMatrix complexMatrix = new Projector(ketVectorArray[0]).getRepresentation().scalarMultiply(dArray[0]);
        int n = 1;
        while (n < ketVectorArray.length) {
            complexMatrix = complexMatrix.add(new Projector(ketVectorArray[n]).getRepresentation().scalarMultiply(dArray[n]));
            ++n;
        }
        return (ComplexSquareMatrix)complexMatrix;
    }

    private static ComplexSquareMatrix constructor(Projector[] projectorArray, double[] dArray) {
        ComplexMatrix complexMatrix = projectorArray[0].getRepresentation().scalarMultiply(dArray[0]);
        int n = 1;
        while (n < projectorArray.length) {
            complexMatrix = complexMatrix.add(projectorArray[n].getRepresentation().scalarMultiply(dArray[n]));
            ++n;
        }
        return (ComplexSquareMatrix)complexMatrix;
    }

    public DensityMatrix(KetVector[] ketVectorArray, double[] dArray) {
        super(DensityMatrix.constructor(ketVectorArray, dArray));
    }

    public DensityMatrix(Projector[] projectorArray, double[] dArray) {
        super(DensityMatrix.constructor(projectorArray, dArray));
    }

    public boolean isPureState() {
        return this.representation.equals((Object)this.representation.multiply(this.representation));
    }
}

