/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.relativity;

import JSci.GlobalSettings;
import JSci.maths.DimensionException;
import JSci.maths.DoubleVector;
import JSci.physics.relativity.Rank2Tensor;
import JSci.physics.relativity.Rank3Tensor;
import JSci.physics.relativity.Rank4Tensor;
import JSci.physics.relativity.Tensor;

public class Rank1Tensor
extends Tensor {
    protected double[] rank1 = new double[4];

    public Rank1Tensor() {
    }

    public Rank1Tensor(double d, DoubleVector doubleVector) {
        this();
        this.rank1[0] = d;
        this.rank1[1] = doubleVector.getComponent(0);
        this.rank1[2] = doubleVector.getComponent(1);
        this.rank1[3] = doubleVector.getComponent(2);
    }

    public Rank1Tensor(double d, double d2, double d3, double d4) {
        this();
        this.rank1[0] = d;
        this.rank1[1] = d2;
        this.rank1[2] = d3;
        this.rank1[3] = d4;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Rank1Tensor) {
            Rank1Tensor rank1Tensor = (Rank1Tensor)object;
            return Math.abs(this.rank1[0] - rank1Tensor.rank1[0]) <= GlobalSettings.ZERO_TOL && Math.abs(this.rank1[1] - rank1Tensor.rank1[1]) <= GlobalSettings.ZERO_TOL && Math.abs(this.rank1[2] - rank1Tensor.rank1[2]) <= GlobalSettings.ZERO_TOL && Math.abs(this.rank1[3] - rank1Tensor.rank1[3]) <= GlobalSettings.ZERO_TOL;
        }
        return false;
    }

    public String toString() {
        return new String(String.valueOf(this.rank1[0]) + "," + this.rank1[1] + "," + this.rank1[2] + "," + this.rank1[3]);
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public double getComponent(int n) {
        if (n >= 0 && n < 4) {
            return this.rank1[n];
        }
        throw new DimensionException("Invalid component.");
    }

    public void setComponent(int n, double d) {
        if (n >= 0 && n < 4) {
            this.rank1[n] = d;
            return;
        }
        throw new DimensionException("Invalid component.");
    }

    public double norm() {
        return Math.sqrt(this.rank1[0] * this.rank1[0] - this.rank1[1] * this.rank1[1] - this.rank1[2] * this.rank1[2] - this.rank1[3] * this.rank1[3]);
    }

    public Rank1Tensor add(Rank1Tensor rank1Tensor) {
        Rank1Tensor rank1Tensor2 = new Rank1Tensor();
        rank1Tensor2.rank1[0] = this.rank1[0] + rank1Tensor.rank1[0];
        rank1Tensor2.rank1[1] = this.rank1[1] + rank1Tensor.rank1[1];
        rank1Tensor2.rank1[2] = this.rank1[2] + rank1Tensor.rank1[2];
        rank1Tensor2.rank1[3] = this.rank1[3] + rank1Tensor.rank1[3];
        return rank1Tensor2;
    }

    public Rank1Tensor subtract(Rank1Tensor rank1Tensor) {
        Rank1Tensor rank1Tensor2 = new Rank1Tensor();
        rank1Tensor2.rank1[0] = this.rank1[0] - rank1Tensor.rank1[0];
        rank1Tensor2.rank1[1] = this.rank1[1] - rank1Tensor.rank1[1];
        rank1Tensor2.rank1[2] = this.rank1[2] - rank1Tensor.rank1[2];
        rank1Tensor2.rank1[3] = this.rank1[3] - rank1Tensor.rank1[3];
        return rank1Tensor2;
    }

    public Rank2Tensor tensorProduct(Rank1Tensor rank1Tensor) {
        Rank2Tensor rank2Tensor = new Rank2Tensor();
        int n = 0;
        while (n < 4) {
            rank2Tensor.setComponent(n, 0, this.rank1[n] * rank1Tensor.rank1[0]);
            rank2Tensor.setComponent(n, 1, this.rank1[n] * rank1Tensor.rank1[1]);
            rank2Tensor.setComponent(n, 2, this.rank1[n] * rank1Tensor.rank1[2]);
            rank2Tensor.setComponent(n, 3, this.rank1[n] * rank1Tensor.rank1[3]);
            ++n;
        }
        return rank2Tensor;
    }

    public Rank3Tensor tensorProduct(Rank2Tensor rank2Tensor) {
        Rank3Tensor rank3Tensor = new Rank3Tensor();
        int n = 0;
        while (n < 4) {
            int n2 = 0;
            while (n2 < 4) {
                rank3Tensor.setComponent(n, n2, 0, this.rank1[n] * rank2Tensor.getComponent(n2, 0));
                rank3Tensor.setComponent(n, n2, 1, this.rank1[n] * rank2Tensor.getComponent(n2, 1));
                rank3Tensor.setComponent(n, n2, 2, this.rank1[n] * rank2Tensor.getComponent(n2, 2));
                rank3Tensor.setComponent(n, n2, 3, this.rank1[n] * rank2Tensor.getComponent(n2, 3));
                ++n2;
            }
            ++n;
        }
        return rank3Tensor;
    }

    public Rank4Tensor tensorProduct(Rank3Tensor rank3Tensor) {
        Rank4Tensor rank4Tensor = new Rank4Tensor();
        int n = 0;
        while (n < 4) {
            int n2 = 0;
            while (n2 < 4) {
                int n3 = 0;
                while (n3 < 4) {
                    rank4Tensor.setComponent(n, n2, n3, 0, this.rank1[n] * rank3Tensor.getComponent(n2, n3, 0));
                    rank4Tensor.setComponent(n, n2, n3, 1, this.rank1[n] * rank3Tensor.getComponent(n2, n3, 1));
                    rank4Tensor.setComponent(n, n2, n3, 2, this.rank1[n] * rank3Tensor.getComponent(n2, n3, 2));
                    rank4Tensor.setComponent(n, n2, n3, 3, this.rank1[n] * rank3Tensor.getComponent(n2, n3, 3));
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return rank4Tensor;
    }
}

