/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.relativity;

import JSci.GlobalSettings;
import JSci.maths.DimensionException;
import JSci.physics.relativity.Rank1Tensor;
import JSci.physics.relativity.Rank3Tensor;
import JSci.physics.relativity.Rank4Tensor;
import JSci.physics.relativity.Tensor;

public class Rank2Tensor
extends Tensor {
    protected double[][] rank2 = new double[4][4];

    public boolean equals(Object object) {
        if (object != null && object instanceof Rank2Tensor) {
            Rank2Tensor rank2Tensor = (Rank2Tensor)object;
            int n = 0;
            while (n < 4) {
                if (Math.abs(this.rank2[n][0] - rank2Tensor.rank2[n][0]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank2[n][1] - rank2Tensor.rank2[n][1]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank2[n][2] - rank2Tensor.rank2[n][2]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank2[n][3] - rank2Tensor.rank2[n][3]) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public double getComponent(int n, int n2) {
        if (n >= 0 && n < 4 && n2 >= 0 && n2 < 4) {
            return this.rank2[n][n2];
        }
        throw new DimensionException("Invalid component.");
    }

    public void setComponent(int n, int n2, double d) {
        if (n >= 0 && n < 4 && n2 >= 0 && n2 < 4) {
            this.rank2[n][n2] = d;
            return;
        }
        throw new DimensionException("Invalid component.");
    }

    public Rank2Tensor add(Rank2Tensor rank2Tensor) {
        Rank2Tensor rank2Tensor2 = new Rank2Tensor();
        int n = 0;
        while (n < 4) {
            rank2Tensor2.setComponent(n, 0, this.rank2[n][0] + rank2Tensor.rank2[n][0]);
            rank2Tensor2.setComponent(n, 1, this.rank2[n][1] + rank2Tensor.rank2[n][1]);
            rank2Tensor2.setComponent(n, 2, this.rank2[n][2] + rank2Tensor.rank2[n][2]);
            rank2Tensor2.setComponent(n, 3, this.rank2[n][3] + rank2Tensor.rank2[n][3]);
            ++n;
        }
        return rank2Tensor2;
    }

    public Rank2Tensor subtract(Rank2Tensor rank2Tensor) {
        Rank2Tensor rank2Tensor2 = new Rank2Tensor();
        int n = 0;
        while (n < 4) {
            rank2Tensor2.setComponent(n, 0, this.rank2[n][0] - rank2Tensor.rank2[n][0]);
            rank2Tensor2.setComponent(n, 1, this.rank2[n][1] - rank2Tensor.rank2[n][1]);
            rank2Tensor2.setComponent(n, 2, this.rank2[n][2] - rank2Tensor.rank2[n][2]);
            rank2Tensor2.setComponent(n, 3, this.rank2[n][3] - rank2Tensor.rank2[n][3]);
            ++n;
        }
        return rank2Tensor2;
    }

    public Rank1Tensor multiply(Rank1Tensor rank1Tensor) {
        Rank1Tensor rank1Tensor2 = new Rank1Tensor();
        rank1Tensor2.setComponent(0, this.rank2[0][0] * rank1Tensor.getComponent(0) + this.rank2[0][1] * rank1Tensor.getComponent(1) + this.rank2[0][2] * rank1Tensor.getComponent(2) + this.rank2[0][3] * rank1Tensor.getComponent(3));
        rank1Tensor2.setComponent(1, this.rank2[1][0] * rank1Tensor.getComponent(0) + this.rank2[1][1] * rank1Tensor.getComponent(1) + this.rank2[1][2] * rank1Tensor.getComponent(2) + this.rank2[1][3] * rank1Tensor.getComponent(3));
        rank1Tensor2.setComponent(2, this.rank2[2][0] * rank1Tensor.getComponent(0) + this.rank2[2][1] * rank1Tensor.getComponent(1) + this.rank2[2][2] * rank1Tensor.getComponent(2) + this.rank2[2][3] * rank1Tensor.getComponent(3));
        rank1Tensor2.setComponent(3, this.rank2[3][0] * rank1Tensor.getComponent(0) + this.rank2[3][1] * rank1Tensor.getComponent(1) + this.rank2[3][2] * rank1Tensor.getComponent(2) + this.rank2[3][3] * rank1Tensor.getComponent(3));
        return rank1Tensor2;
    }

    public Rank3Tensor tensorProduct(Rank1Tensor rank1Tensor) {
        Rank3Tensor rank3Tensor = new Rank3Tensor();
        int n = 0;
        while (n < 4) {
            int n2 = 0;
            while (n2 < 4) {
                rank3Tensor.setComponent(n, n2, 0, this.rank2[n][n2] * rank1Tensor.getComponent(0));
                rank3Tensor.setComponent(n, n2, 1, this.rank2[n][n2] * rank1Tensor.getComponent(1));
                rank3Tensor.setComponent(n, n2, 2, this.rank2[n][n2] * rank1Tensor.getComponent(2));
                rank3Tensor.setComponent(n, n2, 3, this.rank2[n][n2] * rank1Tensor.getComponent(3));
                ++n2;
            }
            ++n;
        }
        return rank3Tensor;
    }

    public Rank4Tensor tensorProduct(Rank2Tensor rank2Tensor) {
        Rank4Tensor rank4Tensor = new Rank4Tensor();
        int n = 0;
        while (n < 4) {
            int n2 = 0;
            while (n2 < 4) {
                int n3 = 0;
                while (n3 < 4) {
                    rank4Tensor.setComponent(n, n2, n3, 0, this.rank2[n][n2] * rank2Tensor.rank2[n3][0]);
                    rank4Tensor.setComponent(n, n2, n3, 1, this.rank2[n][n2] * rank2Tensor.rank2[n3][1]);
                    rank4Tensor.setComponent(n, n2, n3, 2, this.rank2[n][n2] * rank2Tensor.rank2[n3][2]);
                    rank4Tensor.setComponent(n, n2, n3, 3, this.rank2[n][n2] * rank2Tensor.rank2[n3][3]);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return rank4Tensor;
    }
}

