/*
 * Decompiled with CFR 0.152.
 */
package JSci.physics.relativity;

import JSci.GlobalSettings;
import JSci.maths.DimensionException;
import JSci.physics.relativity.Rank1Tensor;
import JSci.physics.relativity.Rank4Tensor;
import JSci.physics.relativity.Tensor;

public class Rank3Tensor
extends Tensor {
    protected double[][][] rank3 = new double[4][4][4];

    public boolean equals(Object object) {
        if (object != null && object instanceof Rank3Tensor) {
            Rank3Tensor rank3Tensor = (Rank3Tensor)object;
            int n = 0;
            while (n < 4) {
                int n2 = 0;
                while (n2 < 4) {
                    if (Math.abs(this.rank3[n][n2][0] - rank3Tensor.rank3[n][n2][0]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank3[n][n2][1] - rank3Tensor.rank3[n][n2][1]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank3[n][n2][2] - rank3Tensor.rank3[n][n2][2]) > GlobalSettings.ZERO_TOL || Math.abs(this.rank3[n][n2][3] - rank3Tensor.rank3[n][n2][3]) > GlobalSettings.ZERO_TOL) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public double getComponent(int n, int n2, int n3) {
        if (n >= 0 && n < 4 && n2 >= 0 && n2 < 4 && n3 >= 0 && n3 < 4) {
            return this.rank3[n][n2][n3];
        }
        throw new DimensionException("Invalid component.");
    }

    public void setComponent(int n, int n2, int n3, double d) {
        if (n >= 0 && n < 4 && n2 >= 0 && n2 < 4 && n3 >= 0 && n3 < 4) {
            this.rank3[n][n2][n3] = d;
            return;
        }
        throw new DimensionException("Invalid component.");
    }

    public Rank3Tensor add(Rank3Tensor rank3Tensor) {
        Rank3Tensor rank3Tensor2 = new Rank3Tensor();
        int n = 0;
        while (n < 4) {
            int n2 = 0;
            while (n2 < 4) {
                rank3Tensor2.setComponent(n, n2, 0, this.rank3[n][n2][0] + rank3Tensor.rank3[n][n2][0]);
                rank3Tensor2.setComponent(n, n2, 1, this.rank3[n][n2][1] + rank3Tensor.rank3[n][n2][1]);
                rank3Tensor2.setComponent(n, n2, 2, this.rank3[n][n2][2] + rank3Tensor.rank3[n][n2][2]);
                rank3Tensor2.setComponent(n, n2, 3, this.rank3[n][n2][3] + rank3Tensor.rank3[n][n2][3]);
                ++n2;
            }
            ++n;
        }
        return rank3Tensor2;
    }

    public Rank3Tensor subtract(Rank3Tensor rank3Tensor) {
        Rank3Tensor rank3Tensor2 = new Rank3Tensor();
        int n = 0;
        while (n < 4) {
            int n2 = 0;
            while (n2 < 4) {
                rank3Tensor2.setComponent(n, n2, 0, this.rank3[n][n2][0] - rank3Tensor.rank3[n][n2][0]);
                rank3Tensor2.setComponent(n, n2, 1, this.rank3[n][n2][1] - rank3Tensor.rank3[n][n2][1]);
                rank3Tensor2.setComponent(n, n2, 2, this.rank3[n][n2][2] - rank3Tensor.rank3[n][n2][2]);
                rank3Tensor2.setComponent(n, n2, 3, this.rank3[n][n2][3] - rank3Tensor.rank3[n][n2][3]);
                ++n2;
            }
            ++n;
        }
        return rank3Tensor2;
    }

    public Rank4Tensor tensorProduct(Rank1Tensor rank1Tensor) {
        Rank4Tensor rank4Tensor = new Rank4Tensor();
        int n = 0;
        while (n < 4) {
            int n2 = 0;
            while (n2 < 4) {
                int n3 = 0;
                while (n3 < 4) {
                    rank4Tensor.setComponent(n, n2, n3, 0, this.rank3[n][n2][n3] * rank1Tensor.getComponent(0));
                    rank4Tensor.setComponent(n, n2, n3, 1, this.rank3[n][n2][n3] * rank1Tensor.getComponent(1));
                    rank4Tensor.setComponent(n, n2, n3, 2, this.rank3[n][n2][n3] * rank1Tensor.getComponent(2));
                    rank4Tensor.setComponent(n, n2, n3, 3, this.rank3[n][n2][n3] * rank1Tensor.getComponent(3));
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return rank4Tensor;
    }
}

