/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.splines;

import JSci.maths.ArrayMath;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.splines.LinearSpline;
import JSci.maths.wavelet.splines.Spline;

public class QuadraticSpline
extends Spline
implements Filter,
Cloneable {
    protected static final int filtretype = 2;
    private double[] vecteur;
    static final double[] vg = new double[]{0.25, 0.75, 0.75, 0.25};
    static final double[] v0 = new double[]{0.75, 0.25};

    public String toString() {
        return ArrayMath.toString((double[])this.vecteur);
    }

    public int getFilterType() {
        return 2;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof QuadraticSpline && this.vecteur.length == ((QuadraticSpline)object).dimension()) {
            QuadraticSpline quadraticSpline = (QuadraticSpline)object;
            int n = 0;
            while (n < this.vecteur.length) {
                if (this.vecteur[n] != quadraticSpline.getValue(n)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public int previousDimension(int n) {
        return Cascades.previousDimension(2, n);
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        if (dArray.length < 3) {
            throw new IllegalArgumentException("The array is not long enough : " + dArray.length + " < 3");
        }
        double[] dArray2 = new double[2 * dArray.length - 2];
        int n = 1;
        while (n < dArray.length - 1) {
            int n2 = 2 * n - 2;
            dArray2[n2] = dArray2[n2] + dArray[n] * vg[0];
            int n3 = 2 * n - 1;
            dArray2[n3] = dArray2[n3] + dArray[n] * vg[1];
            int n4 = 2 * n;
            dArray2[n4] = dArray2[n4] + dArray[n] * vg[2];
            int n5 = 2 * n + 1;
            dArray2[n5] = dArray2[n5] + dArray[n] * vg[3];
            ++n;
        }
        dArray2[0] = dArray2[0] + v0[0] * dArray[0];
        dArray2[1] = dArray2[1] + v0[1] * dArray[0];
        int n6 = dArray2.length - 1;
        dArray2[n6] = dArray2[n6] + v0[0] * dArray[dArray.length - 1];
        int n7 = dArray2.length - 2;
        dArray2[n7] = dArray2[n7] + v0[1] * dArray[dArray.length - 1];
        return dArray2;
    }

    public double[] highpass(double[] dArray) {
        return this.lowpass(dArray);
    }

    public QuadraticSpline(double[] dArray) {
        this.vecteur = dArray;
    }

    public QuadraticSpline() {
    }

    public Object clone() {
        QuadraticSpline quadraticSpline = (QuadraticSpline)super.clone();
        if (this.vecteur != null) {
            quadraticSpline.vecteur = ArrayMath.copy((double[])this.vecteur);
        }
        return quadraticSpline;
    }

    public double getValue(int n) {
        if (n < 0 || n > this.vecteur.length - 1) {
            throw new IllegalArgumentException("Parameter incorrect : " + n + ", " + this.vecteur.length);
        }
        return this.vecteur[n];
    }

    public void setValue(int n, double d) {
        if (n < 0) {
            throw new IllegalArgumentException("The parameter must be positive : " + n);
        }
        this.vecteur[n] = d;
    }

    public void setValues(double[] dArray) {
        this.vecteur = dArray;
    }

    public LinearSpline derive() {
        return this.derive(0.0, 1.0);
    }

    public LinearSpline derive(double d, double d2) {
        double[] dArray = new double[this.vecteur.length - 1];
        int n = 0;
        while (n < this.vecteur.length - 1) {
            dArray[n] = 2.0 * (this.vecteur[n + 1] - this.vecteur[n]) * (double)this.vecteur.length / Math.abs(d2 - d);
            ++n;
        }
        return new LinearSpline(dArray);
    }

    public int dimension() {
        return this.vecteur.length;
    }

    public int dimension(int n) {
        return Cascades.dimension(this.vecteur.length, n, 2);
    }

    public double[] interpolate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("This parameter must be postive : " + n);
        }
        return Cascades.evaluation(this, n, this.vecteur);
    }

    public double[] evaluate(int n) {
        return this.interpolate(n);
    }
}

