/*
 * Decompiled with CFR 0.152.
 */
package JSci.awt;

import JSci.awt.AbstractGraphModel;
import JSci.awt.CategoryGraph2DModel;
import JSci.awt.DataSeries;
import java.util.Vector;

public final class DefaultCategoryGraph2DModel
extends AbstractGraphModel
implements CategoryGraph2DModel {
    private Object[] category;
    private final Vector series = new Vector();
    private int pos;
    private DataSeries curSeries;

    public void setCategories(Object[] objectArray) {
        this.category = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, this.category, 0, objectArray.length);
        this.fireDataChanged();
    }

    public Object[] getCategories() {
        return this.category;
    }

    public void addSeries(float[] fArray) {
        this.series.addElement(new DataSeries(fArray));
        this.fireDataChanged();
    }

    public void addSeries(double[] dArray) {
        this.series.addElement(new DataSeries(dArray));
        this.fireDataChanged();
    }

    public void changeSeries(int n, float[] fArray) {
        this.series.setElementAt(new DataSeries(fArray), n);
        this.fireDataChanged();
    }

    public void changeSeries(int n, double[] dArray) {
        this.series.setElementAt(new DataSeries(dArray), n);
        this.fireDataChanged();
    }

    public void removeSeries(int n) {
        this.series.removeElementAt(n);
        this.fireDataChanged();
    }

    public float[] getSeries(int n) {
        return ((DataSeries)this.series.elementAt(n)).getData();
    }

    public void setSeriesVisible(int n, boolean bl) {
        ((DataSeries)this.series.elementAt(n)).setVisible(bl);
        this.fireDataChanged();
    }

    public String getCategory(int n) {
        return this.category[n].toString();
    }

    public float getValue(int n) {
        return this.curSeries.getValueAt(n);
    }

    public int seriesLength() {
        return this.curSeries.length();
    }

    public void firstSeries() {
        this.curSeries = (DataSeries)this.series.elementAt(0);
        this.pos = 0;
        while (!this.curSeries.isVisible() && this.pos < this.series.size() - 1) {
            this.curSeries = (DataSeries)this.series.elementAt(++this.pos);
        }
    }

    public boolean nextSeries() {
        if (this.pos == this.series.size() - 1) {
            return false;
        }
        do {
            this.curSeries = (DataSeries)this.series.elementAt(++this.pos);
        } while (!this.curSeries.isVisible() && this.pos < this.series.size() - 1);
        return this.curSeries.isVisible();
    }
}

