/*
 * Decompiled with CFR 0.152.
 */
package JSci.io;

import JSci.io.MathMLExpression;
import JSci.io.MathMLRelation;
import JSci.maths.Complex;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DiscreteSet;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.IntegerMatrix;
import JSci.maths.IntegerSquareMatrix;
import JSci.maths.IntegerVector;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.MathVector;
import JSci.maths.Matrix;
import JSci.maths.RingMember;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class MathMLParser
extends DOMParser {
    private static final int INTEGER = 0;
    private static final int DOUBLE = 1;
    private static final int COMPLEX = 2;
    private int setCounter = 1;

    public Object[] getJSciObjects() {
        return this.parseMATH(this.fDocument.getDocumentElement());
    }

    private Object[] parseMATH(Node node) {
        int n = 0;
        NodeList nodeList = node.getChildNodes();
        Object[] objectArray = new Object[nodeList.getLength()];
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object = this.processNode(nodeList.item(n2));
            if (object != null) {
                objectArray[n] = object;
                ++n;
            }
            ++n2;
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    private Object processNode(Node node) {
        String string = node.getNodeName();
        if (string.equals("apply")) {
            return this.parseAPPLY(node);
        }
        if (string.equals("reln")) {
            return this.parseRELN(node);
        }
        if (string.equals("cn")) {
            return this.parseCN(node);
        }
        if (string.equals("ci")) {
            return node.getFirstChild().getNodeValue();
        }
        if (string.equals("vector")) {
            return this.parseVECTOR(node);
        }
        if (string.equals("matrix")) {
            return this.parseMATRIX(node);
        }
        if (string.equals("set")) {
            return this.parseSET(node);
        }
        return null;
    }

    private MathMLExpression parseAPPLY(Node node) {
        MathMLExpression mathMLExpression = new MathMLExpression();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (nodeList.item(n) instanceof Text) {
            ++n;
        }
        mathMLExpression.setOperation(nodeList.item(n).getNodeName());
        while (n < nodeList.getLength()) {
            Object object = this.processNode(nodeList.item(n));
            if (object != null) {
                mathMLExpression.addArgument(object);
            }
            ++n;
        }
        return mathMLExpression;
    }

    private MathMLRelation parseRELN(Node node) {
        MathMLRelation mathMLRelation = new MathMLRelation();
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (nodeList.item(n) instanceof Text) {
            ++n;
        }
        mathMLRelation.setRelation(nodeList.item(n).getNodeName());
        while (n < nodeList.getLength()) {
            Object object = this.processNode(nodeList.item(n));
            if (object != null) {
                mathMLRelation.addArgument(object);
            }
            ++n;
        }
        return mathMLRelation;
    }

    private RingMember parseCN(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (!namedNodeMap.getNamedItem("base").getNodeValue().equals("10")) {
            return null;
        }
        if (namedNodeMap.getNamedItem("type") == null) {
            return new MathDouble(node.getFirstChild().getNodeValue());
        }
        String string = namedNodeMap.getNamedItem("type").getNodeValue();
        if (string.equals("integer")) {
            return new MathInteger(node.getFirstChild().getNodeValue());
        }
        if (string.equals("real")) {
            return new MathDouble(node.getFirstChild().getNodeValue());
        }
        if (string.equals("rational")) {
            Node node2 = node.getFirstChild();
            Node node3 = node2.getNextSibling().getNextSibling();
            return new MathDouble(node2.getNodeValue()).divide(new MathDouble(node3.getNodeValue()));
        }
        if (string.equals("complex-cartesian")) {
            Node node4 = node.getFirstChild();
            Node node5 = node4.getNextSibling().getNextSibling();
            return new Complex(new Double(node4.getNodeValue()).doubleValue(), new Double(node5.getNodeValue()).doubleValue());
        }
        if (string.equals("complex-polar")) {
            Node node6 = node.getFirstChild();
            Node node7 = node6.getNextSibling().getNextSibling();
            return Complex.polar((double)new Double(node6.getNodeValue()), (double)new Double(node7.getNodeValue()));
        }
        return null;
    }

    private String parseCI(Node node) {
        return node.getFirstChild().getNodeValue();
    }

    private MathVector parseVECTOR(Node node) {
        int n = 0;
        int n2 = 0;
        NodeList nodeList = node.getChildNodes();
        RingMember[] ringMemberArray = new RingMember[nodeList.getLength()];
        int n3 = 0;
        while (n3 < ringMemberArray.length) {
            if (nodeList.item(n3).getNodeName().equals("cn")) {
                ringMemberArray[n] = this.parseCN(nodeList.item(n3));
                if (ringMemberArray[n] != null) {
                    if (ringMemberArray[n] instanceof MathDouble && n2 < 1) {
                        n2 = 1;
                    } else if (ringMemberArray[n] instanceof Complex && n2 < 2) {
                        n2 = 2;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        if (n2 == 0) {
            int[] nArray = new int[n];
            int n4 = 0;
            while (n4 < nArray.length) {
                nArray[n4] = ((MathInteger)ringMemberArray[n4]).value();
                ++n4;
            }
            return new IntegerVector(nArray);
        }
        if (n2 == 1) {
            double[] dArray = new double[n];
            int n5 = 0;
            while (n5 < dArray.length) {
                dArray[n5] = ringMemberArray[n5] instanceof MathInteger ? (double)((MathInteger)ringMemberArray[n5]).value() : ((MathDouble)ringMemberArray[n5]).value();
                ++n5;
            }
            return new DoubleVector(dArray);
        }
        Complex[] complexArray = new Complex[n];
        int n6 = 0;
        while (n6 < complexArray.length) {
            complexArray[n6] = ringMemberArray[n6] instanceof MathInteger ? new Complex((double)((MathInteger)ringMemberArray[n6]).value(), 0.0) : (ringMemberArray[n6] instanceof MathDouble ? new Complex(((MathDouble)ringMemberArray[n6]).value(), 0.0) : (Complex)ringMemberArray[n6]);
            ++n6;
        }
        return new ComplexVector(complexArray);
    }

    private Matrix parseMATRIX(Node node) {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        NodeList nodeList = node.getChildNodes();
        RingMember[][] ringMemberArray = new RingMember[nodeList.getLength()][];
        int n3 = 0;
        while (n3 < ringMemberArray.length) {
            if (nodeList.item(n3).getNodeName().equals("matrixrow")) {
                ringMemberArray[n] = this.parseMATRIXROW(nodeList.item(n3));
                if (ringMemberArray[n].length < n2) {
                    n2 = ringMemberArray[n].length;
                }
                ++n;
            }
            ++n3;
        }
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n2) {
                if (ringMemberArray[n5][n6] instanceof MathDouble && n4 < 1) {
                    n4 = 1;
                } else if (ringMemberArray[n5][n6] instanceof Complex && n4 < 2) {
                    n4 = 2;
                }
                ++n6;
            }
            ++n5;
        }
        if (n4 == 0) {
            int[][] nArray = new int[n][n2];
            int n7 = 0;
            while (n7 < n) {
                int n8 = 0;
                while (n8 < n2) {
                    nArray[n7][n8] = ((MathInteger)ringMemberArray[n7][n8]).value();
                    ++n8;
                }
                ++n7;
            }
            if (n == n2) {
                return new IntegerSquareMatrix(nArray);
            }
            return new IntegerMatrix(nArray);
        }
        if (n4 == 1) {
            double[][] dArray = new double[n][n2];
            int n9 = 0;
            while (n9 < n) {
                int n10 = 0;
                while (n10 < n2) {
                    dArray[n9][n10] = ringMemberArray[n9][n10] instanceof MathInteger ? (double)((MathInteger)ringMemberArray[n9][n10]).value() : ((MathDouble)ringMemberArray[n9][n10]).value();
                    ++n10;
                }
                ++n9;
            }
            if (n == n2) {
                return new DoubleSquareMatrix(dArray);
            }
            return new DoubleMatrix(dArray);
        }
        Complex[][] complexArray = new Complex[n][n2];
        int n11 = 0;
        while (n11 < n) {
            int n12 = 0;
            while (n12 < n2) {
                complexArray[n11][n12] = ringMemberArray[n11][n12] instanceof MathInteger ? new Complex((double)((MathInteger)ringMemberArray[n11][n12]).value(), 0.0) : (ringMemberArray[n11][n12] instanceof MathDouble ? new Complex(((MathDouble)ringMemberArray[n11][n12]).value(), 0.0) : (Complex)ringMemberArray[n11][n12]);
                ++n12;
            }
            ++n11;
        }
        if (n == n2) {
            return new ComplexSquareMatrix(complexArray);
        }
        return new ComplexMatrix(complexArray);
    }

    private RingMember[] parseMATRIXROW(Node node) {
        int n = 0;
        NodeList nodeList = node.getChildNodes();
        RingMember[] ringMemberArray = new RingMember[nodeList.getLength()];
        int n2 = 0;
        while (n2 < ringMemberArray.length) {
            if (nodeList.item(n2).getNodeName().equals("cn")) {
                ringMemberArray[n] = this.parseCN(nodeList.item(n2));
                if (ringMemberArray[n] != null) {
                    ++n;
                }
            }
            ++n2;
        }
        RingMember[] ringMemberArray2 = new RingMember[n];
        System.arraycopy(ringMemberArray, 0, ringMemberArray2, 0, n);
        return ringMemberArray2;
    }

    private DiscreteSet parseSET(Node node) {
        Object object;
        int n = 0;
        NodeList nodeList = node.getChildNodes();
        Object[] objectArray = new Object[nodeList.getLength()];
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (nodeList.item(n2).getNodeName().equals("ci")) {
                object = nodeList.item(n2);
                objectArray[n] = object.getFirstChild().getNodeValue();
                ++n;
            }
            ++n2;
        }
        object = new Object[n];
        System.arraycopy(objectArray, 0, object, 0, n);
        return new DiscreteSet("Parsed MathML set " + this.setCounter++, (Object[])object);
    }
}

