/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import JSci.awt.DefaultGraph2DModel;
import JSci.awt.Graph2DModel;
import JSci.swing.JDoubleBufferedComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;

public final class JLineTrace
extends JDoubleBufferedComponent {
    private float[][] data;
    private int dataCursor;
    private float dataRes;
    private boolean numbering = true;
    private Point origin;
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private float xScale;
    private float yScale;
    private final int scalePad = 5;
    private final int axisPad = 25;

    public JLineTrace(float f, float f2, float f3, float f4) {
        this.addMouseMotionListener(new MouseLineAdapter());
        this.setXExtrema(f, f2);
        this.setYExtrema(f3, f4);
        this.setSampleNumber(50);
    }

    public Graph2DModel getModel() {
        DefaultGraph2DModel defaultGraph2DModel = new DefaultGraph2DModel();
        defaultGraph2DModel.setXAxis(this.data[0]);
        defaultGraph2DModel.addSeries(this.data[1]);
        return defaultGraph2DModel;
    }

    public void setNumbering(boolean bl) {
        this.numbering = bl;
    }

    public void setXExtrema(float f, float f2) {
        if (f2 < f) {
            throw new IllegalArgumentException("Maximum should be greater than minimum; max = " + f2 + " and min = " + f);
        }
        this.minX = f;
        this.maxX = f2;
        this.rescale();
    }

    public void setYExtrema(float f, float f2) {
        if (f2 < f) {
            throw new IllegalArgumentException("Maximum should be greater than minimum; max = " + f2 + " and min = " + f);
        }
        this.minY = f;
        this.maxY = f2;
        this.rescale();
    }

    public void setSampleNumber(int n) {
        this.data = new float[2][n];
        this.dataRes = (this.maxX - this.minX) / (float)n;
    }

    public void clear() {
        this.dataCursor = 0;
        this.redraw();
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.rescale();
    }

    private void rescale() {
        Dimension dimension = new Dimension(250, 250);
        int n = Math.max(this.getWidth(), dimension.width);
        int n2 = Math.max(this.getHeight(), dimension.height);
        this.xScale = (float)(n - 60) / (this.maxX - this.minX);
        this.yScale = (float)(n2 - 60) / (this.maxY - this.minY);
        this.origin = new Point(Math.round(-this.minX * this.xScale) + 25 + 5, Math.round(this.maxY * this.yScale) + 25 + 5);
        this.redraw();
    }

    public Dimension getPreferredSize() {
        return new Dimension(250, 250);
    }

    public Dimension getMinimumSize() {
        return new Dimension(250, 250);
    }

    private float[] screenToData(Point point) {
        float[] fArray = new float[]{(float)(point.x - this.origin.x) / this.xScale, (float)(this.origin.y - point.y) / this.yScale};
        return fArray;
    }

    private Point dataToScreen(float f, float f2) {
        return new Point(this.origin.x + Math.round(this.xScale * f), this.origin.y - Math.round(this.yScale * f2));
    }

    protected void offscreenPaint(Graphics graphics) {
        this.drawAxes(graphics);
        Point point = this.dataToScreen(this.data[0][0], this.data[1][0]);
        int n = 1;
        while (n < this.dataCursor) {
            Point point2 = this.dataToScreen(this.data[0][n], this.data[1][n]);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
            point = point2;
            ++n;
        }
    }

    private void drawAxes(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawLine(25, this.origin.y, this.getWidth() - 25, this.origin.y);
        graphics.drawLine(this.origin.x, 25, this.origin.x, this.getHeight() - 25);
        if (this.numbering) {
            float f;
            Point point;
            int n;
            String string;
            float f2;
            int n2 = graphics.getFontMetrics().getHeight();
            float f3 = f2 = this.round(40.0f / this.xScale);
            while (f3 <= this.maxX) {
                string = String.valueOf(this.round(f3));
                n = graphics.getFontMetrics().stringWidth(String.valueOf('+') + string);
                point = this.dataToScreen(f3, 0.0f);
                graphics.drawLine(point.x, point.y, point.x, point.y + 5);
                graphics.drawString(string, point.x - n / 2, this.origin.y + n2 + 5);
                f3 += f2;
            }
            f3 = -f2;
            while (f3 >= this.minX) {
                string = String.valueOf(this.round(f3));
                n = graphics.getFontMetrics().stringWidth(string);
                point = this.dataToScreen(f3, 0.0f);
                graphics.drawLine(point.x, point.y, point.x, point.y + 5);
                graphics.drawString(string, point.x - n / 2, this.origin.y + n2 + 5);
                f3 -= f2;
            }
            float f4 = f = this.round(40.0f / this.yScale);
            while (f4 <= this.maxY) {
                string = String.valueOf(this.round(f4));
                n = graphics.getFontMetrics().stringWidth(string);
                point = this.dataToScreen(0.0f, f4);
                graphics.drawLine(point.x, point.y, point.x - 5, point.y);
                graphics.drawString(string, this.origin.x - n - 8, point.y + n2 / 4);
                f4 += f;
            }
            f4 = -f;
            while (f4 >= this.minY) {
                string = String.valueOf(this.round(f4));
                n = graphics.getFontMetrics().stringWidth(string);
                point = this.dataToScreen(0.0f, f4);
                graphics.drawLine(point.x, point.y, point.x - 5, point.y);
                graphics.drawString(string, this.origin.x - n - 8, point.y + n2 / 4);
                f4 -= f;
            }
        }
    }

    private float round(float f) {
        float f2;
        float f3;
        int n = 1;
        if (f < 0.0f) {
            n = -1;
        }
        if ((f3 = Math.abs(f)) < 1.0f) {
            float f4 = 10.0f * f3;
            int n2 = 1;
            while (f4 < 1.0f) {
                f4 *= 10.0f;
                ++n2;
            }
            f2 = (float)Math.pow(10.0, n2 + 2 - 1);
        } else {
            float f5 = f3 / 10.0f;
            int n3 = 1;
            while (f5 > 1.0f) {
                f5 /= 10.0f;
                ++n3;
            }
            f2 = (float)Math.pow(10.0, 2 - n3);
        }
        return (float)((double)n * Math.rint(f3 * f2) / (double)f2);
    }

    static /* synthetic */ float[] access$0(JLineTrace jLineTrace, Point point) {
        return jLineTrace.screenToData(point);
    }

    static /* synthetic */ float access$2(JLineTrace jLineTrace) {
        return jLineTrace.dataRes;
    }

    static /* synthetic */ float access$3(JLineTrace jLineTrace) {
        return jLineTrace.minX;
    }

    static /* synthetic */ float[][] access$4(JLineTrace jLineTrace) {
        return jLineTrace.data;
    }

    class MouseLineAdapter
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            Object object = JLineTrace.this;
            Serializable serializable = mouseEvent.getPoint();
            object = ((JLineTrace)object).screenToData((Point)serializable);
            serializable = JLineTrace.this;
            serializable = JLineTrace.this;
            serializable = JLineTrace.this;
            if (object[0] >= (float)((JLineTrace)serializable).dataCursor * ((JLineTrace)serializable).dataRes + ((JLineTrace)serializable).minX) {
                serializable = JLineTrace.this;
                serializable = JLineTrace.this;
                if (((JLineTrace)serializable).dataCursor < ((JLineTrace)serializable).data[0].length) {
                    serializable = JLineTrace.this;
                    serializable = JLineTrace.this;
                    ((JLineTrace)serializable).data[0][((JLineTrace)serializable).dataCursor] = (float)object[0];
                    serializable = JLineTrace.this;
                    serializable = JLineTrace.this;
                    ((JLineTrace)serializable).data[1][((JLineTrace)serializable).dataCursor] = (float)object[1];
                    JLineTrace jLineTrace = JLineTrace.this;
                    jLineTrace.dataCursor = jLineTrace.dataCursor + 1;
                }
            }
            JLineTrace.this.redraw();
        }

        MouseLineAdapter() {
            JLineTrace.this = JLineTrace.this;
        }
    }
}

