/*
 * Decompiled with CFR 0.152.
 */
package JSci.util;

import JSci.maths.ComplexSquareMatrix;
import JSci.maths.DoubleDiagonalMatrix;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleTridiagonalMatrix;
import JSci.util.RandomMap;

public final class MatrixToolkit {
    private MatrixToolkit() {
    }

    public static DoubleSquareMatrix randomSquareMatrix(int n) {
        return (DoubleSquareMatrix)new DoubleSquareMatrix(n).mapElements(RandomMap.MAP);
    }

    public static DoubleTridiagonalMatrix randomTridiagonalMatrix(int n) {
        return (DoubleTridiagonalMatrix)new DoubleTridiagonalMatrix(n).mapElements(RandomMap.MAP);
    }

    public static DoubleDiagonalMatrix randomDiagonalMatrix(int n) {
        return (DoubleDiagonalMatrix)new DoubleDiagonalMatrix(n).mapElements(RandomMap.MAP);
    }

    public static ComplexSquareMatrix randomComplexSquareMatrix(int n) {
        return (ComplexSquareMatrix)new ComplexSquareMatrix(n).mapElements(RandomMap.MAP);
    }

    public static double[][] toArray(DoubleMatrix doubleMatrix) {
        double[][] dArray = new double[doubleMatrix.rows()][doubleMatrix.columns()];
        int n = 0;
        while (n < dArray.length) {
            int n2 = 0;
            while (n2 < dArray[0].length) {
                dArray[n][n2] = doubleMatrix.getElement(n, n2);
                ++n2;
            }
            ++n;
        }
        return dArray;
    }
}

