/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.ArrayMath;
import JSci.maths.DoubleVector;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Cosine;
import JSci.maths.wavelet.DiscreteFunction;
import JSci.maths.wavelet.DiscreteHilbertSpace;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.Multiresolution;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.Sine;
import JSci.maths.wavelet.SparseDiscreteFunction;

public class BasisFunctionLibrary
implements Cloneable {
    private double MorseThreshold = 0.5;
    protected DiscreteFunction[] Fprimary;
    protected DiscreteFunction[] Fdual;
    protected DiscreteFunction DFunction;

    public Object clone() {
        try {
            BasisFunctionLibrary basisFunctionLibrary = (BasisFunctionLibrary)super.clone();
            basisFunctionLibrary.MorseThreshold = this.MorseThreshold;
            basisFunctionLibrary.DFunction = (DiscreteFunction)this.DFunction.clone();
            basisFunctionLibrary.Fprimary = BasisFunctionLibrary.cloneArrayDiscreteFunction(this.Fprimary);
            basisFunctionLibrary.Fdual = BasisFunctionLibrary.cloneArrayDiscreteFunction(this.Fdual);
            return basisFunctionLibrary;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void setMorseThreshold(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The threshold must be between 0 and 1 :" + d);
        }
        this.MorseThreshold = d;
    }

    public double getMorseThreshold() {
        return this.MorseThreshold;
    }

    public void includeFourier() {
        int n = 0;
        while ((double)n <= Math.floor((double)this.DFunction.dimension() / 2.0)) {
            this.add(new Cosine(this.DFunction.dimension(), n));
            ++n;
        }
        int n2 = 1;
        while ((double)n2 < Math.ceil((double)this.DFunction.dimension() / 2.0)) {
            this.add(new Sine(this.DFunction.dimension(), n2));
            ++n2;
        }
    }

    public void includeMasslessFourier() {
        int n = 1;
        while ((double)n <= Math.floor((double)this.DFunction.dimension() / 2.0)) {
            this.add(new Cosine(this.DFunction.dimension(), n));
            ++n;
        }
        int n2 = 1;
        while ((double)n2 < Math.ceil((double)this.DFunction.dimension() / 2.0)) {
            this.add(new Sine(this.DFunction.dimension(), n2));
            ++n2;
        }
    }

    public DiscreteFunction getPrimary(int n) {
        return this.Fprimary[n];
    }

    public DiscreteFunction getDual(int n) {
        return this.Fdual[n];
    }

    protected BasisFunctionLibrary() {
    }

    public BasisFunctionLibrary(DiscreteFunction discreteFunction) {
        this.setData(discreteFunction);
    }

    public void setData(DiscreteFunction discreteFunction) {
        if (this.DFunction != null && discreteFunction.dimension() != this.DFunction.dimension()) {
            throw new IllegalArgumentException("You cannot change the dimension of the data object. Please create a new object.");
        }
        this.DFunction = (DiscreteFunction)discreteFunction.clone();
    }

    public DiscreteFunction getData() {
        return (DiscreteFunction)this.DFunction.clone();
    }

    protected static DiscreteFunction[] cloneArrayDiscreteFunction(MultiscaleFunction[] multiscaleFunctionArray) {
        if (multiscaleFunctionArray != null) {
            DiscreteFunction[] discreteFunctionArray = new DiscreteFunction[multiscaleFunctionArray.length];
            int n = 0;
            while (n < multiscaleFunctionArray.length) {
                if (multiscaleFunctionArray[n] != null) {
                    discreteFunctionArray[n] = (DiscreteFunction)multiscaleFunctionArray[n].clone();
                }
                ++n;
            }
            return discreteFunctionArray;
        }
        return null;
    }

    private DiscreteFunction toDiscreteFunction(MultiscaleFunction multiscaleFunction) {
        int n = 0;
        while (multiscaleFunction.dimension(n) < this.DFunction.dimension()) {
            if (++n <= 20) continue;
            throw new IllegalScalingException("Could not match the added object with internal data object in 20 iterations.");
        }
        if (multiscaleFunction.dimension(n) != this.DFunction.dimension()) {
            throw new IllegalScalingException("Could not match the added object with internal data object.");
        }
        double[] dArray = ArrayMath.scalarMultiply((double)(1.0 / Math.sqrt(Cascades.PowerOf2(n))), (double[])multiscaleFunction.evaluate(n));
        int n2 = 0;
        int n3 = 0;
        while (n3 < dArray.length) {
            if (dArray[n3] != 0.0) {
                ++n2;
            }
            ++n3;
        }
        if ((double)n2 > this.MorseThreshold * (double)dArray.length) {
            return new DiscreteFunction(dArray);
        }
        return new SparseDiscreteFunction(dArray);
    }

    public void add(MultiscaleFunction multiscaleFunction, MultiscaleFunction multiscaleFunction2) {
        DiscreteFunction[] discreteFunctionArray;
        if (multiscaleFunction == null || multiscaleFunction2 == null) {
            throw new NullPointerException("You cannot add a null object to the internal arrays.");
        }
        if (this.Fprimary != null) {
            discreteFunctionArray = this.Fprimary;
            this.Fprimary = new DiscreteFunction[discreteFunctionArray.length + 1];
            System.arraycopy(discreteFunctionArray, 0, this.Fprimary, 0, discreteFunctionArray.length);
            this.Fprimary[discreteFunctionArray.length] = this.toDiscreteFunction((MultiscaleFunction)multiscaleFunction.clone());
        } else {
            this.Fprimary = new DiscreteFunction[1];
            this.Fprimary[0] = this.toDiscreteFunction((MultiscaleFunction)multiscaleFunction.clone());
        }
        if (this.Fdual != null) {
            discreteFunctionArray = this.Fdual;
            this.Fdual = new DiscreteFunction[discreteFunctionArray.length + 1];
            System.arraycopy(discreteFunctionArray, 0, this.Fdual, 0, discreteFunctionArray.length);
            this.Fdual[discreteFunctionArray.length] = this.toDiscreteFunction((MultiscaleFunction)multiscaleFunction2.clone());
            return;
        }
        this.Fdual = new DiscreteFunction[1];
        this.Fdual[0] = this.toDiscreteFunction((MultiscaleFunction)multiscaleFunction2.clone());
    }

    public void add(MultiscaleFunction multiscaleFunction) {
        this.add(multiscaleFunction, multiscaleFunction);
    }

    public void add(MultiscaleFunction[] multiscaleFunctionArray) {
        int n = 0;
        while (n < multiscaleFunctionArray.length) {
            this.add(multiscaleFunctionArray[n], multiscaleFunctionArray[n]);
            ++n;
        }
    }

    public void add(Multiresolution multiresolution) {
        int n = this.DFunction.dimension();
        try {
            block2: while (true) {
                n = multiresolution.previousDimension(n);
                int n2 = 0;
                while (n2 < n) {
                    this.add(multiresolution.primaryScaling(n, n2), multiresolution.dualScaling(n, n2));
                    ++n2;
                }
                int n3 = 0;
                while (true) {
                    if (n3 >= n - multiresolution.getFilterType()) continue block2;
                    this.add(multiresolution.primaryWavelet(n, n3), multiresolution.dualWavelet(n, n3));
                    ++n3;
                }
                break;
            }
        }
        catch (IllegalScalingException illegalScalingException) {
            return;
        }
    }

    public double[] getResidues() {
        double[] dArray = this.getWeigths();
        double[] dArray2 = new double[dArray.length];
        int n = 0;
        while (n < dArray2.length) {
            double[] dArray3 = DiscreteHilbertSpace.add(this.DFunction, -dArray[n], this.Fprimary[n]);
            dArray2[n] = Math.sqrt(ArrayMath.sumSquares((double[])dArray3));
            ++n;
        }
        return dArray2;
    }

    public double getResidue(int n) {
        double[] dArray = DiscreteHilbertSpace.add(this.DFunction, -this.getWeigth(n), this.Fprimary[n]);
        return Math.sqrt(ArrayMath.sumSquares((double[])dArray));
    }

    public double[] getWeigths() {
        double[] dArray = new double[this.getSize()];
        int n = 0;
        while (n < this.getSize()) {
            SparseDiscreteFunction sparseDiscreteFunction;
            SparseDiscreteFunction sparseDiscreteFunction2;
            DiscreteFunction discreteFunction = this.DFunction;
            DiscreteFunction discreteFunction2 = this.Fdual[n];
            if (discreteFunction instanceof SparseDiscreteFunction && discreteFunction2 instanceof SparseDiscreteFunction) {
                sparseDiscreteFunction2 = (SparseDiscreteFunction)discreteFunction;
                sparseDiscreteFunction = (SparseDiscreteFunction)discreteFunction2;
                sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction2.evaluate()));
            }
            if (discreteFunction instanceof SparseDiscreteFunction) {
                sparseDiscreteFunction2 = (SparseDiscreteFunction)discreteFunction;
                if (discreteFunction2 instanceof SparseDiscreteFunction) {
                    sparseDiscreteFunction = (SparseDiscreteFunction)discreteFunction2;
                    sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction2.evaluate()));
                }
                sparseDiscreteFunction2.Data.scalarProduct(new DoubleVector(discreteFunction2.evaluate()));
            }
            if (discreteFunction2 instanceof SparseDiscreteFunction) {
                sparseDiscreteFunction2 = (SparseDiscreteFunction)discreteFunction2;
                if (discreteFunction instanceof SparseDiscreteFunction) {
                    sparseDiscreteFunction = (SparseDiscreteFunction)discreteFunction;
                    sparseDiscreteFunction2.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction.evaluate()));
                }
                sparseDiscreteFunction2.Data.scalarProduct(new DoubleVector(discreteFunction.evaluate()));
            }
            dArray[n] = ArrayMath.scalarProduct((double[])discreteFunction.evaluate(), (double[])discreteFunction2.evaluate());
            ++n;
        }
        return dArray;
    }

    public double getWeigth(int n) {
        SparseDiscreteFunction sparseDiscreteFunction;
        SparseDiscreteFunction sparseDiscreteFunction2;
        DiscreteFunction discreteFunction = this.DFunction;
        DiscreteFunction discreteFunction2 = this.Fdual[n];
        if (discreteFunction instanceof SparseDiscreteFunction && discreteFunction2 instanceof SparseDiscreteFunction) {
            sparseDiscreteFunction2 = (SparseDiscreteFunction)discreteFunction;
            sparseDiscreteFunction = (SparseDiscreteFunction)discreteFunction2;
            sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction2.evaluate()));
        }
        if (discreteFunction instanceof SparseDiscreteFunction) {
            sparseDiscreteFunction2 = (SparseDiscreteFunction)discreteFunction;
            if (discreteFunction2 instanceof SparseDiscreteFunction) {
                sparseDiscreteFunction = (SparseDiscreteFunction)discreteFunction2;
                sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction2.evaluate()));
            }
            sparseDiscreteFunction2.Data.scalarProduct(new DoubleVector(discreteFunction2.evaluate()));
        }
        if (discreteFunction2 instanceof SparseDiscreteFunction) {
            sparseDiscreteFunction2 = (SparseDiscreteFunction)discreteFunction2;
            if (discreteFunction instanceof SparseDiscreteFunction) {
                sparseDiscreteFunction = (SparseDiscreteFunction)discreteFunction;
                sparseDiscreteFunction2.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction.evaluate()));
            }
            sparseDiscreteFunction2.Data.scalarProduct(new DoubleVector(discreteFunction.evaluate()));
        }
        return ArrayMath.scalarProduct((double[])discreteFunction.evaluate(), (double[])discreteFunction2.evaluate());
    }

    public double norm() {
        double[] dArray = this.DFunction.evaluate(0);
        return Math.sqrt(ArrayMath.sumSquares((double[])dArray));
    }

    public int getSize() {
        if (this.Fprimary == null) {
            return 0;
        }
        return this.Fprimary.length;
    }

    protected static double norm(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    private double[][] scalarMultiply(double[][] dArray, double d) {
        double[][] dArray2 = new double[dArray.length][];
        int n = 0;
        while (n < dArray.length) {
            dArray2[n] = new double[dArray[n].length];
            int n2 = 0;
            while (n2 < dArray[n].length) {
                dArray2[n][n2] = d * dArray[n][n2];
                ++n2;
            }
            ++n;
        }
        return dArray2;
    }

    public double[] checkBiorthogonality() {
        double[] dArray = new double[this.getSize()];
        int n = 0;
        while (n < this.getSize()) {
            SparseDiscreteFunction sparseDiscreteFunction;
            SparseDiscreteFunction sparseDiscreteFunction2;
            DiscreteFunction discreteFunction = this.Fprimary[n];
            DiscreteFunction discreteFunction2 = this.Fdual[n];
            if (discreteFunction instanceof SparseDiscreteFunction && discreteFunction2 instanceof SparseDiscreteFunction) {
                sparseDiscreteFunction2 = (SparseDiscreteFunction)discreteFunction;
                sparseDiscreteFunction = (SparseDiscreteFunction)discreteFunction2;
                sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction2.evaluate()));
            }
            if (discreteFunction instanceof SparseDiscreteFunction) {
                sparseDiscreteFunction2 = (SparseDiscreteFunction)discreteFunction;
                if (discreteFunction2 instanceof SparseDiscreteFunction) {
                    sparseDiscreteFunction = (SparseDiscreteFunction)discreteFunction2;
                    sparseDiscreteFunction.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction2.evaluate()));
                }
                sparseDiscreteFunction2.Data.scalarProduct(new DoubleVector(discreteFunction2.evaluate()));
            }
            if (discreteFunction2 instanceof SparseDiscreteFunction) {
                sparseDiscreteFunction2 = (SparseDiscreteFunction)discreteFunction2;
                if (discreteFunction instanceof SparseDiscreteFunction) {
                    sparseDiscreteFunction = (SparseDiscreteFunction)discreteFunction;
                    sparseDiscreteFunction2.Data.scalarProduct(new DoubleVector(sparseDiscreteFunction.evaluate()));
                }
                sparseDiscreteFunction2.Data.scalarProduct(new DoubleVector(discreteFunction.evaluate()));
            }
            dArray[n] = ArrayMath.scalarProduct((double[])discreteFunction.evaluate(), (double[])discreteFunction2.evaluate());
            ++n;
        }
        return dArray;
    }

    protected static double[][] add(double[][] dArray, double[][] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Incompatible types " + dArray.length + ", " + dArray2.length);
        }
        double[][] dArray3 = new double[dArray.length][];
        int n = 0;
        while (n < dArray.length) {
            dArray3[n] = new double[dArray[n].length];
            if (dArray[n].length != dArray2[n].length) {
                throw new IllegalArgumentException("Incompatible types " + dArray.length + ", " + dArray2.length + " : " + dArray[n].length + ", " + dArray2[n].length);
            }
            int n2 = 0;
            while (n2 < dArray[n].length) {
                dArray3[n][n2] = dArray[n][n2] + dArray2[n][n2];
                ++n2;
            }
            ++n;
        }
        return dArray3;
    }
}

