/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.ArrayMath;
import JSci.maths.NumericalConstants;
import JSci.maths.wavelet.MultiscaleFunction;

public final class Cosine
extends MultiscaleFunction
implements NumericalConstants,
Cloneable {
    private int n0;
    private int freq;
    private double normalisation;
    double tol = Double.MIN_VALUE;

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][freq=");
        string.concat(Integer.toString(this.freq));
        string.concat("]");
        return string;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Cosine) {
            Cosine cosine = (Cosine)object;
            return this.n0 == cosine.n0 && this.freq == cosine.freq;
        }
        return false;
    }

    public int getFrequency() {
        return this.freq;
    }

    public Cosine(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("The length paramenter " + this.n0 + " must be positive");
        }
        if (n2 < 0 || n2 >= n) {
            throw new IllegalArgumentException("The frequency parameter " + n2 + " must be between " + 0 + " and " + (n - 1));
        }
        this.n0 = n;
        this.freq = n2;
        this.normalisation = Math.sqrt((double)this.n0 / 2.0);
        if (2 * this.freq == this.n0 || this.freq == 0) {
            this.normalisation *= 1.4142135623730951;
        }
    }

    public double[] evaluate() {
        return ArrayMath.scalarMultiply((double)(1.0 / this.normalisation), (double[])Cosine.evaluate(this.n0, this.freq));
    }

    private static double[] evaluate(int n, int n2) {
        double[] dArray = new double[n];
        int n3 = 0;
        while (n3 < dArray.length) {
            dArray[n3] = Math.cos(Math.PI * 2 * (double)n3 * (double)n2 / (double)n);
            ++n3;
        }
        return dArray;
    }

    public int dimension(int n) {
        return this.n0;
    }

    public int dimension() {
        return this.n0;
    }

    public Object clone() {
        Cosine cosine = (Cosine)super.clone();
        cosine.n0 = this.n0;
        cosine.freq = this.freq;
        return cosine;
    }

    public double[] evaluate(int n) {
        return ArrayMath.scalarMultiply((double)(1.0 / this.normalisation), (double[])Cosine.evaluate(this.n0, this.freq));
    }

    public double mass(double d, double d2, int n) {
        double d3 = 0.0;
        double[] dArray = ArrayMath.scalarMultiply((double)(1.0 / this.normalisation), (double[])Cosine.evaluate(this.n0, this.freq));
        int n2 = 0;
        while (n2 < dArray.length) {
            d3 += dArray[n2];
            ++n2;
        }
        d3 = d3 / (double)(dArray.length - 1) * Math.abs(d2 - d);
        return d3;
    }

    public int getFilterType() {
        return this.n0;
    }
}

