/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.ArrayMath;
import JSci.maths.wavelet.MultiscaleFunction;

public class DiscreteFunction
extends MultiscaleFunction
implements Cloneable {
    double[] Data;

    protected DiscreteFunction() {
    }

    public DiscreteFunction(double[] dArray) {
        this.setData(dArray);
    }

    public String toString() {
        return ArrayMath.toString((double[])this.Data);
    }

    public void normalize() {
        double[] dArray = this.Data;
        this.setData(ArrayMath.scalarMultiply((double)(1.0 / Math.sqrt(ArrayMath.sumSquares((double[])dArray))), (double[])dArray));
    }

    public void setData(double[] dArray) {
        this.Data = ArrayMath.copy((double[])dArray);
    }

    public double[] evaluate() {
        return this.Data;
    }

    public boolean equals(Object object) {
        DiscreteFunction discreteFunction;
        return object != null && object instanceof DiscreteFunction && ArrayMath.equals((double[])this.Data, (double[])(discreteFunction = (DiscreteFunction)object).evaluate(0));
    }

    public double[] evaluate(int n) {
        return this.evaluate();
    }

    public double mass(double d, double d2, int n) {
        double d3 = 0.0;
        double[] dArray = this.evaluate(n);
        int n2 = 0;
        while (n2 < dArray.length) {
            d3 += dArray[n2];
            ++n2;
        }
        d3 = d3 / (double)(dArray.length - 1) * Math.abs(d2 - d);
        return d3;
    }

    public double norm() {
        double[] dArray = this.evaluate();
        return Math.sqrt(ArrayMath.sumSquares((double[])dArray));
    }

    public double norm(int n) {
        double[] dArray = this.evaluate(n);
        return Math.sqrt(ArrayMath.sumSquares((double[])dArray));
    }

    public Object clone() {
        DiscreteFunction discreteFunction = (DiscreteFunction)super.clone();
        discreteFunction.Data = ArrayMath.copy((double[])this.Data);
        return discreteFunction;
    }

    public int dimension(int n) {
        return this.Data.length;
    }

    public int dimension() {
        return this.Data.length;
    }

    public int getFilterType() {
        return this.Data.length;
    }
}

